/*
 * Decompiled with CFR 0.152.
 */
package com.glaivestone.javax.execution;

import com.glaivestone.javax.devx.DebugSupport;
import java.io.File;
import java.io.IOException;

public class OperatingSystemHelper {
    public static final OperatingSystemHelper CURRENT = new OperatingSystemHelper();
    public static final String DEFAULT_ARG_ENCLOSING_QUOTE = "\"";
    protected final String osName;
    protected final boolean isWindows;
    protected final boolean isMac;

    public static OperatingSystemHelper current() {
        return CURRENT;
    }

    protected OperatingSystemHelper() {
        String os;
        this.osName = os = System.getProperty("os.name").toLowerCase();
        this.isWindows = os.startsWith("windows");
        this.isMac = os.startsWith("mac");
    }

    public boolean isMac() {
        return this.isMac;
    }

    public boolean isWindows() {
        return this.isWindows;
    }

    public void openFile(File aFile) throws IOException {
        String pathName = aFile.getAbsolutePath();
        String pathNameArg = this.toCommandLineArg(pathName);
        String cmd = null;
        if (this.isWindows()) {
            cmd = "cmd /c start " + pathNameArg;
        } else if (this.isMac()) {
            cmd = "open " + pathNameArg;
        }
        if (cmd == null) {
            throw new UnsupportedOperationException("Open file operation not supported on " + this.osName);
        }
        DebugSupport.current().dump(cmd);
        Runtime.getRuntime().exec(cmd);
    }

    public void openDirectory(File aFile) throws IOException {
        String pathName = aFile.getAbsolutePath();
        String pathNameArg = this.toCommandLineArg(pathName);
        String cmd = null;
        if (this.isWindows()) {
            cmd = "cmd /c explorer " + pathNameArg;
        } else if (this.isMac()) {
            cmd = "open " + pathNameArg;
        }
        if (cmd == null) {
            throw new UnsupportedOperationException("Open directory operation not supported on " + this.osName);
        }
        Runtime.getRuntime().exec(cmd);
    }

    public String toCommandLineArg(String aString) {
        return this.toCommandLineArg(aString, DEFAULT_ARG_ENCLOSING_QUOTE);
    }

    public String toCommandLineArg(String aString, String enclosingQuote) {
        int start;
        if (aString.indexOf(32) == -1) {
            return aString;
        }
        StringBuffer sb = new StringBuffer();
        int indexQC = start = 0;
        String doubledQuote = enclosingQuote + enclosingQuote;
        sb.append(enclosingQuote);
        while ((indexQC = aString.indexOf(enclosingQuote, start)) != -1) {
            sb.append(aString.substring(start, indexQC));
            sb.append(doubledQuote);
            start = indexQC + 1;
        }
        sb.append(aString.substring(start));
        sb.append(enclosingQuote);
        return sb.toString();
    }
}

