/*
 * Decompiled with CFR 0.152.
 */
package com.glaivestone.javax.util;

import com.glaivestone.javax.util.Numbers;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.TimeZone;

public class SimpleDate
implements Comparable<SimpleDate> {
    public static final String[] MONTH_NAMES = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
    public static final String[] SHORT_MONTH_NAMES = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    public static final String DATE_SEPARATOR = "-";
    public static TimeZone defaultTimeZone = TimeZone.getDefault();
    public static Locale defaultLocale = Locale.getDefault();
    protected Calendar date;

    public static int toMonthIndex(String monthName) {
        for (int i = 0; i < MONTH_NAMES.length; ++i) {
            if (!monthName.equals(SHORT_MONTH_NAMES[i]) && !monthName.equals(MONTH_NAMES[i])) continue;
            return i + 1;
        }
        throw new IllegalArgumentException("Unknown month name: " + monthName);
    }

    public SimpleDate() {
        this(defaultTimeZone, defaultLocale);
    }

    public SimpleDate(Date aDate) {
        this(defaultTimeZone, defaultLocale, aDate);
    }

    public SimpleDate(int year, int monthIndex, int day) {
        this(defaultTimeZone, defaultLocale, year, monthIndex, day);
    }

    public SimpleDate(String dateString) {
        this(defaultTimeZone, defaultLocale, dateString);
    }

    public SimpleDate(int year, String monthName, int day) {
        this(defaultTimeZone, defaultLocale, year, monthName, day);
    }

    public SimpleDate(TimeZone aTimeZone, Locale aLocale) {
        this.date = new GregorianCalendar(aTimeZone, aLocale);
        this.clearTimeOfDay();
    }

    public SimpleDate(TimeZone aTimeZone, Locale aLocale, Date aDate) {
        this.date = new GregorianCalendar(aTimeZone, aLocale);
        this.date.setTime(aDate);
        this.clearTimeOfDay();
    }

    public SimpleDate(TimeZone aTimeZone, Locale aLocale, int year, int monthIndex, int day) {
        this.date = new GregorianCalendar(aTimeZone, aLocale);
        this.clearTimeOfDay();
        this.setDate(year, monthIndex, day);
    }

    public SimpleDate(TimeZone aTimeZone, Locale aLocale, int year, String monthName, int day) {
        this(aTimeZone, aLocale, year, SimpleDate.toMonthIndex(monthName), day);
    }

    public SimpleDate(TimeZone aTimeZone, Locale aLocale, String dateString) {
        this.date = new GregorianCalendar(aTimeZone, aLocale);
        this.clearTimeOfDay();
        this.setDate(dateString);
    }

    protected void clearTimeOfDay() {
        this.date.set(11, 0);
        this.date.set(12, 0);
        this.date.set(13, 0);
        this.date.set(14, 0);
    }

    @Override
    public int compareTo(SimpleDate other) {
        return Numbers.compare(this.intValue(), other.intValue());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        return obj instanceof SimpleDate && this.equals((SimpleDate)obj);
    }

    public boolean equals(SimpleDate aDate) {
        return this.intValue() == aDate.intValue();
    }

    public Calendar getCalendarDate() {
        return this.date;
    }

    public int getDay() {
        return this.date.get(5);
    }

    public int getMonthIndex() {
        return this.date.get(2) + 1;
    }

    public String getMonthName() {
        return MONTH_NAMES[this.getMonthIndex() - 1];
    }

    public String getMonthShortName() {
        return SHORT_MONTH_NAMES[this.getMonthIndex() - 1];
    }

    public int getYear() {
        return this.date.get(1);
    }

    public int hashCode() {
        return this.intValue();
    }

    public int intValue() {
        return this.getYear() * 1000 + this.date.get(6);
    }

    public void setDate(int year, int monthIndex, int day) {
        this.validateMonthIndex(monthIndex);
        this.validateDay(day);
        this.date.set(year, monthIndex - 1, day);
    }

    public void setDate(String dateString) {
        int year;
        int monthIndex;
        int dayIndex;
        StringTokenizer parser = new StringTokenizer(dateString, DATE_SEPARATOR);
        String fieldName = null;
        String aToken = null;
        if (parser.countTokens() != 3) {
            throw new IllegalArgumentException("Invalid format for standard date string: " + dateString);
        }
        try {
            fieldName = "day";
            aToken = parser.nextToken();
            dayIndex = Integer.parseInt(aToken);
            monthIndex = SimpleDate.toMonthIndex(parser.nextToken());
            fieldName = "year";
            aToken = parser.nextToken();
            year = Integer.parseInt(aToken);
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("Invalid " + fieldName + " number ( " + aToken + "): " + ex.getLocalizedMessage());
        }
        this.setDate(year, monthIndex, dayIndex);
    }

    public void setDay(int day) {
        this.validateDay(day);
        this.date.set(5, day);
    }

    public void setMonth(int monthIndex) {
        this.validateMonthIndex(monthIndex);
        this.date.set(2, monthIndex - 1);
    }

    public void setMonth(String monthName) {
        this.setMonth(SimpleDate.toMonthIndex(monthName));
    }

    public void setYear(int year) {
        this.date.set(1, year);
    }

    public String toStandardString() {
        String year = Integer.toString(this.getYear());
        String month = this.getMonthShortName();
        String day = this.toTwoDigitString(this.getDay());
        return day + DATE_SEPARATOR + month + DATE_SEPARATOR + year;
    }

    public String toString() {
        return this.toStandardString();
    }

    protected String toTwoDigitString(int index) {
        String digitString = Integer.toString(index);
        if (index < 10) {
            digitString = "0" + digitString;
        }
        return digitString;
    }

    protected void validateDay(int day) {
        if (day < 1 || day > 31) {
            throw new IllegalArgumentException("Invalid day: " + day + " not in range [1..31]");
        }
    }

    protected void validateMonthIndex(int monthIndex) {
        if (monthIndex < 1 || monthIndex > 12) {
            throw new IllegalArgumentException("Invalid month index: " + monthIndex + " not in range [1..12]");
        }
    }
}

