/*
 * Decompiled with CFR 0.152.
 */
package com.glaivestone.toolbox.settings;

import com.glaivestone.toolbox.settings.SettingsCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class StandardSettingsCollection
implements SettingsCollection {
    protected Map<String, Object> values;

    public StandardSettingsCollection() {
        this.initialize();
    }

    protected Map<String, Object> constructValues() {
        return new TreeMap<String, Object>();
    }

    @Override
    public boolean containsSetting(String name) {
        return this.values.containsKey(name);
    }

    protected void initialize() {
        this.values = this.constructValues();
    }

    @Override
    public List<Object> getListValue(String name) {
        return (List)this.values.get(name);
    }

    @Override
    public List<String> getNames() {
        return new ArrayList<String>(this.values.keySet());
    }

    @Override
    public Object getSimpleValue(String name) {
        return this.values.get(name);
    }

    @Override
    public String getStringValue(String name) {
        String value = (String)this.getSimpleValue(name);
        return value != null ? value.trim() : null;
    }

    @Override
    public void removeSetting(String name) {
        this.values.remove(name);
    }

    @Override
    public void setValue(String name, Object value) {
        this.values.put(name, value);
    }

    @Override
    public int size() {
        return this.values.size();
    }

    public String toString() {
        List<String> entries = this.getNames();
        Collections.sort(entries);
        for (int i = 0; i < entries.size(); ++i) {
            String name = entries.get(i);
            entries.set(i, String.format("%s=%s", name, this.values.get(name)));
        }
        return String.format("%s%s", this.getClass().getSimpleName(), entries);
    }
}

