/*
 * Decompiled with CFR 0.152.
 */
package com.glaivestone.toolbox.settings;

import com.glaivestone.toolbox.settings.SettingsSection;
import com.glaivestone.toolbox.settings.StandardSettings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class StandardSettingsSection
extends StandardSettings
implements SettingsSection {
    public static final String NAME_SEPARATOR = ".";
    public static final char NAME_SEPARATOR_CHAR = ".".charAt(0);
    public static final String DEFAULT_SECTION_NAME = null;
    public static Comparator<String> SECTION_SORTER = new Comparator<String>(){

        @Override
        public int compare(String s1, String s2) {
            return s1.compareTo(s2);
        }
    };
    protected static final List<Object> EMPTY_LIST = Collections.unmodifiableList(new ArrayList());
    protected static final List<String> EMPTY_STRING_LIST = Collections.unmodifiableList(new ArrayList());
    protected String name;
    protected StandardSettingsSection parent;
    protected Map<String, StandardSettingsSection> subsections;

    public StandardSettingsSection() {
        this(DEFAULT_SECTION_NAME);
    }

    public StandardSettingsSection(String sectionName) {
        this.name = sectionName;
    }

    @Override
    public void addSection(SettingsSection newSection) {
        this.addSubsection((StandardSettingsSection)newSection);
    }

    protected void addSubsection(StandardSettingsSection newSection) {
        String sectionName = newSection.getName();
        if (newSection.getParent() != null) {
            newSection.getParent().removeSection(sectionName);
        }
        newSection.setParent(this);
        this.subsections.put(sectionName, newSection);
    }

    protected StandardSettingsSection constructSection(String sectionName) {
        return new StandardSettingsSection(sectionName);
    }

    protected Map<String, StandardSettingsSection> constructSubsections() {
        return new TreeMap<String, StandardSettingsSection>(SECTION_SORTER);
    }

    @Override
    public SettingsSection createSection(String sectionName) {
        StandardSettingsSection newSection = this.constructSection(sectionName);
        this.addSubsection(newSection);
        return newSection;
    }

    @Override
    public String getDescription() {
        return this.getQualifiedName();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<String> getSectionNames() {
        if (this.subsections.size() == 0) {
            return EMPTY_STRING_LIST;
        }
        return new ArrayList<String>(this.subsections.keySet());
    }

    protected StandardSettingsSection getParent() {
        return this.parent;
    }

    @Override
    public String getQualifiedName() {
        String parentName;
        String qName = this.getName();
        if (this.getParent() != null && (parentName = this.getParent().getQualifiedName()) != null) {
            qName = parentName + NAME_SEPARATOR + qName;
        }
        return qName;
    }

    @Override
    public SettingsSection getSection(String sectionName) {
        return this.subsections.get(sectionName);
    }

    @Override
    public SettingsSection getOptionalSection(String sectionName) {
        SettingsSection settingsSection = this.getSection(sectionName);
        if (settingsSection == null) {
            settingsSection = new StandardSettingsSection(sectionName);
        }
        return settingsSection;
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.subsections = this.constructSubsections();
    }

    @Override
    public void removeSection(String sectionName) {
        SettingsSection aSubsection = this.getSection(sectionName);
        if (aSubsection == null) {
            return;
        }
        ((StandardSettingsSection)aSubsection).setParent(null);
        this.subsections.remove(sectionName);
    }

    protected void setParent(StandardSettingsSection parent) {
        this.parent = parent;
    }

    public String toString() {
        return String.format("%s <%s>", this.getClass().getSimpleName(), this.getQualifiedName());
    }
}

