/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.io;

import com.glaivestone.toolbox.text.csv.CSVParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;

public class CSVDataReader {
    public static final char COMMENT_CHAR = '#';
    public static final String COMMENT_LINE_PREFIX = "#";
    protected boolean filterCommentLines;
    protected CSVParser csvParser;
    protected List<String[]> entries;

    public CSVDataReader() {
        this(false);
    }

    public CSVDataReader(boolean filterCommentLines) {
        this.setFilterCommentLines(filterCommentLines);
        this.initParser();
    }

    public List<String[]> getEntries() {
        return this.entries;
    }

    protected void initParser() {
        this.csvParser = new CSVParser();
    }

    protected void loadData(BufferedReader aReader) throws IOException {
        String inputLine = null;
        int lineIndex = 0;
        this.entries = new ArrayList<String[]>();
        while ((inputLine = aReader.readLine()) != null) {
            ++lineIndex;
            if ((inputLine = this.normalizeInputLine(inputLine)) == null) continue;
            String[] values = this.processInputLine(inputLine);
            this.entries.add(values);
        }
    }

    public void loadData(File aFile) throws IOException, FileNotFoundException {
        try (BufferedReader aReader = new BufferedReader(new FileReader(aFile));){
            this.loadData(aReader);
        }
    }

    public void loadData(String textData) throws IOException {
        try (BufferedReader aReader = new BufferedReader(new StringReader(textData));){
            this.loadData(aReader);
        }
    }

    protected String normalizeInputLine(String inputLine) {
        if (inputLine.length() == 0) {
            return null;
        }
        if (this.filterCommentLines && inputLine.startsWith(COMMENT_LINE_PREFIX)) {
            return null;
        }
        String trimmedLine = inputLine.trim();
        return trimmedLine.length() == 0 ? null : trimmedLine;
    }

    protected String[] processInputLine(String inputLine) {
        return this.csvParser.getStringValues(inputLine);
    }

    public void setFilterCommentLines(boolean filterCommentLines) {
        this.filterCommentLines = filterCommentLines;
    }

    public int size() {
        return this.entries == null ? 0 : this.entries.size();
    }
}

