/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.io;

import com.glaivestone.javax.devx.Assert;
import com.glaivestone.javax.execution.EvaluableAction;
import com.glaivestone.toolbox.text.csv.CSVParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import org.ussamasters.aces.racedata.io.RaceDataIOException;
import org.ussamasters.aces.racedata.io.RaceDataIOServices;
import org.ussamasters.aces.racedata.io.RaceDataReader;
import org.ussamasters.aces.racedata.models.Gender;
import org.ussamasters.aces.racedata.models.RaceClass;
import org.ussamasters.aces.racedata.models.RaceClassHelper;
import org.ussamasters.aces.racedata.models.RaceOrganization;
import org.ussamasters.aces.racedata.models.SeasonConfiguration;
import org.ussamasters.aces.racedata.models.SeasonIdentifier;
import org.ussamasters.aces.racedata.models.WorldCupPointsType;

public abstract class RaceDataCSVReader
extends RaceDataReader {
    private String currentFormat;
    private List<String> supportedFormats;
    private BufferedReader reader;
    private CSVParser csvParser;
    private String fileFormat;
    private String currentInputLine;
    protected SeasonIdentifier season;
    protected RaceClassHelper raceClassHelper;

    protected RaceDataCSVReader(String currentFormat, List<String> supportedFormats) {
        this.currentFormat = currentFormat;
        this.supportedFormats = supportedFormats;
        this.csvParser = this.constructCSVParser();
    }

    protected CSVParser constructCSVParser() {
        return new CSVParser();
    }

    protected RaceDataIOException constructUnsupportedFormatException() {
        return this.constructUnsupportedFormatException(this.fileFormat);
    }

    protected RaceDataIOException constructUnsupportedFormatException(String aFileFormat) {
        return new RaceDataIOException("Unsupported file format: '" + aFileFormat + "'");
    }

    protected List<String> getSupportedFormats() {
        return this.supportedFormats;
    }

    protected String getCurrentFormat() {
        return this.currentFormat;
    }

    protected SeasonIdentifier getSeason() {
        return this.season;
    }

    protected SeasonConfiguration getSeasonConfiguration() {
        return SeasonConfiguration.getSeasonConfig(this.season);
    }

    protected EvaluableAction getResolveClassAction(Class<? extends RaceClass<?>> raceClassClass) {
        return RaceClass.getResolveNameAction(raceClassClass);
    }

    protected boolean isCurrentFormat(String fileFormat) {
        return this.getCurrentFormat().equals(fileFormat);
    }

    protected boolean isEmptyLine(String inputLine) {
        return inputLine == null || inputLine.length() == 0;
    }

    protected boolean isEmptyOrCommentLine(String inputLine) {
        return inputLine == null || inputLine.length() == 0 || inputLine.charAt(0) == '#';
    }

    protected boolean isLoadingFormat(String aFileFormat) {
        return this.fileFormat.equals(aFileFormat);
    }

    protected boolean isSupportedFormat(String aFileFormat) {
        for (int i = 0; i < this.getSupportedFormats().size(); ++i) {
            String supportedFormat = this.getSupportedFormats().get(i);
            if (!aFileFormat.equals(supportedFormat)) continue;
            return true;
        }
        return this.getSupportedFormats().contains(aFileFormat);
    }

    @Override
    public void load(Reader aReader) throws RaceDataIOException {
        this.setReader((BufferedReader)aReader);
        try {
            this.loadData();
        }
        catch (RuntimeException ex) {
            throw new RaceDataIOException((Exception)ex, this.currentInputLine);
        }
    }

    protected abstract void loadData() throws RaceDataIOException;

    protected String[] parseCSVString(String csvString) {
        return this.csvParser.getStringValues(csvString);
    }

    protected int parseIntegerValue(String aString, String valueDescription) throws RaceDataIOException {
        try {
            return Integer.parseInt(aString);
        }
        catch (NumberFormatException ex) {
            throw new RaceDataIOException(ex, this.currentInputLine, "Invalid " + valueDescription + " (not an integer value)");
        }
    }

    protected SeasonIdentifier parseSeason(String inputLine) throws RaceDataIOException {
        String literalString = inputLine;
        String[] years = inputLine.split("-");
        if (years.length == 1) {
            int startYear = this.parseIntegerValue(inputLine, "Season start year line");
            int endYear = startYear + 1;
            literalString = String.format("%04d-%04d", startYear, endYear);
        }
        return RaceDataIOServices.seasonFromLiteral(literalString);
    }

    protected String readBlankHeaderTerminationLine() throws RaceDataIOException {
        String inputLine = this.readLine();
        this.validateBlankHeaderTerminationLine(inputLine);
        return inputLine;
    }

    protected String readFileFormatLine() throws RaceDataIOException {
        this.fileFormat = this.readLine();
        this.validateFormat(this.fileFormat);
        return this.fileFormat;
    }

    protected int readIntegerValueLine(String inputLineDescription) throws RaceDataIOException {
        try {
            return Integer.parseInt(this.readLine());
        }
        catch (NumberFormatException ex) {
            throw new RaceDataIOException(ex, this.currentInputLine, "Invalid " + inputLineDescription + " (not an integer value)");
        }
    }

    protected String readLine() throws RaceDataIOException {
        try {
            this.currentInputLine = this.reader.readLine();
        }
        catch (IOException ex) {
            throw new RaceDataIOException(ex);
        }
        if (this.currentInputLine != null) {
            this.currentInputLine = this.currentInputLine.trim();
        }
        return this.currentInputLine;
    }

    protected String readNextCSVLine() throws RaceDataIOException {
        String inputLine;
        while ((inputLine = this.readLine()) != null) {
            if (this.isEmptyOrCommentLine(inputLine)) continue;
            return inputLine;
        }
        return null;
    }

    protected Class<? extends RaceClass<?>> readRaceClassClassLine(String valueDescription) throws RaceDataIOException {
        if (this.season == null) {
            throw new IllegalStateException("Season line not read to set season context for loading race class references");
        }
        return this.resolveRaceClassClass(this.readLine(), valueDescription);
    }

    protected RaceOrganization readRaceOrganizationLine() throws RaceDataIOException {
        String organizationName = this.readLine();
        RaceOrganization anOrganization = RaceOrganization.getConstant(organizationName);
        if (anOrganization == null) {
            throw new RaceDataIOException("***ERROR: Unknown organization: " + organizationName);
        }
        return anOrganization;
    }

    protected SeasonIdentifier readSeasonLine() throws RaceDataIOException {
        this.setSeason(this.parseSeason(this.readLine()));
        return this.season;
    }

    protected WorldCupPointsType readWorldCupPointsLine(String valueDescription) throws RaceDataIOException {
        return this.resolveWorldCupPointsType(this.readLine(), valueDescription);
    }

    protected RaceClass<?> resolveRaceClass(Gender gender, int age, EvaluableAction resolveRaceClassAction, String valueDescription) throws RaceDataIOException {
        RaceClass aRaceClass = (RaceClass)resolveRaceClassAction.evaluate(gender, new Integer(age));
        if (aRaceClass == null) {
            throw new RaceDataIOException((Object)this.currentInputLine, "Unknown " + valueDescription + " '" + gender + ", age " + age + "'");
        }
        return aRaceClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RaceClass<?> resolveRaceClass(String raceClassName, EvaluableAction resolveRaceClassAction, String valueDescription) throws RaceDataIOException {
        RaceClass aRaceClass;
        EvaluableAction evaluableAction = resolveRaceClassAction;
        synchronized (evaluableAction) {
            aRaceClass = (RaceClass)resolveRaceClassAction.evaluate(raceClassName);
        }
        if (aRaceClass == null) {
            throw new RaceDataIOException((Object)this.currentInputLine, "Unknown " + valueDescription + " '" + raceClassName + "'");
        }
        return aRaceClass;
    }

    protected Class<? extends RaceClass<?>> resolveRaceClassClass(String raceClassName, String valueDescription) throws RaceDataIOException {
        Class<? extends RaceClass<?>> raceClassClass = this.raceClassHelper.raceClassClassFromLiteral(raceClassName);
        if (raceClassClass == null) {
            throw new RaceDataIOException("***ERROR: Unknown " + valueDescription + " type: " + raceClassName);
        }
        return raceClassClass;
    }

    protected WorldCupPointsType resolveWorldCupPointsType(String pointsFlavor, String valueDescription) throws RaceDataIOException {
        WorldCupPointsType scoringType = RaceDataIOServices.worldCupPointsTypeFromLiteral(pointsFlavor);
        if (scoringType == null) {
            throw new RaceDataIOException("***ERROR: Unknown " + valueDescription + " type: " + pointsFlavor);
        }
        return scoringType;
    }

    protected void setReader(BufferedReader reader) {
        this.reader = reader;
    }

    protected SeasonIdentifier setSeason(SeasonIdentifier season) {
        this.season = season;
        this.raceClassHelper = new RaceClassHelper(this.season);
        return season;
    }

    protected void validateBlankHeaderTerminationLine(String inputLine) {
        Assert.expected(inputLine == null || inputLine.length() == 0, "Blank line expected after header lines but found '" + inputLine + "'");
    }

    protected void validateFormat(String aFileFormat) throws RaceDataIOException {
        if (!this.isSupportedFormat(aFileFormat)) {
            throw this.constructUnsupportedFormatException(aFileFormat);
        }
    }
}

