/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.io;

import com.glaivestone.javax.io.FileType;
import com.glaivestone.toolbox.text.csv.CSVFormatter;
import java.io.PrintWriter;
import java.io.Writer;
import org.ussamasters.aces.racedata.io.RaceDataIOConstants;
import org.ussamasters.aces.racedata.io.RaceDataIOServices;
import org.ussamasters.aces.racedata.io.RaceDataWriter;
import org.ussamasters.aces.racedata.models.RaceClass;
import org.ussamasters.aces.racedata.models.RaceClassHelper;
import org.ussamasters.aces.racedata.models.RaceOrganization;
import org.ussamasters.aces.racedata.models.SeasonIdentifier;
import org.ussamasters.aces.racedata.models.WorldCupPointsType;

public abstract class RaceDataCSVWriter
extends RaceDataWriter {
    protected CSVFormatter formatter = this.constructCSVFormatter();
    protected SeasonIdentifier season;
    protected RaceClassHelper raceClassHelper;

    protected CSVFormatter constructCSVFormatter() {
        return new CSVFormatter();
    }

    @Override
    protected FileType fileType() {
        return RaceDataIOConstants.FILE_TYPE_CSV;
    }

    protected SeasonIdentifier setSeason(SeasonIdentifier season) {
        this.season = season;
        this.raceClassHelper = new RaceClassHelper(this.season);
        return season;
    }

    protected String toCSVString(String[] values) {
        return this.formatter.format(values);
    }

    public abstract void write(PrintWriter var1);

    @Override
    public void write(Writer aWriter) {
        PrintWriter pw = aWriter instanceof PrintWriter ? (PrintWriter)aWriter : new PrintWriter(aWriter);
        this.write(pw);
    }

    protected void writeCSVColumnNamesComment(PrintWriter pw, String[] columnNames) {
        pw.print("# ");
        pw.println(this.toCSVString(columnNames));
    }

    protected void writeRaceClassClassLine(PrintWriter pw, Class<? extends RaceClass<?>> raceClassClass) {
        pw.println(this.raceClassHelper.raceClassClassToLiteral(raceClassClass));
    }

    protected void writeRaceOrganizationLine(PrintWriter pw, RaceOrganization anOrganization) {
        pw.println(anOrganization.name);
    }

    protected void writeSeasonLine(PrintWriter pw, SeasonIdentifier season) {
        this.setSeason(season);
        pw.println(RaceDataIOServices.seasonToLiteral(season));
    }

    protected void writeWorldCupPointsLine(PrintWriter pw, WorldCupPointsType scoringType) {
        pw.println(RaceDataIOServices.worldCupPointsTypeToLiteral(scoringType));
    }
}

