/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.io;

import com.glaivestone.toolbox.text.csv.CSVFormatter;
import com.glaivestone.toolbox.text.csv.CSVParser;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.ussamasters.aces.racedata.io.RaceDataIOConstants;
import org.ussamasters.aces.racedata.io.RaceDataIOException;
import org.ussamasters.aces.racedata.models.RaceClass;
import org.ussamasters.aces.racedata.models.RaceClassRegistry;
import org.ussamasters.aces.racedata.models.RaceClassType;
import org.ussamasters.aces.racedata.models.RaceDate;
import org.ussamasters.aces.racedata.models.RaceIdentifier;
import org.ussamasters.aces.racedata.models.RaceLocation;
import org.ussamasters.aces.racedata.models.RaceType;
import org.ussamasters.aces.racedata.models.SeasonConfiguration;
import org.ussamasters.aces.racedata.models.SeasonIdentifier;
import org.ussamasters.aces.racedata.models.WorldCupPointsType;
import org.ussamasters.aces.racedata.scoring.SeriesStandings;

public class RaceDataIOServices {
    public static int INDEX_LAST_NAME = 0;
    public static int INDEX_FIRST_NAME = 1;
    protected static final Map<Class<? extends RaceClass<?>>, String> RACE_CLASS_CLASS_LITERALS = RaceDataIOServices.constructRaceClassClassLiterals();
    protected static final Map<RaceClassType, String> RACE_CLASS_TYPE_LITERALS = RaceDataIOServices.constructRaceClassTypeLiterals();
    protected static CSVFormatter csvFormatter = new CSVFormatter();
    protected static CSVParser csvParser = new CSVParser();

    private RaceDataIOServices() {
    }

    protected static Map<Class<? extends RaceClass<?>>, String> constructRaceClassClassLiterals() {
        HashMap mappingTable = new HashMap();
        for (Class<RaceClass<?>> raceClassClass : RaceClass.getAllRaceClasses()) {
            String simpleName = RaceClassRegistry.current().getRaceClassType(raceClassClass).raceClassId;
            mappingTable.put(raceClassClass, simpleName + "es");
        }
        return Collections.unmodifiableMap(mappingTable);
    }

    protected static Map<RaceClassType, String> constructRaceClassTypeLiterals() {
        HashMap<RaceClassType, String> mappingTable = new HashMap<RaceClassType, String>();
        for (RaceClassType raceClassType : RaceClassType.values()) {
            String simpleName = raceClassType.raceClassId;
            mappingTable.put(raceClassType, simpleName + "es");
        }
        return Collections.unmodifiableMap(mappingTable);
    }

    public static String csvStringFromRace(RaceIdentifier aRace) {
        return RaceDataIOServices.toCSVString(RaceDataIOServices.csvValuesFromRace(aRace));
    }

    public static String[] csvValuesFromRace(RaceIdentifier aRace) {
        boolean hasQualifier = aRace.hasQualifier();
        int nColumns = hasQualifier ? 4 : 3;
        String[] values = new String[nColumns];
        values[0] = aRace.getDate().toDigitString();
        values[1] = aRace.getLocation().name;
        values[2] = aRace.getType().name;
        if (hasQualifier) {
            values[3] = aRace.getQualifier();
        }
        return values;
    }

    public static RaceIdentifier csvStringToRace(String csvString) throws RaceDataIOException {
        return RaceDataIOServices.csvValuesToRace(RaceDataIOServices.toCSVValues(csvString));
    }

    public static RaceIdentifier csvValuesToRace(String[] values) throws RaceDataIOException {
        boolean hasQualifier = values.length > 3;
        try {
            return new RaceIdentifier(RaceDate.fromDigitString(values[0]), RaceLocation.getConstant(values[1]), RaceType.getConstant(values[2]), hasQualifier ? values[3] : null);
        }
        catch (IllegalArgumentException ex) {
            throw new RaceDataIOException("Invalid race specification {" + new CSVFormatter().format(values) + "}");
        }
    }

    public static String[] parseRaceEntryName(String raceEntryName) {
        String entryName = raceEntryName.trim();
        int indexSeparator = entryName.indexOf(44);
        if (indexSeparator == -1) {
            indexSeparator = entryName.indexOf(32);
            if (entryName.toLowerCase().startsWith("van ") || entryName.toLowerCase().startsWith("de ") || entryName.toLowerCase().startsWith("mc ")) {
                indexSeparator = entryName.indexOf(32, indexSeparator + 1);
            }
        }
        String[] names = new String[2];
        if (indexSeparator == -1) {
            names[RaceDataIOServices.INDEX_LAST_NAME] = entryName;
            names[RaceDataIOServices.INDEX_FIRST_NAME] = "";
        } else {
            names[RaceDataIOServices.INDEX_LAST_NAME] = entryName.substring(0, indexSeparator).trim();
            names[RaceDataIOServices.INDEX_FIRST_NAME] = entryName.substring(indexSeparator + 1).trim();
        }
        return names;
    }

    public static Class<? extends RaceClass<?>> raceClassFromLiteral(String raceClassLiteral, SeasonIdentifier season) {
        return SeasonConfiguration.resolveRaceClassLiteral(raceClassLiteral, season);
    }

    public static String raceClassToLiteral(Class<? extends RaceClass<?>> raceClassClass) {
        return RACE_CLASS_CLASS_LITERALS.get(raceClassClass);
    }

    public static String raceClassTypeToLiteral(RaceClassType raceClassType) {
        return RACE_CLASS_TYPE_LITERALS.get(raceClassType);
    }

    public static String seasonToLiteral(SeasonIdentifier season) {
        return season.toSeasonYearsString();
    }

    public static SeasonIdentifier seasonFromLiteral(String value) throws RaceDataIOException {
        int startYear;
        String[] years = value.split("-");
        if (years.length != 2) {
            throw new RaceDataIOException(String.format("Invalid season years string: '%s' is not 'startYear-endYear'", value));
        }
        int endYear = 0;
        try {
            startYear = Integer.parseInt(years[0].trim());
            endYear = Integer.parseInt(years[1].trim());
        }
        catch (NumberFormatException ex) {
            throw new RaceDataIOException(ex, value, String.format("Invalid season years string: '%s' is not 'startYear-endYear'", value));
        }
        SeasonIdentifier season = SeasonIdentifier.forSeason(endYear);
        if (season == null) {
            throw new RaceDataIOException(String.format("Invalid season '%s': no SeasonIdentifier registered", value));
        }
        if (season.startYear != startYear && season.endYear != endYear) {
            throw new RaceDataIOException(String.format("Invalid season '%s': registered season are %s", value, season.toDescriptionString()));
        }
        return season;
    }

    public static WorldCupPointsType worldCupPointsTypeFromLiteral(String scoringType) {
        return WorldCupPointsType.forFormula(scoringType);
    }

    public static String worldCupPointsTypeToLiteral(WorldCupPointsType scoringType) {
        return scoringType.formulaId;
    }

    public static String raceResultsRootFileName(RaceIdentifier raceID) {
        return raceID.toReferenceString();
    }

    public static String raceResultsBaseFileName(RaceIdentifier aRace) {
        return RaceDataIOServices.raceResultsRootFileName(aRace);
    }

    public static String raceResultsFileName(RaceIdentifier aRace) {
        return RaceDataIOConstants.FILE_TYPE_RACE_RESULTS_DATA.composeFileName(RaceDataIOServices.raceResultsBaseFileName(aRace));
    }

    public static String seriesStandingsBaseFileName(SeriesStandings standings) {
        return RaceDataIOServices.seriesStandingsRootFileName(standings) + "-" + standings.referenceNameOrganizationQualifier();
    }

    public static String seriesStandingsRootFileName(SeriesStandings standings) {
        return standings.rootReferenceName() + "-" + standings.referenceNameScoringPolicyQualifer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toCSVString(String[] csvValues) {
        String csvString;
        CSVFormatter cSVFormatter = csvFormatter;
        synchronized (cSVFormatter) {
            csvString = csvFormatter.format(csvValues);
        }
        return csvString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] toCSVValues(String csvString) {
        String[] csvValues;
        CSVParser cSVParser = csvParser;
        synchronized (cSVParser) {
            csvValues = csvParser.getStringValues(csvString);
        }
        return csvValues;
    }
}

