/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.List;
import org.ussamasters.aces.racedata.io.RaceDataIOException;

public abstract class RaceDataReader {
    protected RaceDataReader() {
    }

    protected Reader constructReader(FileReader fs) {
        return new BufferedReader(fs);
    }

    public abstract void load(Reader var1) throws RaceDataIOException;

    public void loadFile(File aFile) throws RaceDataIOException {
        try (FileReader fs = new FileReader(aFile);){
            this.load(this.constructReader(fs));
        }
        catch (IOException ex) {
            throw new RaceDataIOException(ex);
        }
    }

    public void loadFile(String aPathName) throws RaceDataIOException {
        this.loadFile(new File(aPathName));
    }

    @Deprecated
    protected static List<String> constructSupportedFormats(String[] supportedFormats) {
        return Arrays.asList(supportedFormats);
    }
}

