/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.io;

import com.glaivestone.javax.execution.EvaluableAction;
import com.glaivestone.javax.util.PropagatedException;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.ussamasters.aces.racedata.io.RaceDataCSVReader;
import org.ussamasters.aces.racedata.io.RaceDataIOException;
import org.ussamasters.aces.racedata.io.RaceDataIOServices;
import org.ussamasters.aces.racedata.models.CourseArrangement;
import org.ussamasters.aces.racedata.models.FarWestClass_10yr;
import org.ussamasters.aces.racedata.models.RaceClass;
import org.ussamasters.aces.racedata.models.RaceDescriptor;
import org.ussamasters.aces.racedata.models.RaceEntryResult;
import org.ussamasters.aces.racedata.models.RacePoints;
import org.ussamasters.aces.racedata.models.RaceResult;
import org.ussamasters.aces.racedata.models.RacerResult;
import org.ussamasters.aces.racedata.models.StandardOrganizationType;
import org.ussamasters.aces.racedata.models.WorldCupPoints;
import org.ussamasters.aces.racedata.models.WorldCupPointsFactory;
import org.ussamasters.aces.racedata.models.WorldCupPointsType;
import org.ussamasters.aces.racedata.scoring.RaceStandings;

public class RaceResultCSVReader
extends RaceDataCSVReader {
    public static final String CURRENT_FORMAT = "USSA Masters Race Results (CSV 2.0)";
    public static final List<String> SUPPORTED_FORMATS = Collections.unmodifiableList(Arrays.asList("USSA Masters Race Results (CSV 2.0)", "FWM Race Data (CSV 0.1)"));
    protected int nRuns;
    protected boolean dataIncludesRacePoints;
    protected RaceResult raceResult;
    protected EvaluableAction getRaceClassAction;
    protected WorldCupPointsFactory pointsFactory;

    public static RaceResult loadFromFile(File aFile, WorldCupPointsType scoringType) throws RaceDataIOException {
        RaceResultCSVReader aLoader = new RaceResultCSVReader(scoringType);
        aLoader.loadFile(aFile);
        return aLoader.getData();
    }

    public static RaceResult loadFromFile(String aPathName, WorldCupPointsType scoringType) throws RaceDataIOException {
        return RaceResultCSVReader.loadFromFile(new File(aPathName), scoringType);
    }

    public RaceResultCSVReader(WorldCupPointsType scoringType) {
        super(CURRENT_FORMAT, SUPPORTED_FORMATS);
        this.pointsFactory = WorldCupPoints.getFactory(scoringType);
    }

    public RaceResult getData() {
        return this.raceResult;
    }

    @Override
    protected void loadData() throws RaceDataIOException {
        String csvString;
        int fValue;
        CourseArrangement courseArrangement;
        Class raceClassClass;
        this.readFileFormatLine();
        RaceDescriptor raceSpecification = this.raceFromCSVString(this.readLine());
        this.setSeason(raceSpecification.getSeason());
        int nCompetitors = this.readIntegerValueLine("number of competitors");
        int nFinishers = this.readIntegerValueLine("number of finishers");
        String aHeaderLine = this.readLine();
        if (this.isEmptyLine(aHeaderLine)) {
            raceClassClass = FarWestClass_10yr.class;
            courseArrangement = CourseArrangement.SINGLE_COURSE;
        } else {
            raceClassClass = this.resolveRaceClassClass(aHeaderLine, "race class");
            aHeaderLine = this.readLine();
            courseArrangement = CourseArrangement.getConstant(aHeaderLine);
            if (courseArrangement == null) {
                throw new RaceDataIOException("***ERROR: Unknown course arrangement: " + aHeaderLine);
            }
            aHeaderLine = this.readLine();
        }
        raceSpecification.setRaceClassClass(raceClassClass);
        raceSpecification.setWorldCupPointsType(this.pointsFactory.scoringType());
        raceSpecification.setCourseArrangement(courseArrangement);
        if (this.isLoadingFormat("FWM Race Data (CSV 0.1)")) {
            fValue = -1;
        } else {
            fValue = this.parseIntegerValue(aHeaderLine.substring("F=".length()), "race points F value");
            aHeaderLine = this.readLine();
        }
        this.validateBlankHeaderTerminationLine(aHeaderLine);
        this.getRaceClassAction = this.getResolveClassAction(raceClassClass);
        ArrayList<RacerResult> resultsList = new ArrayList<RacerResult>();
        this.nRuns = raceSpecification.getNumberOfRuns();
        boolean bl = this.dataIncludesRacePoints = !this.isLoadingFormat("FWM Race Data (CSV 0.1)");
        while ((csvString = this.readNextCSVLine()) != null) {
            resultsList.add(this.racerResultFromCSVString(csvString));
        }
        this.raceResult = new RaceResult(raceSpecification, resultsList, nCompetitors, nFinishers, fValue);
        if (!this.dataIncludesRacePoints) {
            RaceStandings.computeRacePoints(this.raceResult, StandardOrganizationType.BY_CLASS);
        }
    }

    protected RaceEntryResult racerResultFromCSVString(String csvString) throws RaceDataIOException {
        RaceEntryResult racerResult;
        String[] values = this.parseCSVString(csvString);
        String valueDescription = null;
        try {
            String firstName;
            String lastName;
            int indexOffset = 0;
            valueDescription = "Bib";
            String fieldValue = values[0];
            if (fieldValue.length() == 0) {
                throw new RaceDataIOException((Object)csvString, "Racer entry has no bib number");
            }
            int bibNumber = this.parseIntegerValue(fieldValue, "bib number '" + fieldValue + "'");
            valueDescription = "Class";
            fieldValue = values[1];
            RaceClass<?> raceClass = this.resolveRaceClass(fieldValue, this.getRaceClassAction, valueDescription);
            valueDescription = "Name";
            if (this.isLoadingFormat("FWM Race Data (CSV 0.1)")) {
                String racerName = values[2];
                String[] nameElements = RaceDataIOServices.parseRaceEntryName(racerName);
                lastName = nameElements[RaceDataIOServices.INDEX_LAST_NAME];
                firstName = nameElements[RaceDataIOServices.INDEX_FIRST_NAME];
                indexOffset = -1;
            } else {
                lastName = values[2];
                firstName = values[3];
            }
            valueDescription = "Points";
            fieldValue = values[8 + indexOffset];
            WorldCupPoints<?> wcPoints = fieldValue.length() > 0 ? this.pointsFactory.forPoints(this.parseIntegerValue(fieldValue, "points")) : null;
            valueDescription = "RacePoints";
            RacePoints racePoints = this.dataIncludesRacePoints && (fieldValue = values[9 + indexOffset]).length() > 0 ? RacePoints.fromString(fieldValue) : null;
            valueDescription = "RaceEntryResult creation";
            racerResult = RaceEntryResult.createResult(bibNumber, raceClass, lastName, firstName, this.nRuns);
            valueDescription = "timing data";
            switch (this.nRuns) {
                case 1: {
                    racerResult.setTimingData(values[6 + indexOffset]);
                    break;
                }
                case 2: {
                    racerResult.setTimingData(values[4 + indexOffset], values[5 + indexOffset], values[6 + indexOffset]);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Invalid race runs count: " + this.nRuns);
                }
            }
            valueDescription = "Position";
            racerResult.setPosition(values[7 + indexOffset]);
            racerResult.setPoints(wcPoints);
            racerResult.setRacePoints(racePoints);
        }
        catch (IllegalArgumentException ex) {
            throw new RaceDataIOException(ex, csvString, "Error processing " + valueDescription + ": " + ex.getMessage());
        }
        catch (PropagatedException ex) {
            if (ex.getCause() instanceof Exception) {
                throw new RaceDataIOException((Exception)ex.getCause(), csvString, "Error processing " + valueDescription + ": " + ex.getCause().getMessage());
            }
            throw ex;
        }
        return racerResult;
    }

    protected RaceDescriptor raceFromCSVString(String csvString) throws RaceDataIOException {
        return new RaceDescriptor(RaceDataIOServices.csvValuesToRace(this.parseCSVString(csvString)));
    }
}

