/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.io;

import java.io.PrintWriter;
import org.ussamasters.aces.racedata.io.RaceDataCSVWriter;
import org.ussamasters.aces.racedata.io.RaceDataIOConstants;
import org.ussamasters.aces.racedata.io.RaceDataIOServices;
import org.ussamasters.aces.racedata.models.RaceEntryResult;
import org.ussamasters.aces.racedata.models.RaceEntryResult2Run;
import org.ussamasters.aces.racedata.models.RaceIdentifier;
import org.ussamasters.aces.racedata.models.RaceResult;
import org.ussamasters.aces.racedata.models.RacerResult;

public class RaceResultCSVWriter
extends RaceDataCSVWriter {
    public static final String CURRENT_FORMAT = "USSA Masters Race Results (CSV 2.0)";
    private static final String[] CURRENT_FORMAT_COLUMN_NAMES = RaceDataIOConstants.RACE_RESULTS_CSV_COLUMN_NAMES_2;
    protected int nRuns;
    protected RaceResult raceResult;

    public RaceResultCSVWriter(RaceResult raceResult) {
        this.nRuns = raceResult.getNumberOfRuns();
        this.raceResult = raceResult;
    }

    @Override
    protected String constructFileName() {
        String rootName = RaceDataIOServices.raceResultsRootFileName(this.raceResult.getRaceId());
        return this.composeFileName(rootName);
    }

    protected String racerResultToCSVString(RaceEntryResult racerResult) {
        String[] values = new String[10];
        values[0] = racerResult.getBib();
        values[1] = racerResult.getRaceClass().name;
        values[2] = racerResult.getLastName();
        values[3] = racerResult.getFirstName();
        if (this.nRuns == 2) {
            RaceEntryResult2Run raceRunsResult = (RaceEntryResult2Run)racerResult;
            values[4] = "" + raceRunsResult.getFirstRun();
            values[5] = "" + raceRunsResult.getSecondRun();
        } else {
            values[4] = null;
            values[5] = null;
        }
        values[6] = "" + racerResult.getResultValue();
        values[7] = racerResult.getPositionString();
        values[8] = racerResult.getPoints() == null ? null : Integer.toString(racerResult.getPoints().intValue());
        values[9] = racerResult.getRacePoints() == null ? null : "" + racerResult.getRacePoints();
        return this.toCSVString(values);
    }

    protected String raceToCSVString(RaceIdentifier aRace) {
        return this.formatter.format(RaceDataIOServices.csvValuesFromRace(aRace));
    }

    @Override
    public void write(PrintWriter pw) {
        this.setSeason(this.raceResult.getSeason());
        pw.println(CURRENT_FORMAT);
        pw.println(this.raceToCSVString(this.raceResult.getRaceId()));
        pw.println(Integer.toString(this.raceResult.getNumberOfCompetitors()));
        pw.println(Integer.toString(this.raceResult.getNumberOfFinishers()));
        this.writeRaceClassClassLine(pw, this.raceResult.getRaceClassClass());
        pw.println(this.raceResult.getCourseArrangement().name);
        pw.println("F=" + this.raceResult.getFValue());
        pw.println();
        this.writeCSVColumnNamesComment(pw, CURRENT_FORMAT_COLUMN_NAMES);
        for (RacerResult racerResult : this.raceResult.getRacerResults()) {
            pw.println(this.racerResultToCSVString((RaceEntryResult)racerResult));
        }
    }
}

