/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.io;

import com.glaivestone.javax.execution.EvaluableAction;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.ussamasters.aces.racedata.io.RaceDataCSVReader;
import org.ussamasters.aces.racedata.io.RaceDataIOException;
import org.ussamasters.aces.racedata.models.RaceClass;
import org.ussamasters.aces.racedata.models.RaceClassType;
import org.ussamasters.aces.racedata.models.RaceOrganization;
import org.ussamasters.aces.racedata.models.Racer;
import org.ussamasters.aces.racedata.models.RacerList;

public class RacerListCSVReader
extends RaceDataCSVReader {
    public static final String CURRENT_FORMAT = "USSA Masters Racer Data (CSV 2.1)";
    public static final List<String> SUPPORTED_FORMATS = Collections.unmodifiableList(Arrays.asList("USSA Masters Racer Data (CSV 2.1)", "USSA Masters Racer Data (CSV 2.0)", "FWM Racer Data (CSV 0.1)"));
    protected RacerList racerList;
    protected Class<? extends RaceClass<?>> ageClassClass;
    protected Class<? extends RaceClass<?>> nationalClassClass;
    protected RaceOrganization listOrganizer;
    protected EvaluableAction getAgeClassAction;
    protected EvaluableAction getNationalClassAction;

    public RacerListCSVReader() {
        super(CURRENT_FORMAT, SUPPORTED_FORMATS);
    }

    public static RacerList loadFromFile(File aFile) throws RaceDataIOException {
        RacerListCSVReader aLoader = new RacerListCSVReader();
        aLoader.loadFile(aFile);
        return aLoader.getData();
    }

    public static RacerList loadFromFile(String aPathName) throws RaceDataIOException {
        return RacerListCSVReader.loadFromFile(new File(aPathName));
    }

    protected int bibNumberFromString(String bibNumberString) throws RaceDataIOException {
        return bibNumberString.length() > 0 ? this.parseIntegerValue(bibNumberString, "Bib") : -1;
    }

    protected int computeCurrentAge(int yearBorn) {
        return Racer.computeRacerAge(yearBorn, this.season);
    }

    public RacerList getData() {
        return this.racerList;
    }

    @Override
    protected void loadData() throws RaceDataIOException {
        RaceOrganization affiliation;
        this.readFileFormatLine();
        this.readSeasonLine();
        if (this.isLoadingFormat("FWM Racer Data (CSV 0.1)")) {
            affiliation = RaceOrganization.FAR_WEST;
            this.ageClassClass = this.getSeasonConfiguration().getRaceClassClass(RaceClassType.farwest_masters);
        } else {
            affiliation = this.readRaceOrganizationLine();
            this.ageClassClass = this.readRaceClassClassLine("age class");
        }
        this.nationalClassClass = this.getSeasonConfiguration().getRaceClassClass(RaceClassType.us_masters);
        this.readBlankHeaderTerminationLine();
        this.listOrganizer = affiliation;
        this.getAgeClassAction = this.getResolveClassAction(this.ageClassClass);
        this.getNationalClassAction = this.getResolveClassAction(this.nationalClassClass);
        ArrayList<Racer> racers = new ArrayList<Racer>();
        if (this.isLoadingFormat("FWM Racer Data (CSV 0.1)")) {
            String csvString;
            while ((csvString = this.readNextCSVLine()) != null) {
                racers.add(this.racerFromCSVStringVer1(csvString));
            }
        } else {
            String csvString;
            while ((csvString = this.readNextCSVLine()) != null) {
                racers.add(this.racerFromCSVString(csvString));
            }
        }
        this.racerList = new RacerList(this.season, affiliation, this.ageClassClass, racers);
    }

    protected Racer racerFromCSVString(String csvString) throws RaceDataIOException {
        String[] values = this.parseCSVString(csvString);
        int bibNumber = this.bibNumberFromString(values[0]);
        RaceClass<?> ageClass = this.resolveRaceClass(values[3], this.getAgeClassAction, "AgeClass");
        RaceClass<?> nationalClass = this.resolveRaceClass(values[4], this.getNationalClassAction, "USSAClass");
        int birthYear = Racer.parseYear(values[5]);
        RaceOrganization affiliation = RaceOrganization.getConstant(values[6]);
        String ussaNumber = values[7];
        Racer aRacer = new Racer(bibNumber, values[1], values[2]);
        if (this.listOrganizer == RaceOrganization.UNKNOWN) {
            aRacer.initCompetitionClassValuesLenient(ageClass.getGender(), ageClass, nationalClass, birthYear);
        } else {
            aRacer.initCompetitionClassValues(ageClass.getGender(), ageClass, nationalClass, birthYear);
        }
        aRacer.initLicenseValues(affiliation, ussaNumber);
        return aRacer;
    }

    protected Racer racerFromCSVStringVer1(String csvString) throws RaceDataIOException {
        String[] values = this.parseCSVString(csvString);
        int bibNumber = this.bibNumberFromString(values[0]);
        RaceClass<?> ageClass = this.resolveRaceClass(values[3], this.getAgeClassAction, "AgeClass");
        RaceClass<?> nationalClass = this.resolveRaceClass(values[4], this.getNationalClassAction, "USSAClass");
        int birthYear = Racer.parseYear(values[5]);
        RaceOrganization affiliation = RaceOrganization.getConstant(values[6]);
        Racer aRacer = new Racer(bibNumber, values[1], values[2]);
        aRacer.initCompetitionClassValues(ageClass.getGender(), ageClass, nationalClass, birthYear);
        aRacer.initLicenseValues(affiliation, null);
        return aRacer;
    }
}

