/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.io;

import java.io.PrintWriter;
import org.ussamasters.aces.racedata.io.RaceDataCSVWriter;
import org.ussamasters.aces.racedata.io.RaceDataIOServices;
import org.ussamasters.aces.racedata.models.RaceIdentifier;
import org.ussamasters.aces.racedata.models.RaceSeriesResult;
import org.ussamasters.aces.racedata.models.RaceStartResult;
import org.ussamasters.aces.racedata.models.Racer;
import org.ussamasters.aces.racedata.models.StandingsCategory;
import org.ussamasters.aces.racedata.scoring.CategoryResultsList;
import org.ussamasters.aces.racedata.scoring.SeasonStandings;

public class SeasonStandingsCSVWriter
extends RaceDataCSVWriter {
    public static final String SEASON_STANDINGS_CSV_FORMAT_1 = "FWM SeasonStatistics (CSV 0.1)";
    public static final String SEASON_STANDINGS_CSV_FORMAT_2 = "USSA Masters Season Standings (CSV 2.0)";
    public static final String CURRENT_FORMAT = "USSA Masters Season Standings (CSV 2.0)";
    protected static final String[] COLUMN_LABELS = new String[]{"Position", "LastName", "FirstName", "Points", "Starts(Finishes)"};
    protected static final int RESULT_COLUMN_POSITION = 0;
    protected static final int RESULT_COLUMN_LAST_NAME = 1;
    protected static final int RESULT_COLUMN_FIRST_NAME = 2;
    protected static final int RESULT_COLUMN_POINTS = 3;
    protected static final int RESULT_COLUMN_STARTS_FINISHES = 4;
    protected static final int RESULT_CSV_SIZE = 5;
    protected SeasonStandings seasonStandings;

    public SeasonStandingsCSVWriter(SeasonStandings seasonStandings) {
        this.seasonStandings = seasonStandings;
    }

    @Override
    protected String constructFileName() {
        return this.composeFileName(RaceDataIOServices.seriesStandingsBaseFileName(this.seasonStandings));
    }

    protected int getNumberOfRaces() {
        return this.seasonStandings.getNumberOfRaces();
    }

    protected Racer getRacer(String bibNumber) {
        return this.seasonStandings.getRacer(bibNumber);
    }

    protected String resultsCategoryDescription(StandingsCategory category) {
        return this.seasonStandings.getOrganizationType().categoryDescription(category);
    }

    protected String seriesResultToCSVString(RaceSeriesResult seriesResult) {
        int nRaces = this.getNumberOfRaces();
        String bib = seriesResult.getRacer().getBib();
        Racer aRacer = this.getRacer(bib);
        if (aRacer == null) {
            throw new IllegalStateException("***No racer found for season result bib #" + bib);
        }
        String[] values = new String[5 + nRaces];
        values[0] = seriesResult.getPositionString();
        values[1] = aRacer.getLastName();
        values[2] = aRacer.getFirstName();
        values[3] = "" + seriesResult.getPoints().intValue();
        values[4] = "" + seriesResult.getNumberOfStarts() + "(" + seriesResult.getNumberOfFinishes() + ")";
        int column = 5;
        for (RaceStartResult racerResult : seriesResult.starts()) {
            if (racerResult != null) {
                values[column] = racerResult.isFinisher() ? "" + racerResult.getPositionString() + "(" + racerResult.getPoints().intValue() + ")" : racerResult.getNoResultValue().name + "(0)";
            }
            ++column;
        }
        return this.toCSVString(values);
    }

    @Override
    public void write(PrintWriter pw) {
        pw.println(this.seasonStandings.getRaceSeries().getName());
        pw.println("" + this.getNumberOfRaces() + " races completed.");
        pw.println(this.seasonStandings.organizationDescription());
        pw.println();
        this.writeColumnHeaders(pw);
        for (StandingsCategory standingsCategory : this.seasonStandings.categories()) {
            CategoryResultsList<RaceSeriesResult> categoryResultsList = this.seasonStandings.getCategoryResults(standingsCategory);
            if (categoryResultsList == null) continue;
            pw.println(this.resultsCategoryDescription(standingsCategory));
            for (RaceSeriesResult seriesResult : categoryResultsList) {
                pw.println(this.seriesResultToCSVString(seriesResult));
            }
        }
    }

    protected void writeColumnHeaders(PrintWriter pw) {
        int i;
        int count = COLUMN_LABELS.length;
        for (i = 0; i < count; ++i) {
            pw.print(COLUMN_LABELS[i]);
            pw.print(",");
        }
        count = this.getNumberOfRaces();
        for (i = 0; i < count; ++i) {
            RaceIdentifier aRace = this.seasonStandings.getRace(i);
            pw.print(aRace.getLocation().name + " " + aRace.getType().name);
            if (i >= count - 1) continue;
            pw.print(",");
        }
        pw.println();
    }
}

