/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.io;

import com.glaivestone.javax.lang.ClassX;
import org.ussamasters.aces.racedata.io.CombinedResultTSVWriter;
import org.ussamasters.aces.racedata.models.RaceClass;
import org.ussamasters.aces.racedata.models.RaceSeriesResult;
import org.ussamasters.aces.racedata.models.RaceStartResult;
import org.ussamasters.aces.racedata.models.ScoringElement;
import org.ussamasters.aces.racedata.models.StandingsCategory;
import org.ussamasters.aces.racedata.scoring.SeriesStandings;

public class TripleCombinedCSVWriter
extends CombinedResultTSVWriter {
    public static TripleCombinedCSVWriter forStandings(SeriesStandings standings) {
        if (!TripleCombinedCSVWriter.isSupported(standings)) {
            return null;
        }
        return new TripleCombinedCSVWriter(standings);
    }

    public static final boolean isSupported(SeriesStandings standings) {
        Class<? extends StandingsCategory> organizingClass = standings.categoryClass();
        if (!organizingClass.equals(RaceClass.class) && !ClassX.isProperSubclass(organizingClass, RaceClass.class)) {
            return false;
        }
        if (!standings.getScoringElement().equals(ScoringElement.RACE_POINTS)) {
            return false;
        }
        boolean checkSpecialCombinations = false;
        if (checkSpecialCombinations) {
            return standings.getNumberOfRaces() == 3;
        }
        return true;
    }

    public TripleCombinedCSVWriter(SeriesStandings standings) {
        super(standings);
    }

    @Override
    protected String composeRacerScoreEntry(RaceSeriesResult seriesResult) {
        if (!seriesResult.isQualified()) {
            return "";
        }
        return "" + seriesResult.getRacePoints();
    }

    @Override
    protected String composeRaceStartPositionScoreEntry(RaceStartResult racerResult) {
        if (!racerResult.isFinisher()) {
            return "" + racerResult.getNoResultValue();
        }
        return "" + racerResult.getRacePoints();
    }
}

