/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.models;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ussamasters.aces.racedata.models.FiveYearRangeRaceClass;
import org.ussamasters.aces.racedata.models.Gender;
import org.ussamasters.aces.racedata.models.NationalClassGroup;
import org.ussamasters.aces.racedata.models.NationalClassGroup_2000;
import org.ussamasters.aces.racedata.models.NationalClass_2000;
import org.ussamasters.aces.racedata.models.RaceClassRegistry;
import org.ussamasters.aces.racedata.models.RaceClassType;
import org.ussamasters.aces.racedata.models.RaceOrganization;

public class CentralClass
extends FiveYearRangeRaceClass<CentralClass> {
    private static final Class<CentralClass> THIS_CLASS = CentralClass.class;
    public static final RaceClassType RACE_CLASS_TYPE = RaceClassType.central_masters;
    public static final CentralClass M14 = new CentralClass(NationalClass_2000.M14);
    public static final CentralClass W13 = new CentralClass(NationalClass_2000.W13);
    public static final CentralClass M13 = new CentralClass(NationalClass_2000.M13);
    public static final CentralClass W12 = new CentralClass(NationalClass_2000.W12);
    public static final CentralClass W11 = new CentralClass(NationalClass_2000.W11);
    public static final CentralClass W10 = new CentralClass(NationalClass_2000.W10);
    public static final CentralClass M12 = new CentralClass(NationalClass_2000.M12);
    public static final CentralClass M11 = new CentralClass(NationalClass_2000.M11);
    public static final CentralClass M10 = new CentralClass(NationalClass_2000.M10);
    public static final CentralClass W09 = new CentralClass(NationalClass_2000.W09);
    public static final CentralClass W08 = new CentralClass(NationalClass_2000.W08);
    public static final CentralClass WEL = new CentralClass("WEL", -1, -1, "Women Elite", NationalClassGroup_2000.NONE);
    public static final CentralClass W07 = new CentralClass(NationalClass_2000.W07);
    public static final CentralClass W06 = new CentralClass(NationalClass_2000.W06);
    public static final CentralClass W05 = new CentralClass(NationalClass_2000.W05);
    public static final CentralClass W04 = new CentralClass(NationalClass_2000.W04);
    public static final CentralClass W03 = new CentralClass(NationalClass_2000.W03);
    public static final CentralClass W02 = new CentralClass(NationalClass_2000.W02);
    public static final CentralClass W01 = new CentralClass(NationalClass_2000.W01);
    public static final CentralClass W00 = new CentralClass(NationalClass_2000.W00);
    public static final CentralClass M09 = new CentralClass(NationalClass_2000.M09);
    public static final CentralClass M08 = new CentralClass(NationalClass_2000.M08);
    public static final CentralClass MEL = new CentralClass("MEL", -1, -1, "Men Elite", NationalClassGroup_2000.NONE);
    public static final CentralClass M07 = new CentralClass(NationalClass_2000.M07);
    public static final CentralClass M06 = new CentralClass(NationalClass_2000.M06);
    public static final CentralClass M05 = new CentralClass(NationalClass_2000.M05);
    public static final CentralClass M04 = new CentralClass(NationalClass_2000.M04);
    public static final CentralClass M03 = new CentralClass(NationalClass_2000.M03);
    public static final CentralClass M02 = new CentralClass(NationalClass_2000.M02);
    public static final CentralClass M01 = new CentralClass(NationalClass_2000.M01);
    public static final CentralClass M00 = new CentralClass(NationalClass_2000.M00);
    public static final CentralClass MUNK = new CentralClass("MUNK", -1, -1, "Men (unknown)", null);
    public static final CentralClass WUNK = new CentralClass("WUNK", -1, -1, "Women  (unknown)", null);
    private static final String DESCRIPTION = "Central masters 5-year age classes with men's Elite class";
    protected static Map<CentralClass, String> classStartOrderCodeTable = CentralClass.constructClassStartOrderTable();

    public static CentralClass forAge(Gender gender, int age) {
        return (CentralClass)CentralClass.forAge(gender, age, THIS_CLASS);
    }

    public static CentralClass forNationalClass(NationalClass_2000 ussaClass) {
        return CentralClass.getConstant(ussaClass.name);
    }

    public static CentralClass getConstant(int ordinalValue) {
        return CentralClass.getConstant(ordinalValue, THIS_CLASS);
    }

    public static CentralClass getConstant(String name) {
        return CentralClass.getConstant(name, THIS_CLASS);
    }

    public static void registerSynonym(String synonym, String constantName) {
        CentralClass.registerSynonym(synonym, constantName, THIS_CLASS);
    }

    public static List<CentralClass> values() {
        return CentralClass.values(THIS_CLASS);
    }

    protected CentralClass(String name, int startAge, int endAge, String description, NationalClassGroup_2000 group) {
        super(name, startAge, endAge, description, RaceOrganization.CENTRAL, group);
    }

    protected CentralClass(NationalClass_2000 ussaClass) {
        this(ussaClass.name, ussaClass.startAge, ussaClass.endAge, ussaClass.description, (NationalClassGroup_2000)ussaClass.group);
    }

    @Override
    public RaceClassType getRaceClassType() {
        return RACE_CLASS_TYPE;
    }

    @Override
    public String getStartOrderSortCode() {
        return classStartOrderCodeTable.get(this);
    }

    @Override
    public boolean isDivisionClass() {
        return true;
    }

    @Override
    public boolean isUnknown() {
        return this == MUNK || this == WUNK;
    }

    @Override
    public boolean isAbilityGroupClass() {
        return this == WEL || this == MEL;
    }

    @Override
    protected String toAttributeDescriptionString() {
        return super.toAttributeDescriptionString() + (this.isAgeGroupClass() && this.group != null ? " -> " + this.group.toConstantName() : "");
    }

    @Override
    protected void validateNameSuffix(String classNameSuffix) {
        if (classNameSuffix.equals("UNK")) {
            return;
        }
        if (classNameSuffix.equals("EL")) {
            return;
        }
        this.validateNameSuffixLength(classNameSuffix, 2);
        super.validateNameSuffix(classNameSuffix);
    }

    protected static Map<CentralClass, String> constructClassStartOrderTable() {
        Object[][] startCodeSpecs = new Object[][]{{M14, "AB"}, {W13, "BA"}, {M13, "BB"}, {W12, "CA"}, {W11, "CB"}, {W10, "CC"}, {M12, "DA"}, {M11, "DB"}, {M10, "DC"}, {W09, "E"}, {W08, "F"}, {W07, "G"}, {W06, "I"}, {W05, "J"}, {W04, "K"}, {W03, "L"}, {W02, "M"}, {W01, "N"}, {W00, "O"}, {M09, "P"}, {M08, "Q"}, {M07, "R"}, {MEL, "SEL"}, {M06, "T"}, {M05, "U"}, {M04, "V"}, {M03, "W"}, {M02, "X"}, {M01, "Y"}, {M00, "Z"}};
        HashMap<CentralClass, String> startCodeTable = new HashMap<CentralClass, String>();
        for (int i = 0; i < startCodeSpecs.length; ++i) {
            startCodeTable.put((CentralClass)startCodeSpecs[i][0], (String)startCodeSpecs[i][1]);
        }
        return startCodeTable;
    }

    protected static void registerStandardSynonyms() {
        char altWomensPrefix = 'F';
        CentralClass.registerSynonyms(CentralClass.standardEliteSeedSynonymSpecs(), THIS_CLASS);
        CentralClass.registerGenderPrefixSynonyms(Gender.WOMEN, altWomensPrefix, THIS_CLASS);
        CentralClass.registerClassNumberSynonyms(THIS_CLASS, altWomensPrefix);
    }

    static {
        CentralClass.registerStandardSynonyms();
        RaceClassRegistry.registerDivisionRaceClass(THIS_CLASS, RACE_CLASS_TYPE, DESCRIPTION, 5, NationalClass_2000.class, NationalClassGroup_2000.class, NationalClassGroup.GROUP_TYPE);
    }
}

