/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.models;

import com.glaivestone.javax.lang.ConstantValue;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.ussamasters.javax.io.ConstantLoader;
import org.ussamasters.javax.io.ConstantSpecifications;

public class Country
extends ConstantValue<Country> {
    private static final Class<Country> THIS_CLASS = Country.class;
    private static final String CONFIG_DIR_REF = "/" + THIS_CLASS.getPackage().getName().replaceAll("\\.", "/").replace("/models", "/configuration");
    public static final Country UNKNOWN;
    public static final Country USA;
    public static final Country CANADA;
    public static final String BUILTIN_CONSTANT_SPECS;
    public static final String SPEC_FIELD_NAME = "name";
    public static final String SPEC_FIELD_FULLNAME = "fullName";
    public static final List<String> CONSTANT_SPEC_FIELDS;
    public static final boolean ALLOW_SYNONYMS = true;
    public final String fullName;

    public static Country getConstant(int ordinalValue) {
        return Country.getConstant(ordinalValue, THIS_CLASS);
    }

    public static Country getConstant(String name) {
        return Country.getConstant(name, THIS_CLASS);
    }

    public static List<Country> values() {
        return Country.values(THIS_CLASS);
    }

    public static Country defineConstant(String name, String fullName) {
        Country cnst = Country.getConstant(name);
        if (cnst != null) {
            cnst.validateDefinitionConsistency(fullName);
        } else {
            cnst = new Country(name, fullName);
        }
        return cnst;
    }

    public static void loadConstants(String fileRef) {
        ConstantSpecifications specs = ConstantLoader.loadSpecificationsFromFile(fileRef);
        specs.ensureWellFormed(CONSTANT_SPEC_FIELDS);
        for (Map<String, Object> entry : specs.getEntries()) {
            String constantName = (String)entry.get(SPEC_FIELD_NAME);
            String fullName = (String)entry.get(SPEC_FIELD_FULLNAME);
            Country.defineConstant(constantName, fullName);
            List<String> synonyms = specs.getSynonyms(constantName);
            for (String synonym : synonyms) {
                Country.registerSynonym(synonym, constantName, THIS_CLASS);
            }
        }
    }

    public Country(String name, String fullName) {
        super(-1, name);
        this.fullName = fullName;
    }

    @Override
    protected boolean allowSynonyms() {
        return true;
    }

    protected void validateDefinitionConsistency(String fullName) {
        if (!this.fullName.equalsIgnoreCase(fullName)) {
            throw new IllegalArgumentException(String.format("Conflicting constant definition: cannot change %s fullName to '%s'", this.toConstantName(), fullName));
        }
    }

    protected static void registerSynonyms() {
        String[][] synonymSpecs = new String[][]{{"US", "USA"}, {"CA", "CAN"}, {"GB", "GBR"}, {"NZ", "NZE"}, {"GDR", "GER"}, {"FR", "FRA"}};
        Country.registerSynonyms(synonymSpecs, THIS_CLASS);
    }

    public static void main(String[] args) {
        ConstantLoader.checkSpecificationLoading(BUILTIN_CONSTANT_SPECS);
        boolean checkAddRemove = false;
        if (checkAddRemove) {
            System.out.println("\n###Test constant add/remove:");
            System.out.println("Num country constants before: " + Country.values().size());
            Country cnst = Country.defineConstant("test", "Test");
            System.out.println("Defined: " + cnst);
            System.out.println("Num country constants updated: " + Country.values().size());
            System.out.println("Remove test constant:");
            cnst.removeConstant();
            System.out.println("Defined: " + Country.getConstant("test"));
            System.out.println("Num country constants after: " + Country.values().size());
            System.out.println("...done");
        }
    }

    static {
        BUILTIN_CONSTANT_SPECS = CONFIG_DIR_REF + "/constants/Country.yml";
        CONSTANT_SPEC_FIELDS = Collections.unmodifiableList(Arrays.asList(SPEC_FIELD_NAME, SPEC_FIELD_FULLNAME));
        UNKNOWN = new Country("UNK", "Unknown");
        Country.loadConstants(BUILTIN_CONSTANT_SPECS);
        USA = Country.getConstant("USA");
        CANADA = Country.getConstant("CAN");
    }
}

