/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.models;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ussamasters.aces.racedata.models.Gender;
import org.ussamasters.aces.racedata.models.NationalClassGroup;
import org.ussamasters.aces.racedata.models.NationalClassGroup_2000;
import org.ussamasters.aces.racedata.models.NationalClass_2000;
import org.ussamasters.aces.racedata.models.RaceClassRegistry;
import org.ussamasters.aces.racedata.models.RaceClassType;
import org.ussamasters.aces.racedata.models.RaceOrganization;
import org.ussamasters.aces.racedata.models.TenYearRangeRaceClass;

public class NorthernClass
extends TenYearRangeRaceClass<NorthernClass> {
    private static final Class<NorthernClass> THIS_CLASS = NorthernClass.class;
    public static final RaceClassType RACE_CLASS_TYPE = RaceClassType.northern_masters;
    public static final NorthernClass M80;
    public static final NorthernClass W80;
    public static final NorthernClass W70;
    public static final NorthernClass M70;
    public static final NorthernClass W60;
    public static final NorthernClass W50;
    public static final NorthernClass W40;
    public static final NorthernClass W30;
    public static final NorthernClass W20;
    public static final NorthernClass W00;
    public static final NorthernClass M60;
    public static final NorthernClass M50;
    public static final NorthernClass M40;
    public static final NorthernClass M30;
    public static final NorthernClass M20;
    public static final NorthernClass M00;
    public static final NorthernClass MUNK;
    public static final NorthernClass WUNK;
    private static final String DESCRIPTION = "Northern masters 10-year age classes";
    protected static Map<NorthernClass, String> classStartOrderCodeTable;
    protected static Map<NationalClass_2000, NorthernClass> nationalClassMap;

    public static NorthernClass forAge(Gender gender, int age) {
        return (NorthernClass)NorthernClass.forAge(gender, age, THIS_CLASS);
    }

    public static NorthernClass forNationalClass(NationalClass_2000 ussaClass) {
        return nationalClassMap.get(ussaClass);
    }

    public static NorthernClass forStartOrderSortCode(String sortCode) {
        for (NorthernClass aClass : classStartOrderCodeTable.keySet()) {
            String classSortCode = classStartOrderCodeTable.get(aClass);
            if (!classSortCode.equals(sortCode)) continue;
            return aClass;
        }
        return null;
    }

    public static NorthernClass getConstant(int ordinalValue) {
        return NorthernClass.getConstant(ordinalValue, THIS_CLASS);
    }

    public static NorthernClass getConstant(String name) {
        return NorthernClass.getConstant(name, THIS_CLASS);
    }

    public static void registerSynonym(String synonym, String constantName) {
        NorthernClass.registerSynonym(synonym, constantName, THIS_CLASS);
    }

    public static List<NorthernClass> values() {
        return NorthernClass.values(THIS_CLASS);
    }

    protected NorthernClass(String name, int startAge, String description) {
        this(name, startAge, startAge + 10 - 1, description);
    }

    protected NorthernClass(String name, int startAge, int endAge, String description) {
        super(name, startAge, endAge, description, RaceOrganization.NORTHERN);
    }

    @Override
    public RaceClassType getRaceClassType() {
        return RACE_CLASS_TYPE;
    }

    @Override
    public String getStartOrderSortCode() {
        return classStartOrderCodeTable.get(this);
    }

    @Override
    public boolean isDivisionClass() {
        return true;
    }

    @Override
    public boolean isAbilityGroupClass() {
        return false;
    }

    @Override
    public boolean isUnknown() {
        return this == MUNK || this == WUNK;
    }

    @Override
    protected void validateNameSuffix(String classNameSuffix) {
        if (classNameSuffix.equals("UNK")) {
            return;
        }
        if (classNameSuffix.equals("OP")) {
            return;
        }
        this.validateNameSuffixLength(classNameSuffix, 2);
        super.validateNameSuffix(classNameSuffix);
    }

    protected static Map<NorthernClass, String> constructClassStartOrderTable() {
        Object[][] startCodeSpecs = new Object[][]{{W80, "A"}, {M80, "B"}, {W70, "C"}, {M70, "D"}, {W60, "E"}, {W50, "F"}, {W40, "H"}, {W30, "I"}, {W20, "J"}, {W00, "K"}, {M60, "M"}, {M50, "N"}, {M40, "P"}, {M30, "Q"}, {M20, "R"}, {M00, "S"}};
        HashMap<NorthernClass, String> startCodeTable = new HashMap<NorthernClass, String>();
        for (int i = 0; i < startCodeSpecs.length; ++i) {
            startCodeTable.put((NorthernClass)startCodeSpecs[i][0], (String)startCodeSpecs[i][1]);
        }
        return startCodeTable;
    }

    protected static Map<NationalClass_2000, NorthernClass> constructNationalClassMap() {
        HashMap<NationalClass_2000, NorthernClass> mappingTable = new HashMap<NationalClass_2000, NorthernClass>();
        mappingTable.put(NationalClass_2000.MUNK, MUNK);
        mappingTable.put(NationalClass_2000.WUNK, WUNK);
        for (NationalClass_2000 nationalClass : NationalClass_2000.values()) {
            if (!nationalClass.isAgeGroupClass()) continue;
            mappingTable.put(nationalClass, NorthernClass.forAge(nationalClass.getGender(), nationalClass.startAge));
        }
        return mappingTable;
    }

    protected static void registerStandardSynonyms() {
        char altWomensPrefix = 'F';
        String[][] synonymSpecs = new String[][]{};
        NorthernClass.registerSynonyms(NorthernClass.standardOpenSeedSynonymSpecs(), THIS_CLASS);
        NorthernClass.registerSynonyms(synonymSpecs, THIS_CLASS);
        NorthernClass.registerGenderPrefixSynonyms(Gender.WOMEN, altWomensPrefix, THIS_CLASS);
    }

    static {
        W80 = new NorthernClass("W80", 80, 999, "Women 80+");
        M80 = new NorthernClass("M80", 80, 999, "Men 80+");
        W70 = new NorthernClass("W70", 70, "Women 70");
        M70 = new NorthernClass("M70", 70, "Men 70");
        W60 = new NorthernClass("W60", 60, "Women 60");
        W50 = new NorthernClass("W50", 50, "Women 50");
        W40 = new NorthernClass("W40", 40, "Women 40");
        W30 = new NorthernClass("W30", 30, "Women 30");
        W20 = new NorthernClass("W20", 21, 29, "Women 20");
        W00 = new NorthernClass("W00", 0, 20, "Women (under 21)");
        M60 = new NorthernClass("M60", 60, "Men 60");
        M50 = new NorthernClass("M50", 50, "Men 50");
        M40 = new NorthernClass("M40", 40, "Men 40");
        M30 = new NorthernClass("M30", 30, "Men 30");
        M20 = new NorthernClass("M20", 21, 29, "Men 20");
        M00 = new NorthernClass("M00", 0, 20, "Men (under 21)");
        MUNK = new NorthernClass("MUNK", -1, -1, "Men (unknown)");
        WUNK = new NorthernClass("WUNK", -1, -1, "Women (unknown)");
        nationalClassMap = NorthernClass.constructNationalClassMap();
        classStartOrderCodeTable = NorthernClass.constructClassStartOrderTable();
        NorthernClass.registerStandardSynonyms();
        RaceClassRegistry.registerDivisionRaceClass(THIS_CLASS, RACE_CLASS_TYPE, DESCRIPTION, 10, NationalClass_2000.class, NationalClassGroup_2000.class, NationalClassGroup.GROUP_TYPE);
    }
}

