/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.models;

import java.util.Arrays;
import java.util.List;
import org.ussamasters.aces.racedata.models.RaceDataConstant;
import org.ussamasters.aces.racedata.models.RaceOrganization;

public enum RaceClassType implements RaceDataConstant
{
    us_masters("NationalClass", RaceOrganization.USSA, "US Masters 5-yr age classes"),
    farwest_masters("FarWestClass", RaceOrganization.FAR_WEST, "Far West Masters with Open class"),
    intermountain_masters("IntermountainClass", RaceOrganization.INTERMOUNTAIN, "Intermountain Masters with Superseed class"),
    rocky_masters("RockyMountainClass", RaceOrganization.ROCKY, "Rocky Masters with Elite class"),
    central_masters("CentralClass", RaceOrganization.CENTRAL, "Central Masters with Elite class"),
    northern_masters("NorthernClass", RaceOrganization.NORTHERN, "Northern Masters 10-yr classes"),
    fis_masters("FISMastersClass", RaceOrganization.FIS, "FIS Masters age classes");

    public static final List<RaceClassType> STANDARD_RACE_CLASS_TYPES;
    public static final List<RaceClassType> EXPERIMENTAL_RACE_CLASS_TYPES;
    public final String raceClassId;
    public final RaceOrganization organizer;
    public final String description;

    private RaceClassType(String raceClassId, RaceOrganization organizer, String description) {
        this.raceClassId = raceClassId;
        this.organizer = organizer;
        this.description = description;
    }

    public boolean isDivisionClass() {
        return this.organizer.isUSSADivision();
    }

    public boolean isNationalClass() {
        return this.organizer == RaceOrganization.USSA;
    }

    public boolean isInternationalClass() {
        return this.organizer == RaceOrganization.FIS;
    }

    static {
        STANDARD_RACE_CLASS_TYPES = Arrays.asList(us_masters, farwest_masters, intermountain_masters, fis_masters);
        EXPERIMENTAL_RACE_CLASS_TYPES = Arrays.asList(rocky_masters, central_masters, northern_masters);
    }
}

