/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.models;

import com.glaivestone.javax.util.SimpleDate;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.ussamasters.aces.racedata.models.RaceOrganization;

public class RaceDate
extends SimpleDate {
    private static TimeZone localTimeZone = TimeZone.getDefault();
    private static Locale localLocale = Locale.getDefault();
    private static Map<RaceOrganization, Object[]> organizationTimeZoneSpecificationsTable = RaceDate.constructOrganizationTimeZoneSpecificationsTable();

    public static int currentSeasonStartYear() {
        return RaceDate.today().getSeasonStartYear();
    }

    public static int currentSeasonYear() {
        return RaceDate.today().getSeasonEndYear();
    }

    public static RaceDate fromDigitString(String digitString) {
        int[] dateCreationParms = RaceDate.parseDigitString(digitString);
        if (dateCreationParms == null) {
            return null;
        }
        return new RaceDate(dateCreationParms[0], dateCreationParms[1], dateCreationParms[2]);
    }

    public static RaceDate fromStandardString(String dateString) {
        return dateString == null || dateString.length() == 0 ? null : new RaceDate(dateString);
    }

    public static Calendar newCalendar() {
        return new GregorianCalendar(localTimeZone, localLocale);
    }

    protected static int[] parseDigitString(String digitString) {
        if (digitString == null || digitString.length() == 0) {
            return null;
        }
        if (digitString.length() != 8) {
            throw new IllegalArgumentException("Invalid format for date digit string: " + digitString);
        }
        try {
            int year = Integer.parseInt(digitString.substring(0, 4));
            int monthIndex = Integer.parseInt(digitString.substring(4, 6));
            int day = Integer.parseInt(digitString.substring(6, 8));
            int[] dateCreationParms = new int[]{year, monthIndex, day};
            return dateCreationParms;
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("Invalid format for date digit string: " + digitString);
        }
    }

    public static void registerDivisionTimeZone(RaceOrganization ussaDivision) {
        Object[] timeZoneSpec = organizationTimeZoneSpecificationsTable.get(ussaDivision);
        if (timeZoneSpec == null) {
            throw new IllegalArgumentException("No time zone specifications available for " + ussaDivision);
        }
        String timeZoneName = (String)timeZoneSpec[0];
        Locale locale = (Locale)timeZoneSpec[1];
        RaceDate.registerLocalValues(TimeZone.getTimeZone(timeZoneName), locale);
    }

    public static void registerLocalValues(TimeZone aTimeZone, Locale aLocale) {
        localTimeZone = aTimeZone;
        localLocale = aLocale;
    }

    public static RaceDate today() {
        return new RaceDate();
    }

    public RaceDate() {
        super(localTimeZone, localLocale);
    }

    public RaceDate(Date aDate) {
        super(localTimeZone, localLocale, aDate);
    }

    public RaceDate(int year, int monthIndex, int day) {
        super(localTimeZone, localLocale, year, monthIndex, day);
    }

    public RaceDate(int year, String monthName, int day) {
        super(localTimeZone, localLocale, year, monthName, day);
    }

    public RaceDate(String dateString) {
        super(localTimeZone, localLocale, dateString);
    }

    public RaceDate copy() {
        return new RaceDate(this.getCalendarDate().getTime());
    }

    public int getSeasonStartYear() {
        return RaceDate.getSeasonStartYear(this);
    }

    public int getSeasonEndYear() {
        return RaceDate.getSeasonEndYear(this);
    }

    public boolean isBefore(RaceDate other) {
        return this.compareTo(other) < 0;
    }

    public boolean isAfter(RaceDate other) {
        return this.compareTo(other) > 0;
    }

    public String toDigitString() {
        String year = Integer.toString(this.getYear());
        String month = this.toTwoDigitString(this.getMonthIndex());
        String day = this.toTwoDigitString(this.getDay());
        return year + month + day;
    }

    public String toRenderingString() {
        String year = Integer.toString(this.getYear());
        String monthName = this.getMonthName();
        String day = this.toTwoDigitString(this.getDay());
        return monthName + " " + day + ", " + year;
    }

    public static int getSeasonStartYear(RaceDate aDate) {
        int year = aDate.getYear();
        return aDate.getMonthIndex() <= 6 ? year - 1 : year;
    }

    public static int getSeasonEndYear(RaceDate aDate) {
        return RaceDate.getSeasonStartYear(aDate) + 1;
    }

    protected static Map<RaceOrganization, Object[]> constructOrganizationTimeZoneSpecificationsTable() {
        return new HashMap<RaceOrganization, Object[]>(){
            {
                this.put(RaceOrganization.FAR_WEST, new Object[]{"PST", Locale.US});
                this.put(RaceOrganization.PNSA, new Object[]{"PST", Locale.US});
                this.put(RaceOrganization.INTERMOUNTAIN, new Object[]{"MST", Locale.US});
                this.put(RaceOrganization.NORTHERN, new Object[]{"MST", Locale.US});
                this.put(RaceOrganization.ROCKY, new Object[]{"MST", Locale.US});
            }
        };
    }
}

