/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.models;

import org.ussamasters.aces.racedata.models.CourseArrangement;
import org.ussamasters.aces.racedata.models.RaceClass;
import org.ussamasters.aces.racedata.models.RaceClassRegistry;
import org.ussamasters.aces.racedata.models.RaceClassType;
import org.ussamasters.aces.racedata.models.RaceDate;
import org.ussamasters.aces.racedata.models.RaceIdentifier;
import org.ussamasters.aces.racedata.models.RaceLocation;
import org.ussamasters.aces.racedata.models.RaceType;
import org.ussamasters.aces.racedata.models.SeasonIdentifier;
import org.ussamasters.aces.racedata.models.WorldCupPointsType;

public class RaceDescriptor {
    protected RaceIdentifier raceId;
    private Class<? extends RaceClass<?>> raceClassClass;
    private WorldCupPointsType worldCupPointsType;
    private CourseArrangement courseArrangement;

    public static RaceDescriptor constructPlaceholderSpec(SeasonIdentifier season) {
        return new RaceDescriptor(RaceIdentifier.constructPlaceholder(season));
    }

    public RaceDescriptor(RaceIdentifier raceId) {
        this(raceId, null, null, CourseArrangement.UNKNOWN);
    }

    public RaceDescriptor(RaceDate date, RaceLocation location, RaceType type, String qualifier) {
        this(new RaceIdentifier(date, location, type, qualifier));
    }

    public RaceDescriptor(RaceDate date, RaceLocation location, RaceType type, String qualifier, Class<? extends RaceClass<?>> raceClassClass, WorldCupPointsType scoringType, CourseArrangement courseArrangement) {
        this(new RaceIdentifier(date, location, type, qualifier), raceClassClass, scoringType, courseArrangement);
    }

    public RaceDescriptor(RaceIdentifier raceId, Class<? extends RaceClass<?>> raceClassClass, WorldCupPointsType scoringType, CourseArrangement courseArrangement) {
        this.raceId = raceId;
        this.setRaceClassClass(raceClassClass);
        this.setWorldCupPointsType(scoringType);
        this.setCourseArrangement(courseArrangement);
    }

    protected RaceDescriptor(RaceDescriptor aRace) {
        this(aRace.getRaceId(), aRace.getRaceClassClass(), aRace.getWorldCupPointsType(), aRace.getCourseArrangement());
    }

    public RaceDescriptor copy() {
        return new RaceDescriptor(this);
    }

    public CourseArrangement getCourseArrangement() {
        return this.courseArrangement;
    }

    public RaceDate getDate() {
        return this.getRaceId().getDate();
    }

    public int getNumberOfRuns() {
        return this.getRaceId().getNumberOfRuns();
    }

    public RaceLocation getLocation() {
        return this.getRaceId().getLocation();
    }

    public Class<? extends RaceClass<?>> getRaceClassClass() {
        return this.raceClassClass;
    }

    public RaceClassType getRaceClassType() {
        return RaceClassRegistry.current().getRaceClassType(this.getRaceClassClass());
    }

    public RaceIdentifier getRaceId() {
        return this.raceId;
    }

    public SeasonIdentifier getSeason() {
        return this.raceId.getSeason();
    }

    public RaceType getType() {
        return this.raceId.getType();
    }

    public WorldCupPointsType getWorldCupPointsType() {
        return this.worldCupPointsType;
    }

    public void setCourseArrangement(CourseArrangement courseArrangement) {
        this.courseArrangement = courseArrangement;
    }

    public void setRaceClassClass(Class<? extends RaceClass<?>> raceClassClass) {
        this.raceClassClass = raceClassClass;
    }

    public void setWorldCupPointsType(WorldCupPointsType scoringType) {
        this.worldCupPointsType = scoringType;
    }

    public String toString() {
        return String.format("%s {%s, %s, %s, %s}", this.getClass().getSimpleName(), this.raceId.toReferenceString(), this.raceClassClass.getSimpleName(), this.worldCupPointsType.formulaId, this.courseArrangement.name());
    }
}

