/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.models;

import org.ussamasters.aces.racedata.models.CompetitorResultValue;
import org.ussamasters.aces.racedata.models.Gender;
import org.ussamasters.aces.racedata.models.NamedRacerResult;
import org.ussamasters.aces.racedata.models.RaceClass;
import org.ussamasters.aces.racedata.models.RaceEntryResult1Run;
import org.ussamasters.aces.racedata.models.RaceEntryResult2Run;
import org.ussamasters.aces.racedata.models.RacerResult;

public abstract class RaceEntryResult
extends NamedRacerResult
implements Comparable<RaceEntryResult>,
Cloneable {
    private int bibNumber;
    private RaceClass<?> raceClass;
    private String lastName;
    private String firstName;

    public static RaceEntryResult createResult(int bibNumber, RaceClass<?> raceClass, String lastName, String firstName, int numRuns) {
        if (numRuns == 1) {
            return new RaceEntryResult1Run(bibNumber, raceClass, lastName, firstName);
        }
        if (numRuns == 2) {
            return new RaceEntryResult2Run(bibNumber, raceClass, lastName, firstName);
        }
        throw new IllegalArgumentException("RaceEntryResult must have either 1 or 2 runs (" + numRuns + " was requested");
    }

    protected RaceEntryResult(int bibNumber, RaceClass<?> raceClass, String lastName, String firstName) {
        this.bibNumber = bibNumber;
        this.raceClass = raceClass;
        this.lastName = lastName;
        this.firstName = firstName;
    }

    public RaceEntryResult clone() {
        try {
            return (RaceEntryResult)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            return null;
        }
    }

    public int compareByTimeInClassStartOrder(RaceEntryResult otherResult) {
        if (this.raceClass.ord == otherResult.raceClass.ord) {
            return this.compareByTime(otherResult);
        }
        return this.raceClass.ord < otherResult.raceClass.ord ? -1 : 1;
    }

    public int compareByTimeWithinGender(RaceEntryResult otherResult) {
        if (this.getGender() == otherResult.getGender()) {
            return this.compareByTime(otherResult);
        }
        return this.raceClass.isWomensClass() ? -1 : 1;
    }

    @Override
    public int compareTo(RaceEntryResult otherResult) {
        return this.compareByTime(otherResult);
    }

    @Override
    public int getBibNumber() {
        return this.bibNumber;
    }

    @Override
    public String getFirstName() {
        return this.firstName;
    }

    @Override
    public Gender getGender() {
        return this.raceClass.getGender();
    }

    @Override
    public String getLastName() {
        return this.lastName;
    }

    public abstract int getNumberOfRuns();

    @Override
    public RaceClass<?> getRaceClass() {
        return this.raceClass;
    }

    protected boolean isComparable(RacerResult otherResult) {
        return otherResult instanceof RaceEntryResult;
    }

    @Override
    public abstract boolean isStarter();

    public void setBibNumber(int bibNumber) {
        this.bibNumber = bibNumber;
    }

    public void setName(String lastName, String firstName) {
        this.lastName = lastName;
        this.firstName = firstName;
    }

    public void setRaceClass(RaceClass<?> raceClass) {
        this.raceClass = raceClass;
    }

    public void setTimingData(CompetitorResultValue<?> result) {
        throw new UnsupportedOperationException();
    }

    public void setTimingData(CompetitorResultValue<?> firstRun, CompetitorResultValue<?> secondRun, CompetitorResultValue<?> total) {
        throw new UnsupportedOperationException();
    }

    public void setTimingData(String resultString) {
        throw new UnsupportedOperationException();
    }

    public void setTimingData(String firstRun, String secondRun, String total) {
        throw new UnsupportedOperationException();
    }

    public abstract void validateTimingData();

    public String toString() {
        return String.format("%s (%s, %s)", this.getClass().getSimpleName(), this.toStringRacerDetails(), this.toStringResultDetails());
    }

    protected String toStringRacerDetails() {
        return this.getBib() + ", " + this.raceClass.name + ", " + this.getName();
    }

    protected String toStringResultDetails() {
        return this.getResultValue().toString();
    }
}

