/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.models;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ussamasters.aces.racedata.models.RaceClass;
import org.ussamasters.aces.racedata.models.RaceClassHelper;
import org.ussamasters.aces.racedata.models.RaceIdentifier;
import org.ussamasters.aces.racedata.models.RaceResult;
import org.ussamasters.aces.racedata.models.SeasonIdentifier;
import org.ussamasters.aces.racedata.models.WorldCupPoints;
import org.ussamasters.aces.racedata.models.WorldCupPoints15;
import org.ussamasters.aces.racedata.models.WorldCupPointsFactory;
import org.ussamasters.aces.racedata.models.WorldCupPointsType;

public class RaceSeries {
    public static final WorldCupPointsFactory DEFAULT_POINTS_FACTORY = WorldCupPoints15.FACTORY;
    private String name;
    private final SeasonIdentifier season;
    private Class<? extends RaceClass<?>> raceClassClass;
    private WorldCupPointsType worldCupPointsType;
    private List<RaceIdentifier> races;
    private Map<RaceIdentifier, RaceResult> raceResults;
    private final RaceClassHelper raceClassHelper;

    public static RaceSeries createEmptySeries(RaceSeries prototype) {
        return RaceSeries.createEmptySeries(prototype.getName(), prototype.getSeason(), prototype.getRaceClassClass(), prototype.getWorldCupPointsType());
    }

    public static RaceSeries createEmptySeries(String name, SeasonIdentifier season, Class<? extends RaceClass<?>> raceClassClass, WorldCupPointsType scoringType) {
        return new RaceSeries(name, season, raceClassClass, scoringType);
    }

    public RaceSeries(String name, SeasonIdentifier season, Class<? extends RaceClass<?>> raceClassClass, WorldCupPointsType scoringType) {
        this(name, season, raceClassClass, scoringType, new ArrayList<RaceIdentifier>());
    }

    public RaceSeries(String name, SeasonIdentifier season, Class<? extends RaceClass<?>> raceClassClass, WorldCupPointsType scoringType, List<RaceIdentifier> races) {
        this.name = name;
        this.season = season;
        this.raceClassClass = raceClassClass;
        this.worldCupPointsType = scoringType;
        this.races = races;
        this.raceResults = new HashMap<RaceIdentifier, RaceResult>();
        this.raceClassHelper = new RaceClassHelper(season);
    }

    public void add(RaceIdentifier raceId) {
        this.addRaceEntry(raceId);
        this.sortRaces();
    }

    public void add(RaceResult aRaceResult) {
        RaceIdentifier raceId = aRaceResult.getRaceId();
        this.addRaceEntry(raceId);
        this.raceResults.put(raceId, aRaceResult);
        this.sortRaces();
    }

    protected void addRaceEntry(RaceIdentifier aRace) {
        this.races.add(aRace);
    }

    public boolean contains(RaceIdentifier raceId) {
        return this.races.contains(raceId);
    }

    public String getName() {
        return this.name;
    }

    public WorldCupPointsFactory getPointsFactory() {
        return WorldCupPoints.getFactory(this.getWorldCupPointsType());
    }

    public RaceIdentifier getRace(int index) {
        return this.races.get(index);
    }

    public Class<? extends RaceClass<?>> getRaceClassClass() {
        return this.raceClassClass;
    }

    public RaceResult getRaceData(int index) {
        RaceIdentifier raceId = this.races.get(index);
        return this.raceResults.get(raceId);
    }

    public RaceResult getRaceData(RaceIdentifier raceId) {
        return this.raceResults.get(raceId);
    }

    public List<RaceResult> getRaceResults() {
        ArrayList<RaceResult> resultsList = new ArrayList<RaceResult>(this.size());
        for (RaceIdentifier raceId : this.races) {
            RaceResult raceResult = this.raceResults.get(raceId);
            if (raceResult == null) continue;
            resultsList.add(raceResult);
        }
        return resultsList;
    }

    public List<RaceIdentifier> getRaces() {
        return Collections.unmodifiableList(this.races);
    }

    public SeasonIdentifier getSeason() {
        return this.season;
    }

    public int getSeasonYear() {
        return this.season.getSeasonYear();
    }

    public WorldCupPointsType getWorldCupPointsType() {
        return this.worldCupPointsType;
    }

    public boolean hasResults() {
        return !this.raceResults.isEmpty();
    }

    public void registerRaceData(RaceResult raceResult) {
        RaceIdentifier raceId = raceResult.getRaceId();
        if (!this.races.contains(raceId)) {
            throw new IllegalStateException("Results race not in this series: " + raceId);
        }
        this.raceResults.put(raceId, raceResult);
    }

    public int indexOf(RaceIdentifier aRace) {
        return this.races.indexOf(aRace);
    }

    public void remove(RaceIdentifier aRace) {
        this.races.remove(aRace);
        this.raceResults.remove(aRace);
    }

    public void set(int index, RaceResult raceResult) {
        this.validateSetRace(index, raceResult);
        RaceIdentifier raceId = raceResult.getRaceId();
        this.setRace(index, raceId);
        this.raceResults.put(raceId, raceResult);
    }

    protected void setRace(int index, RaceIdentifier aRace) {
        this.races.set(index, aRace);
    }

    public void setWorldCupPointsType(WorldCupPointsType scoringType) {
        this.worldCupPointsType = scoringType;
    }

    public void setRaceClassClass(Class<? extends RaceClass<?>> raceClassClass) {
        this.raceClassClass = raceClassClass;
    }

    public int size() {
        return this.races.size();
    }

    protected void sortRaces() {
        Collections.sort(this.races);
    }

    public String toString() {
        return String.format(" %s<%s, %s, %s, %s races>", this.getClass().getSimpleName(), this.name, this.raceClassHelper.raceClassClassToLiteral(this.raceClassClass), this.worldCupPointsType.formulaId, this.races.size());
    }

    protected void validateSetRace(int index, RaceResult aRace) {
        if (!this.getRace(index).equals(aRace.getRaceId())) {
            throw new IllegalArgumentException("Cannot replace race series entry for " + this.getRace(index) + " with results from " + aRace);
        }
    }
}

