/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.models;

import java.util.StringTokenizer;
import org.ussamasters.aces.racedata.models.CompetitorResultValue;
import org.ussamasters.aces.racedata.models.RaceValueInHundredths;

public class RaceTime
extends RaceValueInHundredths<RaceTime>
implements CompetitorResultValue<RaceTime> {
    public static final RaceTime ZERO = new RaceTime(0, 0);
    public static final RaceTime NULL = new RaceTime(999, 99);
    public static final int FORMAT_MSSHH = 0;
    public static final int FORMAT_SSHH = 1;
    public static int printFormat = 0;
    protected static final String SECONDS_SEPARATOR = ":";
    protected static final String HUNDREDTHS_SEPARATOR = ".";
    protected static final String TOKEN_SEPARATORS = ":.";

    protected static RaceTime fromData(int[] data) {
        if (data.length != 2) {
            throw new IllegalArgumentException("RaceTime data must be {seconds, hundredths }: " + data);
        }
        return RaceTime.fromValues(data[0], data[1]);
    }

    public static RaceTime fromFloat(float floatValue) {
        return RaceTime.fromData(RaceTime.parseFloatTruncated(floatValue));
    }

    public static RaceTime fromString(String timeString) {
        return RaceTime.fromData(RaceTime.parseTimeString(timeString));
    }

    public static RaceTime fromValues(int seconds, int hundredths) {
        if (seconds == 0 && hundredths == 0) {
            return ZERO;
        }
        return new RaceTime(seconds, hundredths);
    }

    public static int[] parseTimeString(String timeString) {
        String hundredthsToken;
        int[] data;
        String errorMessage = "Illegal race time string: " + timeString;
        StringTokenizer tokenizer = new StringTokenizer(timeString.trim(), TOKEN_SEPARATORS);
        int nTokens = tokenizer.countTokens();
        if (nTokens == 0 || nTokens > 3) {
            throw new IllegalArgumentException(errorMessage);
        }
        String[] tokens = new String[nTokens];
        int[] parsedData = new int[nTokens];
        for (int i = 0; i < nTokens; ++i) {
            tokens[i] = tokenizer.nextToken();
            parsedData[i] = RaceTime.parseInt(tokens[i], errorMessage);
        }
        if (nTokens == 2) {
            data = parsedData;
            hundredthsToken = tokens[1];
        } else {
            data = new int[2];
            if (nTokens == 1) {
                data[0] = parsedData[0];
                data[1] = 0;
                hundredthsToken = "00";
            } else {
                data[0] = parsedData[0] * 60 + parsedData[1];
                data[1] = parsedData[2];
                hundredthsToken = tokens[2];
            }
        }
        if (hundredthsToken.length() == 1) {
            data[1] = data[1] * 10;
        } else if (hundredthsToken.length() > 2) {
            // empty if block
        }
        RaceTime.validateParsedData(data, errorMessage);
        return data;
    }

    protected RaceTime(int seconds, int hundredths) {
        super(seconds, hundredths);
    }

    public RaceTime add(RaceTime aTime) {
        if (this == NULL) {
            return aTime;
        }
        if (aTime == NULL) {
            return this;
        }
        return RaceTime.fromData(this.computeSum(aTime));
    }

    @Override
    public boolean isFinisher() {
        return true;
    }

    @Override
    public boolean isStarter() {
        return true;
    }

    public String toString() {
        return printFormat == 0 ? this.toStringMSH() : this.toStringSH();
    }

    public String toStringMSH() {
        int ss;
        int mm = 0;
        for (ss = this.intValue(); ss >= 60; ss -= 60) {
            ++mm;
        }
        StringBuffer sb = new StringBuffer();
        if (mm > 0) {
            sb.append(Integer.toString(mm));
            sb.append(SECONDS_SEPARATOR);
        }
        sb.append(this.toTwoDigitString(ss));
        sb.append(HUNDREDTHS_SEPARATOR);
        sb.append(this.toTwoDigitString(this.hundredthsValue()));
        return sb.toString();
    }

    public String toStringSH() {
        return Integer.toString(this.intValue()) + HUNDREDTHS_SEPARATOR + this.toTwoDigitString(this.hundredthsValue());
    }
}

