/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.models;

import com.glaivestone.javax.util.Numbers;
import org.ussamasters.aces.racedata.models.ScoringValue;

public abstract class RaceValueInHundredths<V extends RaceValueInHundredths<?>>
implements ScoringValue<V> {
    private final int units;
    private final int hundredths;

    protected static int[] parseFloatRounded(float floatValue) {
        int units = (int)floatValue;
        int hundredths = Math.round((floatValue - (float)units) * 100.0f);
        if (hundredths > 99) {
            hundredths -= 100;
        }
        return new int[]{++units, hundredths};
    }

    protected static int[] parseFloatTruncated(float floatValue) {
        int units = (int)floatValue;
        int hundredths = (int)((floatValue - (float)units) * 100.0f);
        return new int[]{units, hundredths};
    }

    protected static int parseInt(String digitString, String errorMessage) {
        try {
            return Integer.parseInt(digitString);
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    protected static void validateParsedData(int[] data, String errorMessagePrefix) {
        int aValue = data[0];
        if (aValue < 0) {
            throw new IllegalArgumentException(errorMessagePrefix + " - must be positive value");
        }
        aValue = data[1];
        if (aValue < 0 || aValue > 99) {
            throw new IllegalArgumentException(errorMessagePrefix + " - hundredths must be [0..99]");
        }
    }

    protected RaceValueInHundredths(int units, int hundredths) {
        if (units < 0) {
            throw new IllegalArgumentException("Invalid units: " + units + " must be positive");
        }
        if (hundredths < 0 || hundredths >= 100) {
            throw new IllegalArgumentException("Invalid hundredths: " + hundredths + " must be [0..99])");
        }
        this.units = units;
        this.hundredths = hundredths;
    }

    @Override
    public int compareTo(V other) {
        return this.compareQuantities((RaceValueInHundredths<?>)other);
    }

    public int compareQuantities(RaceValueInHundredths<?> other) {
        int comparison = Numbers.compare(this.units, other.units);
        if (comparison == 0) {
            comparison = Numbers.compare(this.hundredths, other.hundredths);
        }
        return comparison;
    }

    protected int[] computeDifference(V aValue) {
        int difHundredths;
        RaceValueInHundredths<V> larger;
        RaceValueInHundredths<V> smaller;
        if (this.compareTo(aValue) < 0) {
            smaller = this;
            larger = aValue;
        } else {
            larger = this;
            smaller = aValue;
        }
        int difUnits = larger.intValue() - smaller.intValue();
        for (difHundredths = larger.hundredthsValue() - smaller.hundredthsValue(); difHundredths < 0; difHundredths += 100) {
            --difUnits;
        }
        return new int[]{difUnits, difHundredths};
    }

    protected int[] computeSum(V aValue) {
        int sumHundredths;
        int sumUnits = this.intValue() + ((RaceValueInHundredths)aValue).intValue();
        for (sumHundredths = this.hundredthsValue() + ((RaceValueInHundredths)aValue).hundredthsValue(); sumHundredths > 99; sumHundredths -= 100) {
            ++sumUnits;
        }
        return new int[]{sumUnits, sumHundredths};
    }

    public boolean equals(Object other) {
        return other instanceof RaceValueInHundredths ? this.getClass() == other.getClass() && this.equalQuantities((RaceValueInHundredths)other) : false;
    }

    public boolean equals(V other) {
        if (other == null) {
            return false;
        }
        return this.equalQuantities(other);
    }

    public boolean equalQuantities(V other) {
        return this.intValue() == ((RaceValueInHundredths)other).intValue() && this.hundredthsValue() == ((RaceValueInHundredths)other).hundredthsValue();
    }

    public float floatValue() {
        return (float)this.units + (float)this.hundredths / 100.0f;
    }

    public int hashCode() {
        return this.units * 100 + this.hundredths;
    }

    public int hundredthsValue() {
        return this.hundredths;
    }

    public int intValue() {
        return this.units;
    }

    public int toHundredthsOfSeconds() {
        return this.intValue() * 100 + this.hundredthsValue();
    }

    @Override
    public String toScoringValueString() {
        return this.toString();
    }

    protected String toTwoDigitString(int value) {
        String digits = Integer.toString(value);
        return value < 10 ? "0" + digits : digits;
    }
}

