/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.models;

import org.ussamasters.aces.racedata.models.Gender;
import org.ussamasters.aces.racedata.models.RaceClass;
import org.ussamasters.aces.racedata.models.RaceClassHelper;
import org.ussamasters.aces.racedata.models.RaceClassRegistry;
import org.ussamasters.aces.racedata.models.RaceDate;
import org.ussamasters.aces.racedata.models.RaceOrganization;
import org.ussamasters.aces.racedata.models.SeasonIdentifier;
import org.ussamasters.aces.racedata.models.USSALicense;

public class Racer
implements Cloneable {
    public static final int UNKNOWN_BIB_NUMBER = -1;
    public static final int UNKNOWN_BIRTH_YEAR = -1;
    private int bibNumber;
    private String lastName;
    private String firstName;
    private Gender gender;
    private RaceClass<?> ageClass;
    private RaceClass<?> nationalClass;
    private int yearBorn;
    private RaceOrganization affiliation;
    private USSALicense ussaLicense;

    public static int computeRacerAge(RaceDate birthDate, SeasonIdentifier season) {
        return season.startYear - birthDate.getYear();
    }

    @Deprecated
    public static int computeRacerAge(RaceDate birthDate, int seasonStartYear) {
        return seasonStartYear - birthDate.getYear();
    }

    public static int computeRacerAge(int yearBorn, SeasonIdentifier season) {
        return season.startYear - yearBorn;
    }

    @Deprecated
    public static int computeRacerAge(int yearBorn, int seasonStartYear) {
        return seasonStartYear - yearBorn;
    }

    public static int parseYear(String dateString) {
        int year;
        if (dateString == null || (dateString = dateString.trim()).length() == 0) {
            return -1;
        }
        if (dateString.indexOf("-") > 1) {
            return new RaceDate(dateString).getYear();
        }
        try {
            year = Integer.parseInt(dateString);
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("Invalid year: " + dateString);
        }
        if (year <= 0) {
            return -1;
        }
        if (year < 100) {
            year += 1900;
        }
        return year;
    }

    public Racer(int bibNumber, String lastName, String firstName) {
        this.setBibNumber(bibNumber);
        this.setLastName(lastName);
        this.setFirstName(firstName);
        this.setBirthYear(-1);
    }

    protected Racer(Racer aRacer) {
        this.bibNumber = aRacer.bibNumber;
        this.lastName = aRacer.lastName;
        this.firstName = aRacer.firstName;
        this.gender = aRacer.gender;
        this.ageClass = aRacer.ageClass;
        this.nationalClass = aRacer.nationalClass;
        this.yearBorn = aRacer.yearBorn;
        this.affiliation = aRacer.affiliation;
        this.ussaLicense = aRacer.ussaLicense;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ex) {
            return null;
        }
    }

    public int compareByBib(Racer otherRacer) {
        if (this.bibNumber == otherRacer.bibNumber) {
            return this.compareByName(otherRacer);
        }
        return this.bibNumber < otherRacer.bibNumber ? -1 : 1;
    }

    public int compareByAge(Racer otherRacer) {
        return this.compareByNameIfTied(this.ageClass.compareAge(otherRacer.ageClass), otherRacer);
    }

    public int compareByAgeClass(Racer otherRacer) {
        return this.compareByNameIfTied(this.ageClass.compareStartOrder(otherRacer.ageClass), otherRacer);
    }

    public int compareByName(Racer otherRacer) {
        int comparison = this.lastName.compareTo(otherRacer.lastName);
        if (comparison == 0) {
            comparison = this.firstName.compareTo(otherRacer.firstName);
        }
        return comparison;
    }

    protected int compareByNameIfTied(int comparison, Racer otherRacer) {
        return comparison == 0 ? this.compareByName(otherRacer) : comparison;
    }

    public int compareByUSSAClass(Racer otherRacer) {
        return this.compareByNameIfTied(this.nationalClass.compareStartOrder(otherRacer.nationalClass), otherRacer);
    }

    public int computeAge(SeasonIdentifier season) {
        return Racer.computeRacerAge(this.getBirthYear(), season);
    }

    @Deprecated
    public int computeAge(int seasonStartYear) {
        return Racer.computeRacerAge(this.getBirthYear(), seasonStartYear);
    }

    protected RaceClass<?> defaultNationalClass() {
        return RaceClass.getUnknownClass(this.getNationalClassClass(), this.getGender());
    }

    public RaceOrganization getAffiliation() {
        return this.affiliation;
    }

    public RaceClass<?> getAgeClass() {
        return this.ageClass;
    }

    protected Class<? extends RaceClass<?>> getAgeClassClass() {
        return this.ageClass.getClass();
    }

    public String getBib() {
        return this.bibNumber != -1 ? "" + this.bibNumber : null;
    }

    public int getBibNumber() {
        return this.bibNumber;
    }

    public int getBirthYear() {
        return this.yearBorn;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public Gender getGender() {
        return this.gender;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getName() {
        return this.getNameLastFirst();
    }

    public String getNameLastFirst() {
        return this.lastName + ", " + this.firstName;
    }

    public String getNameFirstLast() {
        return this.firstName + " " + this.lastName;
    }

    public RaceClass<?> getNationalClass() {
        return this.nationalClass;
    }

    protected Class<? extends RaceClass<?>> getNationalClassClass() {
        Class<Object> nationalClassClass = this.nationalClass != null ? this.nationalClass.getClass() : RaceClassRegistry.current().getNationalClassClass(this.getAgeClassClass());
        return nationalClassClass;
    }

    protected Class<? extends RaceClass<?>> getNationalClassClass(Class<? extends RaceClass<?>> ageClassClass) {
        Class<Object> nationalClassClass = this.nationalClass != null ? this.nationalClass.getClass() : RaceClassRegistry.current().getNationalClassClass(ageClassClass);
        return nationalClassClass;
    }

    public USSALicense getUSSALicense() {
        return this.ussaLicense;
    }

    public void initCompetitionClassValues(Gender gender, RaceClass<?> ageClass, RaceClass<?> nationalClass, int yearBorn) {
        this.initCompetitionClassValues(gender, ageClass, nationalClass, yearBorn, true);
    }

    public void initCompetitionClassValuesLenient(Gender gender, RaceClass<?> ageClass, RaceClass<?> nationalClass, int yearBorn) {
        this.initCompetitionClassValues(gender, ageClass, nationalClass, yearBorn, false);
    }

    protected void initCompetitionClassValues(Gender gender, RaceClass<?> ageClass, RaceClass<?> nationalClass, int yearBorn, boolean performStrongValidation) {
        if (gender == null) {
            if (ageClass != null) {
                gender = ageClass.getGender();
            } else if (nationalClass != null) {
                gender = nationalClass.getGender();
            }
        }
        if (ageClass == null) {
            throw new IllegalArgumentException("Racer age class may not be null");
        }
        if (performStrongValidation) {
            this.validateAgeClassStrong(ageClass);
        } else {
            this.validateAgeClassLenient(ageClass);
        }
        if (nationalClass == null) {
            Class<?> ageClassClass = ageClass.getClass();
            Class<? extends RaceClass<?>> nationalClassClass = this.getNationalClassClass(ageClassClass);
            if (ageClass.getRaceClassType().isNationalClass()) {
                nationalClass = ageClass;
            } else if (RaceClassRegistry.current().getAgeRange(ageClassClass) == RaceClassRegistry.current().getAgeRange(nationalClassClass)) {
                nationalClass = RaceClass.resolveName(ageClass.name, nationalClassClass);
            }
        }
        this.setGender(gender);
        this.setBirthYear(yearBorn);
        this.setAgeClassAttribute(ageClass);
        this.setNationalClass(nationalClass);
    }

    public void initLicenseValues(RaceOrganization affiliation, String ussaNumber) {
        if (ussaNumber == null) {
            ussaNumber = "";
        }
        RaceOrganization licenseAffiliation = USSALicense.getAffiliation(ussaNumber);
        if (affiliation == null && licenseAffiliation != null) {
            affiliation = licenseAffiliation;
        }
        this.setAffiliation(affiliation);
        this.setUSSALicense(USSALicense.fromString(ussaNumber));
    }

    public void initNationalClass(SeasonIdentifier season) {
        RaceClass<?> ncCandidate;
        Class<? extends RaceClass<?>> nationalClassClass = this.getNationalClassClass();
        RaceClassHelper raceClassHelper = new RaceClassHelper(season);
        if (this.isBirthYearKnown()) {
            this.setNationalClass(raceClassHelper.raceClassForAge(this.getGender(), this.computeAge(season), nationalClassClass));
            return;
        }
        if (this.getAgeClass().isDivisionClass() && !this.getAgeClass().isUnknown() && (ncCandidate = raceClassHelper.raceClassForAge(this.getGender(), this.getAgeClass().startAge, nationalClassClass)) != null && ncCandidate.equalAgeRange(this.getAgeClass())) {
            this.setNationalClass(ncCandidate);
            return;
        }
        this.setNationalClass(null);
    }

    public boolean hasBibNumber() {
        return this.getBibNumber() != -1;
    }

    public boolean hasValidAgeClass() {
        return this.getAgeClass().isAgeGroupClass();
    }

    public boolean isBirthYearKnown() {
        return this.yearBorn != -1;
    }

    public boolean isInAgeClass(RaceClass<?> raceClass) {
        return raceClass == this.getAgeClass();
    }

    public void setAffiliation(RaceOrganization affiliation) {
        this.affiliation = affiliation != null ? affiliation : RaceOrganization.UNKNOWN;
    }

    public void setAgeClass(RaceClass<?> ageClass) {
        this.validateAgeClassStrong(ageClass);
        this.setAgeClassAttribute(ageClass);
    }

    protected void setAgeClassAttribute(RaceClass<?> ageClass) {
        this.ageClass = ageClass;
    }

    public void setAgeClassLenient(RaceClass<?> ageClass) {
        this.validateAgeClassLenient(ageClass);
        this.setAgeClassAttribute(ageClass);
    }

    public void setBibNumber(int bibNumber) {
        this.bibNumber = bibNumber > 0 ? bibNumber : -1;
    }

    public void setBirthYear(int yearBorn) {
        this.yearBorn = yearBorn <= 0 ? -1 : yearBorn;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public void setGender(Gender gender) {
        this.gender = gender;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public void setNationalClass(RaceClass<?> nationalClass) {
        this.nationalClass = nationalClass != null && nationalClass.isAgeGroupClass() ? nationalClass : this.defaultNationalClass();
    }

    public void setUSSALicense(USSALicense ussaLicense) {
        this.ussaLicense = ussaLicense;
    }

    public String toString() {
        return String.format("a %s (%s - %s, %s)", this.getClass().getSimpleName(), this.bibNumber, this.lastName, this.firstName);
    }

    protected void validateAgeClassLenient(RaceClass<?> ageClass) {
        if (ageClass == null) {
            throw new IllegalArgumentException("Racer age class not specified: " + ageClass);
        }
    }

    protected void validateAgeClassStrong(RaceClass<?> ageClass) {
        if (ageClass == null || !ageClass.isAgeGroupClass()) {
            throw new IllegalArgumentException("Racer age class not specified: " + ageClass);
        }
    }
}

