/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.models;

import org.ussamasters.aces.racedata.models.CompetitorResultValue;
import org.ussamasters.aces.racedata.models.RacePoints;
import org.ussamasters.aces.racedata.models.RaceTime;
import org.ussamasters.aces.racedata.models.ScoringResult;
import org.ussamasters.aces.racedata.models.UnqualifiedResult;
import org.ussamasters.aces.racedata.models.WorldCupPoints;

public class RacerResult
extends ScoringResult {
    private CompetitorResultValue<?> resultValue;
    private WorldCupPoints<?> wcPoints;
    private RacePoints racePoints;

    public RacerResult() {
        this.clearTime();
        this.clearFinishStatistics();
    }

    public void clearFinishStatistics() {
        this.clearPosition();
        this.clearPoints();
    }

    public void clearPoints() {
        this.setPoints(null);
        this.setRacePoints(null);
    }

    protected void clearTime() {
        this.setResultValue(UnqualifiedResult.DNS);
    }

    public int compareByPoints(RacerResult otherResult) {
        this.checkComparable(otherResult);
        return this.compareScoringValues(this.getPoints(), otherResult.getPoints());
    }

    public int compareByRacePoints(RacerResult otherResult) {
        this.checkComparable(otherResult);
        return this.compareScoringValues(this.getRacePoints(), otherResult.getRacePoints());
    }

    public int compareByTime(RacerResult otherResult) {
        this.checkComparable(otherResult);
        if (this.isFinisher()) {
            return otherResult.isFinisher() ? this.getTime().compareTo(otherResult.getTime()) : -1;
        }
        if (otherResult.isFinisher()) {
            return 1;
        }
        if (this.getResultValue() == otherResult.getResultValue()) {
            return 0;
        }
        if (!this.isStarter()) {
            return 1;
        }
        if (!otherResult.isStarter()) {
            return -1;
        }
        return this.compareByTimeNonFinisher(otherResult);
    }

    protected int compareByTimeNonFinisher(RacerResult otherResult) {
        return 0;
    }

    public UnqualifiedResult getNoResultValue() {
        return (UnqualifiedResult)this.resultValue;
    }

    public WorldCupPoints<?> getPoints() {
        return this.wcPoints;
    }

    public RacePoints getRacePoints() {
        return this.racePoints;
    }

    public CompetitorResultValue<?> getResultValue() {
        return this.resultValue;
    }

    public RaceTime getTime() {
        return (RaceTime)this.resultValue;
    }

    public boolean isFinisher() {
        return this.getResultValue().isFinisher();
    }

    public boolean isStarter() {
        return this.getResultValue().isStarter();
    }

    public void setNoResultValue(UnqualifiedResult result) {
        this.setResultValue(result);
    }

    public void setPoints(WorldCupPoints<?> points) {
        this.wcPoints = points;
    }

    public void setPosition(String positionString) {
        int positionValue;
        if (positionString == null) {
            this.clearPosition();
            return;
        }
        String intValueString = positionString.trim();
        if (intValueString.length() == 0) {
            this.setPosition(0);
            this.setTied(false);
            return;
        }
        boolean isTied = intValueString.endsWith("(t)");
        if (isTied) {
            intValueString = intValueString.substring(0, intValueString.length() - "(t)".length());
        }
        try {
            positionValue = Integer.parseInt(intValueString);
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("Invalid racer finish position string: '" + positionString + "'");
        }
        this.setPosition(positionValue);
        this.setTied(isTied);
    }

    public void setRacePoints(RacePoints points) {
        this.racePoints = points;
    }

    public void setResultValue(CompetitorResultValue<?> resultValue) {
        this.resultValue = resultValue == null ? UnqualifiedResult.DNS : resultValue;
    }

    public void setTime(RaceTime time) {
        this.setResultValue(time);
    }
}

