/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.models;

import com.glaivestone.javax.lang.ConstantValue;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.ussamasters.aces.racedata.models.RaceDate;
import org.ussamasters.javax.io.ConstantLoader;
import org.ussamasters.javax.io.ConstantSpecifications;

public class SeasonIdentifier
extends ConstantValue<SeasonIdentifier> {
    private static final Class<SeasonIdentifier> THIS_CLASS = SeasonIdentifier.class;
    private static final String CONFIG_DIR_REF = "/" + THIS_CLASS.getPackage().getName().replaceAll("\\.", "/").replace("/models", "/configuration");
    public static final SeasonIdentifier UNKNOWN;
    public static final SeasonIdentifier CURRENT;
    public static final String BUILTIN_CONSTANT_SPECS;
    public static final String SPEC_FIELD_NAME = "name";
    public static final String SPEC_FIELD_START_YEAR = "startYear";
    public static final String SPEC_FIELD_END_YEAR = "endYear";
    public static final List<String> CONSTANT_SPEC_FIELDS;
    public static final boolean ALLOW_SYNONYMS = true;
    public final int startYear;
    public final int endYear;

    public static SeasonIdentifier forSeason(int seasonYear) {
        return SeasonIdentifier.getConstant("" + seasonYear);
    }

    public static SeasonIdentifier forStartYear(int startYear) {
        return SeasonIdentifier.forSeason(startYear + 1);
    }

    public static SeasonIdentifier getConstant(String name) {
        return SeasonIdentifier.getConstant(name, THIS_CLASS);
    }

    public static List<SeasonIdentifier> values() {
        return SeasonIdentifier.values(THIS_CLASS);
    }

    public static SeasonIdentifier defineConstant(String name, int startYear, int endYear) {
        SeasonIdentifier cnst = SeasonIdentifier.getConstant(name);
        if (cnst != null) {
            cnst.validateDefinitionConsistency(startYear, endYear);
        } else {
            cnst = new SeasonIdentifier(name, startYear, endYear);
            cnst.validateYearRange();
        }
        return cnst;
    }

    public static void loadConstants(String fileRef) {
        ConstantSpecifications specs = ConstantLoader.loadSpecificationsFromFile(fileRef);
        specs.ensureWellFormed(CONSTANT_SPEC_FIELDS);
        for (Map<String, Object> entry : specs.getEntries()) {
            String constantName = (String)entry.get(SPEC_FIELD_NAME);
            int startYear = (Integer)entry.get(SPEC_FIELD_START_YEAR);
            int endYear = (Integer)entry.get(SPEC_FIELD_END_YEAR);
            SeasonIdentifier.defineConstant(constantName, startYear, endYear);
            List<String> synonyms = specs.getSynonyms(constantName);
            for (String synonym : synonyms) {
                SeasonIdentifier.registerSynonym(synonym, constantName, THIS_CLASS);
            }
        }
    }

    private SeasonIdentifier(String name, int startYear, int endYear) {
        super(-1, name);
        this.startYear = startYear;
        this.endYear = endYear;
    }

    @Override
    protected boolean allowSynonyms() {
        return true;
    }

    protected void validateDefinitionConsistency(int startYear, int endYear) {
        if (this.startYear != startYear || this.endYear != endYear) {
            throw new IllegalArgumentException(String.format("Conflicting constant definition: cannot change %s from <%s, %s> to <%s, %s>", this.toConstantName(), this, startYear, this.endYear, startYear, endYear));
        }
    }

    protected void validateYearRange() {
        if (this.startYear >= this.endYear) {
            throw new IllegalArgumentException(String.format("Invalid constant definition: cannot define season %s as <%s, %s>", this.toConstantName(), this.startYear, this.endYear));
        }
    }

    public RaceDate getStartDate() {
        String date = String.format("%04d0701", this.startYear);
        return RaceDate.fromDigitString(date);
    }

    public RaceDate getEndDate() {
        String date = String.format("%04d0630", this.endYear);
        return RaceDate.fromDigitString(date);
    }

    public int getSeasonYear() {
        return this.endYear;
    }

    public int[] getYearRange() {
        int[] years = new int[]{this.startYear, this.endYear};
        return years;
    }

    @Override
    public String toDescriptionString() {
        return String.format("%s[%s]", this.name(), this.toSeasonYearsString());
    }

    public String toSeasonYearsString() {
        return String.format("%04d-%04d", this.startYear, this.endYear);
    }

    public static void main(String[] args) {
        ConstantLoader.checkSpecificationLoading(BUILTIN_CONSTANT_SPECS);
        boolean checkAddRemove = false;
        if (checkAddRemove) {
            System.out.println("\n###Test constant add/remove:");
            System.out.println("Num season constants before: " + SeasonIdentifier.values().size());
            SeasonIdentifier cnst = SeasonIdentifier.defineConstant("test", 2000, 2001);
            System.out.println("Defined: " + cnst);
            System.out.println("Num season constants updated: " + SeasonIdentifier.values().size());
            System.out.println("Remove test constant:");
            cnst.removeConstant();
            System.out.println("Defined: " + SeasonIdentifier.getConstant("test"));
            System.out.println("Num season constants after: " + SeasonIdentifier.values().size());
            System.out.println("...done");
        }
    }

    static {
        BUILTIN_CONSTANT_SPECS = CONFIG_DIR_REF + "/constants/SeasonIdentifier.yml";
        CONSTANT_SPEC_FIELDS = Collections.unmodifiableList(Arrays.asList(SPEC_FIELD_NAME, SPEC_FIELD_START_YEAR, SPEC_FIELD_END_YEAR));
        UNKNOWN = new SeasonIdentifier("UNK", 0, 0);
        SeasonIdentifier.loadConstants(BUILTIN_CONSTANT_SPECS);
        CURRENT = SeasonIdentifier.getConstant("CURRENT");
    }
}

