/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.models;

import com.glaivestone.javax.util.Numbers;
import org.ussamasters.aces.racedata.models.FinishPositionPoints;
import org.ussamasters.aces.racedata.models.RaceDataConstant;

public class SiseCupPoints
extends FinishPositionPoints<SiseCupPoints>
implements RaceDataConstant {
    public static final SiseCupPoints ZERO;
    protected static final int maxPointsForPredefinedValue;
    protected static final SiseCupPoints[] predefinedValues;
    protected static final int nPointScoringPositions;
    protected static final SiseCupPoints[] finishPositionPointScores;

    public static SiseCupPoints forPoints(int points) {
        if (points < 0) {
            throw new IllegalArgumentException("Invalid value for Sise Cup points: " + points);
        }
        return points <= maxPointsForPredefinedValue ? predefinedValues[points] : new SiseCupPoints(points);
    }

    public static SiseCupPoints forPosition(int position) {
        if (position <= 0) {
            throw new IllegalArgumentException("Invalid position for Sise Cup points: " + position);
        }
        if (position > nPointScoringPositions) {
            return ZERO;
        }
        return finishPositionPointScores[position - 1];
    }

    public static SiseCupPoints forPosition(int position, int nCompetitorsInClass) {
        if (position <= 0) {
            throw new IllegalArgumentException("Invalid position for Sise Cup points: " + position);
        }
        if (position > nPointScoringPositions) {
            return ZERO;
        }
        if (nCompetitorsInClass < nPointScoringPositions) {
            int delta = nPointScoringPositions - nCompetitorsInClass;
            return SiseCupPoints.forPoints(finishPositionPointScores[position - 1].intValue() - delta);
        }
        return finishPositionPointScores[position - 1];
    }

    public static int compareQuantities(int thisValue, int otherValue) {
        return 0 - Numbers.compare(thisValue, otherValue);
    }

    protected SiseCupPoints(int points) {
        super(points);
    }

    public SiseCupPoints add(SiseCupPoints otherPoints) {
        if (otherPoints == ZERO) {
            return this;
        }
        if (this == ZERO) {
            return otherPoints;
        }
        return SiseCupPoints.forPoints(this.intValue() + otherPoints.intValue());
    }

    public String toString() {
        return this.getClass().getName() + (this == ZERO ? ".ZERO" : "{" + this.points + "}");
    }

    static {
        int[] siseCupPointsSpec = new int[]{10, 8, 6, 4, 2};
        ZERO = new SiseCupPoints(0);
        maxPointsForPredefinedValue = siseCupPointsSpec[0];
        predefinedValues = new SiseCupPoints[maxPointsForPredefinedValue + 1];
        SiseCupPoints.predefinedValues[0] = ZERO;
        for (int points = 1; points <= maxPointsForPredefinedValue; ++points) {
            SiseCupPoints.predefinedValues[points] = new SiseCupPoints(points);
        }
        nPointScoringPositions = siseCupPointsSpec.length;
        finishPositionPointScores = new SiseCupPoints[nPointScoringPositions];
        for (int i = 0; i < nPointScoringPositions; ++i) {
            int points = siseCupPointsSpec[i];
            SiseCupPoints.finishPositionPointScores[i] = predefinedValues[points];
        }
    }
}

