/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.reports;

import java.util.HashSet;
import java.util.List;
import org.jdom2.Content;
import org.jdom2.Element;
import org.ussamasters.aces.racedata.models.DivisionsCupResult;
import org.ussamasters.aces.racedata.models.NamedRacerResult;
import org.ussamasters.aces.racedata.models.RaceOrganization;
import org.ussamasters.aces.racedata.models.RaceResult;
import org.ussamasters.aces.racedata.models.RaceSeries;
import org.ussamasters.aces.racedata.models.RaceSeriesResult;
import org.ussamasters.aces.racedata.models.RaceStartResult;
import org.ussamasters.aces.racedata.models.RaceType;
import org.ussamasters.aces.racedata.models.Racer;
import org.ussamasters.aces.racedata.models.ScoringElement;
import org.ussamasters.aces.racedata.models.SeriesRacerSummary;
import org.ussamasters.aces.racedata.models.StandingsCategory;
import org.ussamasters.aces.racedata.models.StandingsSummaryData;
import org.ussamasters.aces.racedata.reports.ScoringData;
import org.ussamasters.aces.racedata.reports.ScoringDataDocument;
import org.ussamasters.aces.racedata.reports.SeriesScoring;
import org.ussamasters.aces.racedata.reports.SeriesScoringValueRenderer;
import org.ussamasters.aces.racedata.scoring.CategoryResultsList;
import org.ussamasters.aces.racedata.scoring.DivisionsCupStandings;
import org.ussamasters.aces.racedata.scoring.MedalCountsResult;
import org.ussamasters.aces.racedata.scoring.MedalCountsStandings;
import org.ussamasters.aces.racedata.scoring.SeriesStandings;
import org.ussamasters.aces.racedata.scoring.SeriesStandingsScoringPolicy;
import org.ussamasters.aces.racedata.scoring.SeriesSummaryStatistics;
import org.ussamasters.aces.racedata.scoring.Standings;

public class SeriesScoringDocument
extends ScoringDataDocument {
    public static final String ROOT_NODE_NAME = "ACES_SeriesScoring";
    public static final String DTD_URI = "http://www.glaivestone.com/aces/schemas/2002/seriesscoring.dtd";
    public static final String SCHEMA_URI = "http://www.glaivestone.com/aces/schemas/2002/seriesscoring.xsd";
    public static final String EN_EVENT_SECTION = "event";
    public static final String EN_STANDINGS_TYPE = "standingsType";
    public static final String EN_RACES_SECTION = "races";
    public static final String EN_SCORING_ELEMENT = "scoringElement";
    public static final String EN_SCORING_POLICY = "scoringPolicy";
    public static final String EN_SUMMARY_COMPETITOR_STARTS = "competitorStarts";
    public static final String EN_SUMMARY_RACE_STARTS = "raceStarts";
    public static final String AN_SUMMARY_NUM_RACES = "nRaces";
    public static final String EN_SUMMARY_TEAM_SUMMARY = "teamSummary";
    public static final String EN_SUMMARY_TEAM_MEDALS = "teamMedals";
    public static final String AN_SUMMARY_TEAM_STATUS = "status";
    public static final String AN_SUMMARY_TOTAL = "total";
    public static final String AN_SUMMARY_AVERAGE = "ave";
    public static final String AN_SUMMARY_GOLD_MEDALS = "gold";
    public static final String AN_SUMMARY_SILVER_MEDALS = "silver";
    public static final String AN_SUMMARY_BRONZE_MEDALS = "bronze";
    public static final String AN_SUMMARY_NUM_MEDALISTS = "nMedalists";
    public static final String AN_SUMMARY_NUM_COMPETITORS = "nRacers";
    public static final String AN_SUMMARY_FINISH_POSITION = "posn";
    public static final String AN_MULTIPLE_RESULTS = "multipleResults";
    public static final String EN_SCORE = "score";
    public static final String AN_TIME = "time";
    public static final String EN_RACE_START_SCORE = "rsScore";
    public static final String AN_RACE_START_INDEX = "ri";
    public static final String AN_RACE_FINISH_POSITION = "posn";
    public static final String AN_RSSCORE_COUNTS = "counted";
    public static final String VALUE_MULTI_CLASS_RACER = "yes";
    protected SeriesScoring seriesScoring;
    protected RaceSeries raceSeries;
    protected int nRaces;
    protected SeriesScoringValueRenderer scoringValueRenderer;

    public SeriesScoringDocument(SeriesScoring seriesScoring) {
        this.seriesScoring = seriesScoring;
        this.raceSeries = this.seriesScoring.getRaceSeries();
        this.nRaces = this.raceSeries.size();
        this.scoringValueRenderer = SeriesScoringValueRenderer.forScoringElement(this.seriesScoring.getScoringElement());
    }

    @Override
    protected void buildDocumentContent() {
        this.getRootElement().addContent((Content)this.createEventSection());
        this.getRootElement().addContent((Content)this.createScoringSection());
        this.setReportPolicy((Standings)this.seriesScoring.getFirstStandings());
        this.getRootElement().addContent((Content)this.createCompetitorsSection());
        for (SeriesStandings seriesStandings : this.seriesScoring.getStandings()) {
            this.setReportPolicy(seriesStandings);
            this.getRootElement().addContent((Content)this.createStandingsSection(seriesStandings));
        }
        this.getRootElement().addContent((Content)this.createAuxInfoSection());
    }

    protected Element createCompetitorElement(RaceSeriesResult racerResult) {
        Racer aRacer = racerResult.getRacer();
        SeriesRacerSummary racerSummary = racerResult.getRacerSummary();
        Element anElement = this.createCompetitorElement(aRacer, aRacer.getAgeClass());
        if (racerSummary.hasStartsInMultipleCategories()) {
            anElement.setAttribute("nStarts", "" + racerSummary.getNumberOfStarts());
            anElement.setAttribute("nFinishes", "" + racerSummary.getNumberOfFinishes());
        }
        return anElement;
    }

    @Override
    protected Element createCompetitorResultElement(NamedRacerResult racerResult, Object category) {
        boolean isMultiCategoryRacer;
        Element anElement = super.createCompetitorResultElement(racerResult, category);
        RaceSeriesResult seriesResult = (RaceSeriesResult)racerResult;
        SeriesRacerSummary racerSummary = seriesResult.getRacerSummary();
        boolean racerHasResults = seriesResult.isStarter() || this.isQualified(seriesResult);
        boolean bl = isMultiCategoryRacer = racerSummary.hasStartsInMultipleCategories() || this.isAgeClassCategory(seriesResult.getCategory()) && racerSummary.hasStartsInAbilityGroupClass();
        if (this.isAbilityClassCategory(category)) {
            anElement.setAttribute("ageClass", racerSummary.getRacer().getAgeClass().name);
        }
        anElement.setAttribute(AN_SUMMARY_TEAM_STATUS, this.toRacerStatus(seriesResult));
        if (racerHasResults) {
            anElement.setAttribute("nStarts", "" + seriesResult.getNumberOfStarts());
            anElement.setAttribute("nFinishes", "" + seriesResult.getNumberOfFinishes());
            if (isMultiCategoryRacer) {
                anElement.setAttribute(AN_MULTIPLE_RESULTS, VALUE_MULTI_CLASS_RACER);
            }
        }
        if (this.isQualified(seriesResult)) {
            anElement.addContent((Content)this.createCompetitorPositionElement(racerResult));
            anElement.addContent((Content)this.createCompetitorScoreElement(seriesResult));
        }
        if (racerHasResults) {
            for (int i = 0; i < this.nRaces; ++i) {
                RaceStartResult startResult = seriesResult.getStartResult(i);
                if (startResult == null) continue;
                anElement.addContent((Content)this.createCompetitorStartResultElement(startResult, i + 1));
            }
        }
        return anElement;
    }

    protected Element createCompetitorScoreElement(RaceSeriesResult seriesResult) {
        String score = this.scoringValueRenderer.toSeriesScoreString(seriesResult);
        Element anElement = this.createTextElement(EN_SCORE, score);
        if (this.seriesScoring.getScoringElement() == ScoringElement.ADJUSTED_TIME) {
            anElement.setAttribute(AN_TIME, "" + seriesResult.getActualTime());
        }
        return anElement;
    }

    protected Element createCompetitorStartResultElement(RaceStartResult racerResult, int raceIndex) {
        String score = this.scoringValueRenderer.toRaceStartScoreString(racerResult);
        Element anElement = this.createTextElement(EN_RACE_START_SCORE, score);
        anElement.setAttribute(AN_RACE_START_INDEX, "" + raceIndex);
        if (racerResult.isFinisher()) {
            String positionString = racerResult.getPositionString();
            if (positionString == null) {
                System.out.println("***SHOULD NOT BE***");
                String string = racerResult.getPositionString();
            }
            anElement.setAttribute("posn", positionString);
        }
        return anElement;
    }

    protected Element createCompetitorsSection() {
        Element aSection = new Element("competitors");
        HashSet<Racer> allRacers = new HashSet<Racer>();
        SeriesStandings standings = (SeriesStandings)this.seriesScoring.getFirstStandings();
        for (StandingsCategory standingsCategory : standings.categories()) {
            CategoryResultsList<RaceSeriesResult> categoryResultsList = standings.getCategoryResults(standingsCategory);
            if (!this.shouldWriteCategoryResults(categoryResultsList)) continue;
            for (RaceSeriesResult racerResult : categoryResultsList) {
                Racer theRacer = racerResult.getRacer();
                if (!this.shouldWriteRacerEntry(racerResult) || allRacers.contains(theRacer)) continue;
                aSection.addContent((Content)this.createCompetitorElement(racerResult));
                allRacers.add(theRacer);
            }
        }
        return aSection;
    }

    protected Element createEventSection() {
        Element aSection = new Element(EN_EVENT_SECTION);
        this.addTextElement("name", this.raceSeries.getName(), aSection);
        this.addTextElement(EN_STANDINGS_TYPE, this.seriesScoring.getStandingsType().name, aSection);
        aSection.addContent((Content)this.createRaceClassesConstantElement(this.raceSeries.getRaceClassClass()));
        aSection.addContent((Content)this.createRacesSection());
        return aSection;
    }

    protected Element createRacesSection() {
        Element aSection = new Element(EN_RACES_SECTION);
        for (RaceResult raceResult : this.raceSeries.getRaceResults()) {
            aSection.addContent((Content)this.createRaceElement(raceResult));
        }
        return aSection;
    }

    protected Element createScoringPolicyElement() {
        SeriesStandingsScoringPolicy scoringPolicy = this.seriesScoring.getScoringPolicy();
        return this.createNamedTextElement(EN_SCORING_POLICY, scoringPolicy.name(), scoringPolicy.description());
    }

    protected Element createScoringSection() {
        Element aSection = new Element("scoring");
        this.addTextElement(EN_SCORING_ELEMENT, this.seriesScoring.getScoringElement().name, aSection);
        aSection.addContent((Content)this.createScoringPolicyElement());
        return aSection;
    }

    @Override
    protected Element createStandingsSummaryElement(Standings standings) {
        Element anElement;
        block6: {
            block5: {
                int i;
                anElement = super.createStandingsSummaryElement(standings);
                SeriesStandings seriesStandings = (SeriesStandings)standings;
                SeriesSummaryStatistics summaryStatistics = seriesStandings.getSummaryStatistics();
                StandingsSummaryData[] statistics = summaryStatistics.getCompetitorStartsStatistics();
                for (i = 0; i < statistics.length; ++i) {
                    anElement.addContent((Content)this.createSummaryCompetitorStartsElement(statistics[i]));
                }
                statistics = summaryStatistics.getRaceStartsStatistics();
                if (statistics != null) {
                    for (i = 0; i < statistics.length; ++i) {
                        if (statistics[i].getTotal() <= 0) continue;
                        anElement.addContent((Content)this.createSummaryRaceStartsElement(statistics[i]));
                    }
                }
                if (!(standings instanceof DivisionsCupStandings)) break block5;
                List<DivisionsCupResult> divisionResultsList = ((DivisionsCupStandings)standings).getDivisionResults();
                for (DivisionsCupResult dcResult : divisionResultsList) {
                    anElement.addContent((Content)this.createSummaryTeamResultsElement(dcResult));
                }
                break block6;
            }
            if (!(standings instanceof MedalCountsStandings)) break block6;
            List<MedalCountsResult> teamResults = ((MedalCountsStandings)standings).getTeamResults();
            for (MedalCountsResult medalCountsResult : teamResults) {
                anElement.addContent((Content)this.createSummaryTeamMedalsElement(medalCountsResult));
            }
        }
        return anElement;
    }

    protected Element createSummaryCompetitorStartsElement(StandingsSummaryData statistics) {
        Element anElement = new Element(EN_SUMMARY_COMPETITOR_STARTS);
        anElement.setAttribute("category", this.toCategoryString(statistics.getCategory()));
        anElement.setAttribute(AN_SUMMARY_TOTAL, "" + statistics.getTotal());
        anElement.setAttribute(AN_SUMMARY_AVERAGE, "" + statistics.getAverage());
        return anElement;
    }

    protected Element createSummaryRaceStartsElement(StandingsSummaryData statistics) {
        Element anElement = new Element(EN_SUMMARY_RACE_STARTS);
        anElement.setAttribute("category", this.toCategoryString(statistics.getCategory()));
        anElement.setAttribute(AN_SUMMARY_TOTAL, "" + statistics.getTotal());
        anElement.setAttribute(AN_SUMMARY_AVERAGE, "" + statistics.getAverage());
        anElement.setAttribute(AN_SUMMARY_NUM_RACES, "" + statistics.getNumberOfDataSources());
        return anElement;
    }

    protected Element createSummaryTeamResultsElement(DivisionsCupResult teamResult) {
        RaceOrganization team = teamResult.getAffiliation();
        boolean isQualified = teamResult.isQualified();
        float pointsPerStart = teamResult.getPointsPerStart();
        Element anElement = new Element(EN_SUMMARY_TEAM_SUMMARY);
        anElement.setAttribute("name", team.name);
        anElement.setAttribute(AN_SUMMARY_TEAM_STATUS, isQualified ? "QLF" : "DNQ");
        if (isQualified) {
            anElement.setAttribute("posn", teamResult.getPositionString());
        }
        anElement.setAttribute(AN_SUMMARY_TOTAL, "" + teamResult.getDivisionsCupPoints().intValue());
        anElement.setAttribute(AN_SUMMARY_AVERAGE, "" + pointsPerStart);
        anElement.setAttribute(AN_SUMMARY_NUM_COMPETITORS, "" + teamResult.getNumberOfCompetitors());
        anElement.setAttribute("nStarts", "" + teamResult.getNumberOfStarts());
        this.addTextElement("description", this.toCategoryString(team), anElement);
        return anElement;
    }

    protected Element createSummaryTeamMedalsElement(MedalCountsResult teamResult) {
        RaceOrganization team = teamResult.getAffiliation();
        String[] medalCountAttributes = new String[]{AN_SUMMARY_TOTAL, AN_SUMMARY_GOLD_MEDALS, AN_SUMMARY_SILVER_MEDALS, AN_SUMMARY_BRONZE_MEDALS};
        Element anElement = new Element(EN_SUMMARY_TEAM_MEDALS);
        boolean isQualified = teamResult.isQualified();
        anElement.setAttribute("name", team.name);
        anElement.setAttribute(AN_SUMMARY_TEAM_STATUS, isQualified ? "QLF" : "DNQ");
        if (isQualified) {
            anElement.setAttribute("posn", teamResult.getPositionString());
            anElement.setAttribute(AN_SUMMARY_TOTAL, "" + teamResult.getTotalMedals());
            for (int i = 1; i < medalCountAttributes.length; ++i) {
                int nMedals = teamResult.getTotalMedals(i);
                if (nMedals <= 0) continue;
                anElement.setAttribute(medalCountAttributes[i], "" + nMedals);
            }
            anElement.setAttribute(AN_SUMMARY_NUM_MEDALISTS, "" + teamResult.getNumberOfMedalists());
        }
        anElement.setAttribute(AN_SUMMARY_NUM_COMPETITORS, "" + teamResult.getNumberOfCompetitors());
        anElement.setAttribute("nStarts", "" + teamResult.getNumberOfStarts());
        this.addTextElement("description", this.toCategoryString(team), anElement);
        return anElement;
    }

    @Override
    protected ScoringData<?> getScoringData() {
        return this.seriesScoring;
    }

    @Override
    protected void initDocument() {
        this.initDocument(ROOT_NODE_NAME, DTD_URI, SCHEMA_URI);
    }

    @Override
    protected boolean isQualified(NamedRacerResult racerResult) {
        return this.isQualified((RaceSeriesResult)racerResult);
    }

    protected boolean isQualified(RaceSeriesResult racerResult) {
        return racerResult.isQualified();
    }

    @Override
    protected boolean shouldWriteCategoryResults(CategoryResultsList<?> categoryResultsList) {
        return super.shouldWriteCategoryResults(categoryResultsList);
    }

    @Override
    protected boolean shouldWriteRacerEntry(NamedRacerResult racerResult) {
        return ((RaceSeriesResult)racerResult).getRacerSummary().getNumberOfStarts() > 0;
    }

    protected String toCategoryString(RaceOrganization affiliation) {
        return affiliation.description;
    }

    @Override
    protected String toCategoryString(Object category) {
        if (category instanceof RaceType) {
            return ((RaceType)category).name;
        }
        return super.toCategoryString(category);
    }

    protected String toRacerStatus(RaceSeriesResult racerResult) {
        if (this.isQualified(racerResult)) {
            return "QLF";
        }
        if (racerResult.isStarter()) {
            return "DNQ";
        }
        return "DNS";
    }
}

