/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.reports;

import com.glaivestone.javax.lang.ConstantValueWithDescription;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.ussamasters.aces.racedata.models.AllRacersCategory;
import org.ussamasters.aces.racedata.models.FISMastersGroup;
import org.ussamasters.aces.racedata.models.Gender;
import org.ussamasters.aces.racedata.models.NamedRacerResult;
import org.ussamasters.aces.racedata.models.NationalClassGroup;
import org.ussamasters.aces.racedata.models.NationalClassGroupYOW;
import org.ussamasters.aces.racedata.models.RaceClass;
import org.ussamasters.aces.racedata.models.RaceOrganization;
import org.ussamasters.aces.racedata.models.RaceSeriesResult;
import org.ussamasters.aces.racedata.models.StandardOrganizationType;
import org.ussamasters.aces.racedata.models.StandingsCategory;
import org.ussamasters.aces.racedata.models.StandingsOrganizationType;
import org.ussamasters.aces.racedata.reports.RaceDataReportServices;
import org.ussamasters.aces.racedata.reports.StandingsReportPolicy;

public abstract class StandingsReportPolicyRegistry
implements StandingsReportPolicy {
    private static final Map<Class<? extends StandingsCategory>, StandingsReportPolicy> reportPoliciesRegistry;
    protected StandingsOrganizationType organizationType;

    public StandingsReportPolicyRegistry(Class<? extends StandingsCategory> categoryClass) {
        this(StandardOrganizationType.forCategoryClass(categoryClass));
    }

    public StandingsReportPolicyRegistry(StandingsOrganizationType organizationType) {
        this.organizationType = organizationType;
    }

    public static StandingsReportPolicy getReportPolicy(Class<? extends StandingsCategory> categoryClass) {
        return StandingsReportPolicyRegistry.getReportPolicy(categoryClass, reportPoliciesRegistry);
    }

    protected static StandingsReportPolicy getReportPolicy(Class<? extends StandingsCategory> categoryClass, Map<Class<? extends StandingsCategory>, StandingsReportPolicy> categoryReportPolicies) {
        StandingsReportPolicy reportPolicy = categoryReportPolicies.get(categoryClass);
        if (reportPolicy == null) {
            throw new IllegalArgumentException("No results report policy for category " + categoryClass.getClass().getSimpleName());
        }
        return reportPolicy;
    }

    private Class<? extends StandingsCategory> categoryClass() {
        return this.organizationType.categoryClass();
    }

    @Override
    public String categoryDescription(StandingsCategory category) {
        return this.organizationType.categoryDescription(category);
    }

    @Override
    public List<? extends StandingsCategory> categories() {
        return this.organizationType.categories();
    }

    @Override
    public boolean hasMultipleCategories() {
        return this.organizationType.categories().size() > 1;
    }

    @Override
    public boolean includeAffiliationWithRacerName() {
        return RaceDataReportServices.getReportOptions().getIncludeRacerAffiliationInReports();
    }

    @Override
    public boolean includeRaceClassWithRacerName() {
        return !RaceClass.getAllRaceClasses().contains(this.categoryClass());
    }

    static {
        StandingsReportPolicyRegistry reportPolicy;
        Class<ConstantValueWithDescription> categoryClass;
        reportPoliciesRegistry = new HashMap<Class<? extends StandingsCategory>, StandingsReportPolicy>();
        Iterator<Class<ConstantValueWithDescription>> iterator = RaceClass.getAllRaceClasses().iterator();
        while (iterator.hasNext()) {
            Class<RaceClass<?>> clazz;
            categoryClass = clazz = iterator.next();
            reportPolicy = new StandingsReportPolicyRegistry(categoryClass){

                @Override
                public StandingsCategory getCategory(NamedRacerResult racerResult) {
                    return racerResult.getRaceClass();
                }
            };
            reportPoliciesRegistry.put(categoryClass, reportPolicy);
        }
        for (Class<ConstantValueWithDescription> clazz : NationalClassGroup.getAllNationalGroupClasses()) {
            reportPolicy = new StandingsReportPolicyRegistry(clazz){

                @Override
                public StandingsCategory getCategory(NamedRacerResult racerResult) {
                    return racerResult.getRaceClass().getGroup();
                }
            };
            reportPoliciesRegistry.put(clazz, reportPolicy);
        }
        for (Class<ConstantValueWithDescription> clazz : NationalClassGroupYOW.getAllNationalGroupClasses()) {
            reportPolicy = new StandingsReportPolicyRegistry(clazz){

                @Override
                public StandingsCategory getCategory(NamedRacerResult racerResult) {
                    return racerResult.getRaceClass().getGroup();
                }
            };
            reportPoliciesRegistry.put(clazz, reportPolicy);
        }
        for (Class<ConstantValueWithDescription> clazz : FISMastersGroup.getAllFISMastersGroupClasses()) {
            reportPolicy = new StandingsReportPolicyRegistry(clazz){

                @Override
                public StandingsCategory getCategory(NamedRacerResult racerResult) {
                    return racerResult.getRaceClass().getGroup();
                }
            };
            reportPoliciesRegistry.put(clazz, reportPolicy);
        }
        categoryClass = Gender.class;
        reportPolicy = new StandingsReportPolicyRegistry(categoryClass){

            @Override
            public StandingsCategory getCategory(NamedRacerResult racerResult) {
                return racerResult.getGender();
            }
        };
        reportPoliciesRegistry.put(categoryClass, reportPolicy);
        categoryClass = AllRacersCategory.class;
        reportPolicy = new StandingsReportPolicyRegistry(categoryClass){

            @Override
            public StandingsCategory getCategory(NamedRacerResult racerResult) {
                return AllRacersCategory.ALL_RACERS;
            }
        };
        reportPoliciesRegistry.put(categoryClass, reportPolicy);
        categoryClass = RaceOrganization.class;
        reportPolicy = new StandingsReportPolicyRegistry(categoryClass){

            @Override
            public StandingsCategory getCategory(NamedRacerResult racerResult) {
                return ((RaceSeriesResult)racerResult).getRacer().getAffiliation();
            }
        };
        reportPoliciesRegistry.put(categoryClass, reportPolicy);
    }
}

