/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.scoring;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ussamasters.aces.racedata.models.RaceClass;
import org.ussamasters.aces.racedata.models.RaceEntryResult;
import org.ussamasters.aces.racedata.models.RaceResult;
import org.ussamasters.aces.racedata.models.RacerResult;
import org.ussamasters.aces.racedata.models.ScoringResult;
import org.ussamasters.aces.racedata.models.StandingsCategory;
import org.ussamasters.aces.racedata.models.StandingsOrganizationType;
import org.ussamasters.aces.racedata.scoring.CategoryResultsList;
import org.ussamasters.aces.racedata.scoring.RacerResultOrganizingPolicy;

public abstract class BasicRacerResultOrganizer<RT extends ScoringResult, CET extends ScoringResult> {
    private RacerResultOrganizingPolicy<RT> organizingPolicy;
    private Map<StandingsCategory, CategoryResultsList<CET>> categoryResultsLists;

    public BasicRacerResultOrganizer(RacerResultOrganizingPolicy<RT> organizingPolicy) {
        if (organizingPolicy == null) {
            throw new IllegalArgumentException("Organizing policy not defined");
        }
        this.setOrganizingPolicy(organizingPolicy);
    }

    public Class<? extends StandingsCategory> categoryClass() {
        return this.organizingPolicy.categoryClass();
    }

    public List<? extends StandingsCategory> categoryValues() {
        return this.organizingPolicy.categories();
    }

    protected CategoryResultsList<CET> constructCategoryResultsList(StandingsCategory category) {
        return new CategoryResultsList(category);
    }

    protected Map<StandingsCategory, CategoryResultsList<CET>> constructCategoryResultsListsRegistry() {
        return new HashMap<StandingsCategory, CategoryResultsList<CET>>();
    }

    public Set<? extends StandingsCategory> getCategories() {
        return this.categoryResultsLists.keySet();
    }

    protected StandingsCategory getCategory(RaceEntryResult racerResult) {
        return this.organizingPolicy.getCategory(racerResult);
    }

    public CategoryResultsList<CET> getCategoryResults(StandingsCategory category) {
        return this.categoryResultsLists.get(category);
    }

    public StandingsOrganizationType getOrganizationType() {
        return this.organizingPolicy.getOrganizationType();
    }

    protected RacerResultOrganizingPolicy<RT> getOrganizingPolicy() {
        return this.organizingPolicy;
    }

    protected void finishResultsOrganizing() {
    }

    protected void initCategoryResultsListsRegistry() {
        this.categoryResultsLists = this.constructCategoryResultsListsRegistry();
    }

    public boolean isOrganizedByClass() {
        return RaceClass.getAllRaceClasses().contains(this.categoryClass());
    }

    public void organizeResults() {
        this.prepareToOrganizeResults();
        this.performResultsOrganization();
        this.finishResultsOrganizing();
        this.validateOrganization();
    }

    protected abstract void performResultsOrganization();

    protected void prepareToOrganizeResults() {
        this.initCategoryResultsListsRegistry();
    }

    protected void processRaceResult(RaceResult raceResult) {
        for (RacerResult racerResult : raceResult.getRacerResults()) {
            this.processRacerResult((RaceEntryResult)racerResult);
        }
    }

    protected abstract void processRacerResult(RaceEntryResult var1);

    protected void putCategoryResults(StandingsCategory category, CategoryResultsList<CET> categoryResultsList) {
        this.categoryResultsLists.put(category, categoryResultsList);
    }

    public void removeCategoryResults(StandingsCategory category) {
        this.categoryResultsLists.remove(category);
    }

    protected void setOrganizingPolicy(RacerResultOrganizingPolicy<RT> organizingPolicy) {
        this.organizingPolicy = organizingPolicy;
    }

    protected void storeResultEntry(StandingsCategory category, CET entry) {
        this.validateCategory(category);
        CategoryResultsList<CET> categoryResultsList = this.getCategoryResults(category);
        if (categoryResultsList == null) {
            categoryResultsList = this.constructCategoryResultsList(category);
            this.putCategoryResults(category, categoryResultsList);
        }
        categoryResultsList.add(entry);
    }

    protected void validateCategory(StandingsCategory category) {
        if (category == null || !category.getClass().equals(this.categoryClass())) {
            throw new IllegalArgumentException(String.format("Invalid results category: %s is not category class %s", category, this.categoryClass().getSimpleName()));
        }
    }

    protected void validateOrganization() {
        if (this.getCategories().size() > this.organizingPolicy.categories().size()) {
            throw new IllegalStateException("Too many categories used for this organization");
        }
    }
}

