/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.scoring;

import java.util.List;
import org.ussamasters.aces.racedata.models.DivisionsCupPoints;
import org.ussamasters.aces.racedata.models.DivisionsCupResult;
import org.ussamasters.aces.racedata.models.RaceClass;
import org.ussamasters.aces.racedata.models.RaceEntryResult;
import org.ussamasters.aces.racedata.models.RaceResult;
import org.ussamasters.aces.racedata.models.RaceSeries;
import org.ussamasters.aces.racedata.models.RaceStartResult;
import org.ussamasters.aces.racedata.models.RacerList;
import org.ussamasters.aces.racedata.models.RacerResult;
import org.ussamasters.aces.racedata.models.StandingsOrganizationType;
import org.ussamasters.aces.racedata.scoring.BasicRaceSeriesResultsOrganizer;
import org.ussamasters.aces.racedata.scoring.DivisionsCupSeriesResultsOrganizingPolicy;
import org.ussamasters.aces.racedata.scoring.RacerResultOrganizingPolicy;

public class DivisionsCupSeriesResultsOrganizer
extends BasicRaceSeriesResultsOrganizer {
    public static final StandingsOrganizationType ORGANIZATION_TYPE = DivisionsCupSeriesResultsOrganizingPolicy.ORGANIZATION_TYPE;
    protected int[] classSizes;
    protected List<DivisionsCupResult> divisionResults;

    public static DivisionsCupSeriesResultsOrganizer forRaceSeries(RaceSeries raceSeries, RacerList registeredRacers) {
        return new DivisionsCupSeriesResultsOrganizer(raceSeries, registeredRacers);
    }

    public static DivisionsCupSeriesResultsOrganizer forRaceSeries(RaceSeries raceSeries, RacerList registeredRacers, StandingsOrganizationType organizationType) {
        if (!organizationType.categoryClass().equals(ORGANIZATION_TYPE.categoryClass())) {
            throw new IllegalArgumentException("Unsupported organization type: " + organizationType);
        }
        return DivisionsCupSeriesResultsOrganizer.forRaceSeries(raceSeries, registeredRacers);
    }

    public static RacerResultOrganizingPolicy<?> getOrganizingPolicy(StandingsOrganizationType organizationType) {
        throw new UnsupportedOperationException("Inappropriate operation for Division Cup organizer (needs racer list arg)");
    }

    public DivisionsCupSeriesResultsOrganizer(RaceSeries raceSeries, RacerList registeredRacers) {
        super(raceSeries, registeredRacers, new DivisionsCupSeriesResultsOrganizingPolicy(registeredRacers));
    }

    protected void clearClassSizes() {
        for (int i = 0; i < this.classSizes.length; ++i) {
            this.classSizes[i] = 0;
        }
    }

    protected void computeClassSizes(RaceResult raceResult) {
        this.clearClassSizes();
        for (RacerResult rr : raceResult.getRacerResults()) {
            RaceEntryResult racerResult = (RaceEntryResult)rr;
            if (!racerResult.isStarter()) continue;
            int n = racerResult.getRaceClass().ord;
            this.classSizes[n] = this.classSizes[n] + 1;
        }
    }

    protected DivisionsCupPoints computeDivisionsCupPoints(RaceEntryResult racerResult) {
        if (!racerResult.isFinisher()) {
            return DivisionsCupPoints.ZERO;
        }
        int classSize = this.classSizes[racerResult.getRaceClass().ord];
        return DivisionsCupPoints.forPosition(racerResult.getPosition(), classSize);
    }

    public List<DivisionsCupResult> getDivisionResults() {
        return this.divisionResults;
    }

    @Override
    protected RaceStartResult getResultForStandings(RaceEntryResult racerResult) {
        RaceStartResult seriesStartResult = super.getResultForStandings(racerResult);
        seriesStartResult.setDivisionsCupPoints(this.computeDivisionsCupPoints(racerResult));
        return seriesStartResult;
    }

    protected void initClassSizes() {
        int nRaceClasses = RaceClass.getRaceClassValues(this.getRaceSeries().getRaceClassClass()).size();
        this.classSizes = new int[nRaceClasses];
    }

    @Override
    protected RaceResult prepareRaceResultForProcessing(RaceResult raceResult) {
        this.computeClassSizes(raceResult);
        return raceResult;
    }

    @Override
    protected void prepareToOrganizeResults() {
        super.prepareToOrganizeResults();
        this.initClassSizes();
    }

    public void setDivisionResults(List<DivisionsCupResult> divisionResults) {
        this.divisionResults = divisionResults;
    }
}

