/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.scoring;

import java.util.List;
import org.ussamasters.aces.racedata.models.RaceResult;
import org.ussamasters.aces.racedata.models.RaceSeries;
import org.ussamasters.aces.racedata.models.RacerList;
import org.ussamasters.aces.racedata.models.StandardOrganizationType;
import org.ussamasters.aces.racedata.models.StandingsOrganizationType;
import org.ussamasters.aces.racedata.scoring.BasicRaceSeriesResultsOrganizer;
import org.ussamasters.aces.racedata.scoring.MedalCountsResult;
import org.ussamasters.aces.racedata.scoring.MedalCountsSeriesResultsOrganizingPolicy;
import org.ussamasters.aces.racedata.scoring.RacerResultOrganizingPolicy;

public class MedalCountsResultsOrganizer
extends BasicRaceSeriesResultsOrganizer {
    public static final StandingsOrganizationType ORGANIZATION_TYPE = StandardOrganizationType.BY_AFFILIATION;
    protected List<MedalCountsResult> teamResults;

    public static MedalCountsResultsOrganizer forRaceSeries(RaceSeries raceSeries, RacerList registeredRacers) {
        return new MedalCountsResultsOrganizer(raceSeries, registeredRacers);
    }

    public static MedalCountsResultsOrganizer forRaceSeries(RaceSeries raceSeries, RacerList registeredRacers, StandingsOrganizationType organizationType) {
        if (!organizationType.categoryClass().equals(ORGANIZATION_TYPE.categoryClass())) {
            throw new IllegalArgumentException("Unsupported organization type: " + organizationType);
        }
        return MedalCountsResultsOrganizer.forRaceSeries(raceSeries, registeredRacers);
    }

    public static RacerResultOrganizingPolicy<?> getOrganizingPolicy(StandingsOrganizationType organizationType) {
        throw new UnsupportedOperationException("Inappropriate operation for Event Summary organizer (needs racer list arg)");
    }

    public MedalCountsResultsOrganizer(RaceSeries raceSeries, RacerList registeredRacers) {
        super(raceSeries, registeredRacers, new MedalCountsSeriesResultsOrganizingPolicy(registeredRacers));
    }

    @Override
    protected void finishResultsOrganizing() {
        super.finishResultsOrganizing();
    }

    public List<MedalCountsResult> getTeamResults() {
        return this.teamResults;
    }

    @Override
    protected RaceResult prepareRaceResultForProcessing(RaceResult raceResult) {
        return raceResult;
    }

    public void setTeamResults(List<MedalCountsResult> teamResults) {
        this.teamResults = teamResults;
    }
}

