/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.scoring;

import java.util.List;
import org.ussamasters.aces.racedata.models.ScoringResult;
import org.ussamasters.aces.racedata.models.StandardOrganizationType;
import org.ussamasters.aces.racedata.models.StandingsCategory;
import org.ussamasters.aces.racedata.models.StandingsCategoryType;
import org.ussamasters.aces.racedata.models.StandingsOrganizationType;
import org.ussamasters.aces.racedata.scoring.RacerResultOrganizingPolicy;

public abstract class RacerResultOrganizingPolicyAdaptor<RT extends ScoringResult>
implements RacerResultOrganizingPolicy<RT> {
    protected final StandingsOrganizationType organizationType;

    public RacerResultOrganizingPolicyAdaptor(Class<? extends StandingsCategory> categoryClass) {
        this(StandardOrganizationType.forCategoryClass(categoryClass));
    }

    public RacerResultOrganizingPolicyAdaptor(StandingsOrganizationType organizationType) {
        this.organizationType = organizationType;
    }

    @Override
    public Class<? extends StandingsCategory> categoryClass() {
        return this.organizationType.categoryClass();
    }

    @Override
    public StandingsCategoryType categoryType() {
        return this.organizationType.categoryType();
    }

    @Override
    public List<? extends StandingsCategory> categories() {
        return this.organizationType.categories();
    }

    @Override
    public StandingsOrganizationType getOrganizationType() {
        return this.organizationType;
    }

    @Override
    public boolean mayHaveMultiCategoryRacers() {
        return false;
    }

    public String toString() {
        return String.format("%s<%s, %s>", this.getClass().getSimpleName(), this.organizationType.description(), this.organizationType.categoryType().name());
    }
}

