/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.scoring;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ussamasters.aces.racedata.models.RaceSeriesResult;
import org.ussamasters.aces.racedata.models.RaceStartResult;
import org.ussamasters.aces.racedata.models.RacerResult;
import org.ussamasters.aces.racedata.models.ScoringElement;
import org.ussamasters.aces.racedata.models.ScoringValue;
import org.ussamasters.aces.racedata.models.SiseCupPoints;

public abstract class ScoringElementAccessor {
    public static final ScoringElementAccessor TIME_ACCESSOR;
    public static final ScoringElementAccessor POINTS_ACCESSOR;
    public static final ScoringElementAccessor RACE_POINTS_ACCESSOR;
    public static final ScoringElementAccessor DIVISIONS_CUP_POINTS_ACCESSOR;
    public static final ScoringElementAccessor SISE_CUP_POINTS_ACCESSOR;
    private static Map<ScoringElement, ScoringElementAccessor> elementAccessorMap;
    private ScoringElement scoringElement;
    private Comparator<RacerResult> elementSorter;

    public static ScoringElementAccessor forScoringElement(ScoringElement scoringElement) {
        if (scoringElement == ScoringElement.ADJUSTED_TIME) {
            return ScoringElementAccessor.forScoringElement(ScoringElement.TIME);
        }
        return elementAccessorMap.get(scoringElement);
    }

    protected static void registerAccessor(ScoringElement scoringElement, ScoringElementAccessor anAccessor) {
        elementAccessorMap.put(scoringElement, anAccessor);
    }

    protected ScoringElementAccessor(ScoringElement scoringElement, Comparator<RacerResult> elementSorter) {
        this.scoringElement = scoringElement;
        this.elementSorter = elementSorter;
    }

    public Comparator<RacerResult> getElementSorter() {
        return this.elementSorter;
    }

    public ScoringElement getScoringElement() {
        return this.scoringElement;
    }

    public abstract ScoringValue<?> getValue(RacerResult var1);

    public void sortResults(List<? extends RacerResult> resultsList) {
        Collections.sort(resultsList, this.getElementSorter());
    }

    static {
        elementAccessorMap = new HashMap<ScoringElement, ScoringElementAccessor>();
        ScoringElement scoringElement = ScoringElement.TIME;
        Comparator<RacerResult> elementSorter = new Comparator<RacerResult>(){

            @Override
            public int compare(RacerResult result1, RacerResult result2) {
                return result1.compareByTime(result2);
            }
        };
        ScoringElementAccessor anAccessor = new ScoringElementAccessor(scoringElement, (Comparator)elementSorter){

            @Override
            public ScoringValue<?> getValue(RacerResult racerResult) {
                return racerResult.isFinisher() ? racerResult.getTime() : null;
            }
        };
        ScoringElementAccessor.registerAccessor(scoringElement, anAccessor);
        TIME_ACCESSOR = anAccessor;
        scoringElement = ScoringElement.POINTS;
        elementSorter = new Comparator<RacerResult>(){

            @Override
            public int compare(RacerResult result1, RacerResult result2) {
                return result1.compareByPoints(result2);
            }
        };
        anAccessor = new ScoringElementAccessor(scoringElement, (Comparator)elementSorter){

            @Override
            public ScoringValue<?> getValue(RacerResult racerResult) {
                return racerResult.getPoints();
            }
        };
        ScoringElementAccessor.registerAccessor(scoringElement, anAccessor);
        POINTS_ACCESSOR = anAccessor;
        scoringElement = ScoringElement.RACE_POINTS;
        elementSorter = new Comparator<RacerResult>(){

            @Override
            public int compare(RacerResult result1, RacerResult result2) {
                return result1.compareByRacePoints(result2);
            }
        };
        anAccessor = new ScoringElementAccessor(scoringElement, (Comparator)elementSorter){

            @Override
            public ScoringValue<?> getValue(RacerResult racerResult) {
                return racerResult.getRacePoints();
            }
        };
        ScoringElementAccessor.registerAccessor(scoringElement, anAccessor);
        RACE_POINTS_ACCESSOR = anAccessor;
        scoringElement = ScoringElement.DIVISIONS_CUP_POINTS;
        elementSorter = new Comparator<RacerResult>(){

            @Override
            public int compare(RacerResult result1, RacerResult result2) {
                return ((RaceSeriesResult)result1).compareByDivisionsCupPoints((RaceSeriesResult)result2);
            }
        };
        anAccessor = new ScoringElementAccessor(scoringElement, (Comparator)elementSorter){

            @Override
            public ScoringValue<?> getValue(RacerResult racerResult) {
                return ((RaceSeriesResult)racerResult).getDivisionsCupPoints();
            }
        };
        ScoringElementAccessor.registerAccessor(scoringElement, anAccessor);
        DIVISIONS_CUP_POINTS_ACCESSOR = anAccessor;
        scoringElement = ScoringElement.SISE_CUP_POINTS;
        elementSorter = new Comparator<RacerResult>(){

            @Override
            public int compare(RacerResult result1, RacerResult result2) {
                if (result1 instanceof RaceStartResult) {
                    return this.compare((RaceStartResult)result1, (RaceStartResult)result2);
                }
                return ((RaceSeriesResult)result1).compareBySiseCupPoints((RaceSeriesResult)result2);
            }

            @Override
            private int compare(RaceStartResult result1, RaceStartResult result2) {
                SiseCupPoints scp1 = result1.isFinisher() ? SiseCupPoints.forPosition(result1.getPosition()) : SiseCupPoints.ZERO;
                SiseCupPoints scp2 = result2.isFinisher() ? SiseCupPoints.forPosition(result2.getPosition()) : SiseCupPoints.ZERO;
                return scp1.compareTo(scp2);
            }
        };
        anAccessor = new ScoringElementAccessor(scoringElement, (Comparator)elementSorter){

            @Override
            public ScoringValue<?> getValue(RacerResult racerResult) {
                return ((RaceSeriesResult)racerResult).getSiseCupPoints();
            }
        };
        ScoringElementAccessor.registerAccessor(scoringElement, anAccessor);
        SISE_CUP_POINTS_ACCESSOR = anAccessor;
    }
}

