/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.scoring;

import org.ussamasters.aces.racedata.models.AllRacersCategory;
import org.ussamasters.aces.racedata.models.RaceResult;
import org.ussamasters.aces.racedata.models.RaceType;
import org.ussamasters.aces.racedata.models.StandingsCategory;
import org.ussamasters.aces.racedata.models.StandingsSummaryData;
import org.ussamasters.aces.racedata.scoring.SeriesSummaryStatistics;

public class SeasonSummaryStatistics
extends SeriesSummaryStatistics {
    public static final Object TYPE_RACE_STARTS = new Object();
    protected static final StandingsCategory[] CATEGORIES_ALL_AND_DISCIPLINES = new StandingsCategory[]{AllRacersCategory.ALL_RACERS, RaceType.SL, RaceType.GS, RaceType.SG, RaceType.DH, RaceType.SC};
    protected static final int INDEX_FIRST_DISCIPLINE = 1;
    private StandingsSummaryData[] raceStartsStatistics;

    @Override
    public void clear() {
        super.clear();
        this.raceStartsStatistics = this.constructStatistics(TYPE_RACE_STARTS, CATEGORIES_ALL_AND_DISCIPLINES);
    }

    @Override
    public Object clone() {
        SeasonSummaryStatistics copy = (SeasonSummaryStatistics)super.clone();
        copy.raceStartsStatistics = this.copyStatistics(this.raceStartsStatistics);
        return copy;
    }

    @Override
    protected void collectStatistics(RaceResult raceResult) {
        super.collectStatistics(raceResult);
        RaceType raceType = raceResult.getType().basicType;
        int nCompetitors = raceResult.getNumberOfCompetitors();
        this.raceStartsStatistics[0].incrementNumberOfDataSources();
        this.raceStartsStatistics[0].incrementTotal(nCompetitors);
        this.raceStartsStatistics[1 + raceType.ord].incrementNumberOfDataSources();
        this.raceStartsStatistics[1 + raceType.ord].incrementTotal(nCompetitors);
    }

    @Override
    protected void finishComputingStatistics() {
        super.finishComputingStatistics();
        if (this.getCompetitorStartsStatistics()[0].getTotal() != this.raceStartsStatistics[0].getTotal()) {
            throw new IllegalStateException("COUNTING BUG");
        }
    }

    public int getAverageNumberOfStartsPerRace() {
        return this.raceStartsStatistics[0].getAverage();
    }

    public int getAverageNumberOfStarts(RaceType raceType) {
        return this.raceStartsStatistics[1 + raceType.ord].getAverage();
    }

    public int getNumberOfRaces(RaceType raceType) {
        return this.raceStartsStatistics[1 + raceType.ord].getNumberOfDataSources();
    }

    public int getNumberOfStarts(RaceType raceType) {
        return this.raceStartsStatistics[1 + raceType.ord].getTotal();
    }

    @Override
    public StandingsSummaryData[] getRaceStartsStatistics() {
        return this.raceStartsStatistics;
    }

    @Override
    protected void prepareToComputeStatistics() {
        super.prepareToComputeStatistics();
        this.clearTotals(this.raceStartsStatistics);
        this.clearNumberOfDataSources(this.raceStartsStatistics);
    }
}

