/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.scoring;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ussamasters.aces.racedata.models.Gender;
import org.ussamasters.aces.racedata.models.RaceClass;
import org.ussamasters.aces.racedata.models.RaceClassRegistry;
import org.ussamasters.aces.racedata.models.RaceClassType;
import org.ussamasters.aces.racedata.models.RaceSeries;
import org.ussamasters.aces.racedata.models.RaceSeriesResult;
import org.ussamasters.aces.racedata.models.RaceStartResult;
import org.ussamasters.aces.racedata.models.RaceTime;
import org.ussamasters.aces.racedata.models.RaceType;
import org.ussamasters.aces.racedata.models.Racer;
import org.ussamasters.aces.racedata.models.ScoringElement;
import org.ussamasters.aces.racedata.models.SeasonIdentifier;
import org.ussamasters.aces.racedata.models.StandingsCategory;
import org.ussamasters.aces.racedata.scoring.BasicRaceSeriesResultsOrganizer;
import org.ussamasters.aces.racedata.scoring.MustFinishAllRacesScoringPolicy;
import org.ussamasters.aces.racedata.scoring.SeriesStandingsScoringPolicy;

public class SportAgeScoringPolicy
extends MustFinishAllRacesScoringPolicy {
    private static final Map<RaceType, Float[]> SPORTAGE_FACTOR_MAP = Collections.unmodifiableMap(new HashMap<RaceType, Float[]>(){
        {
            this.put(RaceType.SL, new Float[]{new Float("0.006414"), new Float("0.005251")});
            this.put(RaceType.GS, new Float[]{new Float("0.004108"), new Float("0.004465")});
            this.put(RaceType.SG, new Float[]{new Float("0.005476"), new Float("0.00406")});
            this.put(RaceType.DH, new Float[]{new Float("0.005476"), new Float("0.00406")});
        }
    });
    private static final int SPORTAGE_FACTOR_INDEX_WOMEN = 0;
    private static final int SPORTAGE_FACTOR_INDEX_MEN = 1;
    public static final RaceTime NONFINISHER_TIME = RaceTime.fromString("999.99");
    private SeasonIdentifier season;

    public static SeriesStandingsScoringPolicy forElement(ScoringElement scoringElement) {
        if (scoringElement != ScoringElement.ADJUSTED_TIME) {
            throw new IllegalArgumentException("SportAge is scored by handicap-adjusted finish time");
        }
        return new SportAgeScoringPolicy();
    }

    public SportAgeScoringPolicy() {
        super(ScoringElement.ADJUSTED_TIME);
    }

    protected RaceTime computeAdjustedTime(RaceTime actualTime, RaceType discipline, Gender gender, int age) {
        if (age < 30 || age > 100) {
            return actualTime;
        }
        Float[] factors = SPORTAGE_FACTOR_MAP.get(discipline);
        float sportageFactor = (gender == Gender.WOMEN ? factors[0] : factors[1]).floatValue();
        float sportageTime = actualTime.floatValue() * (1.0f - (float)(age - 30) * sportageFactor);
        return RaceTime.fromFloat(sportageTime);
    }

    protected RaceTime computeAdjustedTotalTime(RaceSeriesResult seriesResult, List<RaceStartResult> starts) {
        Racer racer = seriesResult.getRacer();
        if (!racer.isBirthYearKnown()) {
            throw new RuntimeException("OOPS: no DOB for racer " + racer.getName());
        }
        Gender gender = racer.getGender();
        int age = racer.computeAge(this.season);
        RaceSeries raceSeries = this.getResultsData().getRaceSeries();
        int nRaces = raceSeries.size();
        RaceTime adjustedTotalTime = RaceTime.ZERO;
        for (int i = 0; i < nRaces; ++i) {
            RaceType discipline = raceSeries.getRace(i).getType();
            RaceTime actualTime = seriesResult.getStartResult(i).getTime();
            RaceTime adjustedTime = this.computeAdjustedTime(actualTime, discipline, gender, age);
            adjustedTotalTime = adjustedTotalTime.add(adjustedTime);
        }
        return adjustedTotalTime;
    }

    @Override
    protected void computeSeriesTotals(StandingsCategory category, RaceSeriesResult seriesResult, List<RaceStartResult> starts) {
        super.computeSeriesTotals(category, seriesResult, starts);
        if (seriesResult.isFinisher()) {
            seriesResult.setAdjustedTime(this.computeAdjustedTotalTime(seriesResult, starts));
            seriesResult.clearPoints();
        }
    }

    protected RaceClass<?> getRacerAgeClass(RaceSeriesResult seriesResult) {
        return RaceClassRegistry.current().getRaceClassType(this.getSeriesRaceClass()) == RaceClassType.us_masters ? seriesResult.getRacer().getNationalClass() : seriesResult.getRacer().getAgeClass();
    }

    @Override
    protected String getScoringElementDescription(ScoringElement aScoringElement) {
        return "age-adjusted total time (SportAge handicapping for 30+)";
    }

    @Override
    public String name() {
        return "SportAge";
    }

    @Override
    protected void setResultsData(BasicRaceSeriesResultsOrganizer seriesResultsData) {
        super.setResultsData(seriesResultsData);
        this.season = seriesResultsData.getRaceSeries().getSeason();
    }
}

