/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.scoring;

import java.util.ArrayList;
import java.util.List;
import org.ussamasters.aces.racedata.models.Gender;
import org.ussamasters.aces.racedata.models.NationalClassGroup;
import org.ussamasters.aces.racedata.models.RaceDescriptor;
import org.ussamasters.aces.racedata.models.RaceEntryResult;
import org.ussamasters.aces.racedata.models.RacePoints;
import org.ussamasters.aces.racedata.models.RaceResult;
import org.ussamasters.aces.racedata.models.RaceTime;
import org.ussamasters.aces.racedata.models.RaceType;
import org.ussamasters.aces.racedata.models.RacerResult;
import org.ussamasters.aces.racedata.models.ScoringElement;
import org.ussamasters.aces.racedata.models.ScoringResult;
import org.ussamasters.aces.racedata.models.StandingsCategory;
import org.ussamasters.aces.racedata.models.WorldCupPoints;
import org.ussamasters.aces.racedata.models.WorldCupPointsFactory;
import org.ussamasters.aces.racedata.scoring.BasicScoringPolicy;
import org.ussamasters.aces.racedata.scoring.CategoryResultsList;
import org.ussamasters.aces.racedata.scoring.RacePointsCalculator;
import org.ussamasters.aces.racedata.scoring.RaceResultOrganizer;
import org.ussamasters.aces.racedata.scoring.RaceStandings;
import org.ussamasters.aces.racedata.scoring.RaceStandingsScoringPolicy;
import org.ussamasters.aces.racedata.scoring.ScoringPolicySpecification;

public class StandardRaceScoringPolicy
extends BasicScoringPolicy
implements RaceStandingsScoringPolicy {
    private RaceResultOrganizer resultsData;
    private RaceType raceType;
    private int fValue;
    private WorldCupPointsFactory pointsFactory;
    private RacePointsCalculator rpc;

    public static StandardRaceScoringPolicy forRaceResult(RaceResult aRaceResult) {
        StandardRaceScoringPolicy scoringPolicy = new StandardRaceScoringPolicy();
        scoringPolicy.initRaceValues(aRaceResult);
        return scoringPolicy;
    }

    public static StandardRaceScoringPolicy forRace(RaceDescriptor raceSpec) {
        StandardRaceScoringPolicy scoringPolicy = new StandardRaceScoringPolicy();
        scoringPolicy.initRaceValues(raceSpec);
        return scoringPolicy;
    }

    protected StandardRaceScoringPolicy() {
        super(ScoringElement.TIME);
    }

    protected void assignFinishPosition(RacerResult racerResult, int position) {
        super.assignFinishPosition(racerResult, position);
        RaceTime finishTime = racerResult.getTime();
        if (this.rpc == null) {
            this.rpc = this.constructRacePointsCalculator(finishTime);
        }
        racerResult.setPoints(this.pointsFactory.forPosition(position));
        racerResult.setRacePoints(this.rpc.computeRacePoints(finishTime));
    }

    @Override
    protected void assignFinishPosition(ScoringResult aResult, int position) {
        this.assignFinishPosition((RacerResult)aResult, position);
    }

    protected void assignTie(RacerResult racerResult, RacerResult previousResult) {
        super.assignTie(racerResult, previousResult);
        racerResult.setPoints(previousResult.getPoints());
        racerResult.setRacePoints(previousResult.getRacePoints());
    }

    @Override
    protected void assignTie(ScoringResult aResult, ScoringResult previousResult) {
        this.assignTie((RacerResult)aResult, (RacerResult)previousResult);
    }

    @Override
    protected void clearFinishPosition(RacerResult racerResult) {
        racerResult.clearFinishStatistics();
    }

    protected void computeFinishStatistics() {
        for (StandingsCategory category : this.resultsData.getCategories()) {
            CategoryResultsList<RaceEntryResult> categoryResultsList = this.resultsData.getCategoryResults(category);
            if (categoryResultsList == null) continue;
            this.computeFinishStatistics(category, categoryResultsList);
        }
    }

    protected void computeFinishStatistics(List<RaceEntryResult> categoryResultsList) {
        this.rpc = null;
        this.assignFinishPositions(categoryResultsList);
        this.rpc = null;
    }

    protected void computeFinishStatistics(StandingsCategory category, List<RaceEntryResult> categoryResultsList) {
        this.sortResults(categoryResultsList);
        if (category == Gender.MEN && RaceStandings.isNationalsCourseSplitWithSeparateGroupDMensCourse(this.resultsData.getRaceResult())) {
            this.computeFinishStatisticsForMenWithSpecialGroupDHandling(categoryResultsList);
            return;
        }
        this.computeFinishStatistics(categoryResultsList);
    }

    protected void computeFinishStatisticsForMenWithSpecialGroupDHandling(List<RaceEntryResult> categoryResultsList) {
        ArrayList<RaceEntryResult> groupABMen = new ArrayList<RaceEntryResult>();
        ArrayList<RaceEntryResult> groupDMen = new ArrayList<RaceEntryResult>();
        for (RaceEntryResult racerResult : categoryResultsList) {
            NationalClassGroup group = (NationalClassGroup)racerResult.getRaceClass().getGroup();
            if (group.isGroupD()) {
                groupDMen.add(racerResult);
                continue;
            }
            groupABMen.add(racerResult);
        }
        this.computeFinishStatistics(groupABMen);
        this.computeFinishStatistics(groupDMen);
        for (RaceEntryResult racerResult : groupDMen) {
            if (!racerResult.isFinisher()) continue;
            racerResult.setPosition(0 - racerResult.getPosition());
            racerResult.setPoints(this.pointsFactory.zero());
            racerResult.setRacePoints(RacePoints.ZERO);
        }
    }

    public void computeRacePoints(List<RaceEntryResult> categoryResultsList) {
        this.rpc = null;
        for (RaceEntryResult racerResult : categoryResultsList) {
            if (racerResult.isFinisher()) {
                RaceTime finishTime = racerResult.getTime();
                if (this.rpc == null) {
                    this.rpc = this.constructRacePointsCalculator(finishTime);
                }
                racerResult.setRacePoints(this.rpc.computeRacePoints(finishTime));
                continue;
            }
            racerResult.setRacePoints(null);
        }
        this.rpc = null;
    }

    @Override
    public void computeStandings(RaceResultOrganizer raceResultsData) {
        this.resultsData = raceResultsData;
        this.initRaceValues(this.resultsData.getRaceResult());
        this.computeFinishStatistics();
        this.resultsData.setFValue(this.fValue);
    }

    protected RacePointsCalculator constructRacePointsCalculator(RaceTime winningTime) {
        return new RacePointsCalculator(this.raceType, this.fValue, winningTime);
    }

    @Override
    public void configureOptions(ScoringPolicySpecification policySpec) {
    }

    @Override
    public String description() {
        return "total time";
    }

    public int getFValue() {
        return this.fValue;
    }

    protected void initRaceValues(RaceDescriptor aRace) {
        this.raceType = aRace.getType();
        this.fValue = RacePoints.getFFactor(this.raceType, aRace.getSeason());
        this.pointsFactory = WorldCupPoints.getFactory(aRace.getWorldCupPointsType());
    }

    @Override
    protected boolean isQualifiedForFinishPosition(RacerResult racerResult) {
        return racerResult.isFinisher();
    }

    @Override
    public String name() {
        return "Standard";
    }

    public String toString() {
        return String.format("%s<%s, %s F=%s, %s>", this.getClass().getSimpleName(), this.getScoringElement().name(), this.raceType, this.fValue, this.pointsFactory.scoringType().formulaId);
    }
}

