/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.tools.foundation.models;

import java.util.List;
import org.ussamasters.aces.racedata.models.PolicyID;
import org.ussamasters.aces.racedata.models.PolicyRegistry;
import org.ussamasters.aces.racedata.models.RaceOrganization;
import org.ussamasters.aces.racedata.models.Racer;
import org.ussamasters.aces.racedata.models.RacerList;
import org.ussamasters.aces.racedata.models.USSALicense;
import org.ussamasters.aces.tools.foundation.models.RacerListManagementPolicySpecification;
import org.ussamasters.aces.tools.foundation.models.SeriesRacerListManagementPolicy;
import org.ussamasters.aces.tools.foundation.processors.ValidationResolver;
import org.ussamasters.aces.tools.foundation.processors.ValidationResult;

public abstract class RacerListManagementPolicy {
    public static final String POLICY_CATEGORY = "RacerListManagement";
    public static final String POLICY_NAME_SUFFIX = "RacerListManagementPolicy";
    public static final String PROPERTY_BIB_NUMBER = "bibNumber";
    public static final String PROPERTY_USSA_NUMBER = "ussaNumber";
    protected static final int NULL_BIB_NUMBER = -1;
    protected static PolicyRegistry<RacerListManagementPolicySpecification> specRegistry = new PolicyRegistry();
    private PolicyID policyID;
    private RacerList racerList;
    protected int nextAvailableBibNumber;

    protected RacerListManagementPolicy(PolicyID policyID) {
        this.policyID = policyID;
        this.setRacerList(null);
    }

    protected RacerListManagementPolicy(RacerListManagementPolicySpecification policySpec) {
        this(policySpec.policyID);
        this.configureOptions(policySpec);
    }

    public static PolicyID getDefaultPolicy(RaceOrganization organizer) {
        return SeriesRacerListManagementPolicy.POLICY_ID;
    }

    public static RacerListManagementPolicySpecification getDefaultPolicySpec(PolicyID policyID) {
        return specRegistry.get(policyID);
    }

    public static List<PolicyID> getRegisteredPolicies() {
        return specRegistry.getPolicyIDs();
    }

    protected static void registerDefaultSpec(RacerListManagementPolicySpecification policySpec) {
        specRegistry.registerPolicy(policySpec.policyID, policySpec);
    }

    public int allocateBibNumber() {
        int newNumber = this.getNextAvailableBibNumber();
        this.incrementNextAvailableBibNumber();
        return newNumber;
    }

    protected void bibNumberAdded(int bibNumber) {
        if (bibNumber == this.getNextAvailableBibNumber()) {
            this.incrementNextAvailableBibNumber();
        } else if (bibNumber > this.getNextAvailableBibNumber()) {
            this.nextAvailableBibNumber = bibNumber + 1;
        }
    }

    protected void bibNumberRemoved(int bibNumber) {
        if (bibNumber == this.getNextAvailableBibNumber() - 1) {
            this.decrementNextAvailableBibNumber();
        }
    }

    protected int computeNextAvailableBibNumber() {
        int maxBibNumberInUse = 0;
        for (Racer aRacer : this.getRacerList().getRacers()) {
            if (!aRacer.hasBibNumber()) continue;
            maxBibNumberInUse = Math.max(aRacer.getBibNumber(), maxBibNumberInUse);
        }
        return maxBibNumberInUse + 1;
    }

    public void configureOptions(RacerListManagementPolicySpecification policySpec) {
    }

    public abstract RacerListManagementPolicy copy();

    protected void decrementNextAvailableBibNumber() {
        --this.nextAvailableBibNumber;
    }

    public int getNextAvailableBibNumber() {
        if (this.nextAvailableBibNumber == -1) {
            this.nextAvailableBibNumber = this.computeNextAvailableBibNumber();
        }
        return this.nextAvailableBibNumber;
    }

    public PolicyID getPolicyID() {
        return this.policyID;
    }

    public RacerList getRacerList() {
        return this.racerList;
    }

    protected void incrementNextAvailableBibNumber() {
        ++this.nextAvailableBibNumber;
    }

    public boolean isBibNumberRequired() {
        return true;
    }

    public boolean isLicenseRequired() {
        return false;
    }

    public abstract boolean isRaceTempBibNumber(int var1);

    public void racerAdded(Racer aRacer) {
        this.bibNumberAdded(aRacer.getBibNumber());
    }

    public void racerChanged(Racer aRacer) {
        this.bibNumberAdded(aRacer.getBibNumber());
    }

    public void racerRemoved(Racer aRacer) {
        this.bibNumberRemoved(aRacer.getBibNumber());
    }

    public void setRacerList(RacerList racerList) {
        if (this.racerList != null) {
            throw new IllegalStateException("Management policy already installed on a racer list");
        }
        this.racerList = racerList;
        this.nextAvailableBibNumber = -1;
    }

    public abstract void validateBibNumber(int var1, RaceOrganization var2, String var3, ValidationResolver var4, ValidationResult var5);

    public void validateBibNumber(int bibNumber, String racerName, ValidationResolver validationResolver, ValidationResult validationResult) {
        String propertyName = PROPERTY_BIB_NUMBER;
        if (bibNumber < 1) {
            validationResult.reportProblem(propertyName, "You must specify a positve integer value for the bib number.");
            return;
        }
        if (this.isRaceTempBibNumber(bibNumber)) {
            validationResult.reportProblem(propertyName, "Bib number " + bibNumber + " is reserved for use as a temporary bib number for a specific race.");
            return;
        }
        Racer registeredRacer = this.getRacerList().findBib(bibNumber);
        if (registeredRacer != null) {
            validationResult.reportProblem(propertyName, "Bib number " + bibNumber + " is already assigned to " + registeredRacer.getFirstName() + " " + registeredRacer.getLastName() + " (" + registeredRacer.getAgeClass().name + ").");
            return;
        }
        this.verifyBibNumberSequencing(bibNumber, racerName, validationResolver, validationResult);
        if (validationResult.failed()) {
            return;
        }
    }

    public void validateUSSANumber(String ussaNumber, String racerName, ValidationResolver validationResolver, ValidationResult validationResult) {
        String propertyName = PROPERTY_USSA_NUMBER;
        if (!USSALicense.isValid(ussaNumber)) {
            if (this.isLicenseRequired()) {
                validationResult.reportProblem(propertyName, "You must specify a value for the USSA license number.");
                return;
            }
            return;
        }
        if (!USSALicense.isValid(ussaNumber)) {
            validationResult.reportProblem(propertyName, "The USSA number is not recognized as a valid license number.  The racer's license number should be a USSA division letter followed by 7-digit license number or X followed by 6-digit FIS license number of a foreign competitor).");
            return;
        }
        Racer registeredRacer = this.getRacerList().findUSSANumber(ussaNumber);
        if (registeredRacer != null) {
            validationResult.reportProblem(propertyName, "USSA Number " + ussaNumber + " is already assigned to " + registeredRacer.getFirstName() + " " + registeredRacer.getLastName() + " (" + registeredRacer.getAgeClass().name + ").");
            return;
        }
    }

    protected void verifyBibNumberSequencing(int bibNumber, String racerName, ValidationResolver validationResolver, ValidationResult validationResult) {
        String confirmationMessage;
        if (bibNumber > this.getNextAvailableBibNumber() && validationResolver.confirmMinorIssues() && !validationResolver.confirm(PROPERTY_BIB_NUMBER, confirmationMessage = "The next available bib number that would ordinarily be assigned is " + this.getNextAvailableBibNumber() + ".\n\nDo you really want to register " + racerName + " under bib number " + bibNumber + "?")) {
            validationResult.reportProblem(PROPERTY_BIB_NUMBER, "The next available bib number that should be assigned in " + this.getNextAvailableBibNumber());
            return;
        }
    }
}

