/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.tools.foundation.processors;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ussamasters.aces.racedata.io.CSVSpecDataReader;
import org.ussamasters.aces.racedata.io.RaceDataIOConstants;
import org.ussamasters.aces.racedata.models.RaceClass;
import org.ussamasters.aces.racedata.models.Racer;
import org.ussamasters.aces.racedata.models.RacerList;

public class RacerNameChecker {
    public static final String LAST_NAME_VARIATIONS_FILE_NAME = RaceDataIOConstants.FILE_TYPE_CFG.composeFileName("LastNameVariations");
    public static final String FIRST_NAME_VARIATIONS_FILE_NAME = RaceDataIOConstants.FILE_TYPE_CFG.composeFileName("FirstNameVariations");
    protected static RacerNameChecker current = new RacerNameChecker();
    protected static Map<String, List<String>> lastNameVariationsTable = new HashMap<String, List<String>>();
    protected static Map<String, List<String>> firstNameVariationsTable = new HashMap<String, List<String>>();

    public static RacerNameChecker getCurrent() {
        return current;
    }

    public static List<String> getFirstNameVariations(String aName) {
        return RacerNameChecker.getRegisteredVariations(aName, RacerNameChecker.getFirstNameVariationsTable());
    }

    protected static Map<String, List<String>> getFirstNameVariationsTable() {
        return firstNameVariationsTable;
    }

    public static List<String> getLastNameVariations(String aName) {
        return RacerNameChecker.getRegisteredVariations(aName, RacerNameChecker.getLastNameVariationsTable());
    }

    protected static Map<String, List<String>> getLastNameVariationsTable() {
        return lastNameVariationsTable;
    }

    protected static List<String> getRegisteredVariations(String aName, Map<String, List<String>> nameVariationsTable) {
        return nameVariationsTable.get(aName.toLowerCase());
    }

    public static void loadNameVariationSpecifications(File aDirectory) {
        RacerNameChecker.loadNameVariationSpecs(LAST_NAME_VARIATIONS_FILE_NAME, aDirectory, lastNameVariationsTable);
        RacerNameChecker.loadNameVariationSpecs(FIRST_NAME_VARIATIONS_FILE_NAME, aDirectory, firstNameVariationsTable);
    }

    protected static void loadNameVariationSpecs(String specFileName, File aDirectory, Map<String, List<String>> nameVariationsTable) {
        List<String[]> nameVariationSpecs;
        File specFile = new File(aDirectory, specFileName);
        if (!specFile.exists()) {
            return;
        }
        try {
            nameVariationSpecs = CSVSpecDataReader.loadValues(specFile);
        }
        catch (IOException ex) {
            return;
        }
        if (nameVariationSpecs.size() == 0) {
            return;
        }
        for (String[] spec : nameVariationSpecs) {
            String name = spec[0];
            for (int i = 1; i < spec.length; ++i) {
                RacerNameChecker.registerNameVariation(name, spec[i], nameVariationsTable);
            }
        }
    }

    public static void registerFirstNameVariation(String name, String alternateName) {
        RacerNameChecker.registerNameVariation(name, alternateName, firstNameVariationsTable);
    }

    public static void registerLastNameVariation(String name, String alternateName) {
        RacerNameChecker.registerNameVariation(name, alternateName, lastNameVariationsTable);
    }

    protected static void registerNameVariation(String name, String alternateName, Map<String, List<String>> nameVariationsTable) {
        String normalizedName = name.toLowerCase();
        List<String> nameVariations = nameVariationsTable.get(normalizedName);
        if (nameVariations == null) {
            nameVariations = new ArrayList<String>();
            nameVariationsTable.put(normalizedName, nameVariations);
        }
        nameVariations.add(alternateName.toLowerCase());
    }

    public List<Racer> getAllRacersWithSameLastName(RacerList racerList, String lastName) {
        ArrayList<Racer> matchingRacers = new ArrayList<Racer>();
        for (Racer aRacer : racerList.getRacers()) {
            if (!this.sameLastName(aRacer, lastName)) continue;
            matchingRacers.add(aRacer);
        }
        return matchingRacers;
    }

    public List<Racer> getAllRacersWithSameLastName(RacerList racerList, String lastName, RaceClass<?> ageClass) {
        List<Racer> allMatchingRacers = this.getAllRacersWithSameLastName(racerList, lastName);
        if (allMatchingRacers.size() == 0) {
            return allMatchingRacers;
        }
        ArrayList<Racer> matchingRacers = new ArrayList<Racer>();
        for (Racer aRacer : matchingRacers) {
            if (!aRacer.isInAgeClass(ageClass)) continue;
            matchingRacers.add(aRacer);
        }
        return matchingRacers;
    }

    public List<Racer> getAllRacersWithSameName(RacerList racerList, String lastName, String firstName) {
        ArrayList<Racer> matchingRacers = new ArrayList<Racer>();
        for (Racer aRacer : racerList.getRacers()) {
            if (!this.sameName(aRacer, lastName, firstName)) continue;
            matchingRacers.add(aRacer);
        }
        return matchingRacers;
    }

    public List<Racer> getAllRacersWithSameName(RacerList racerList, String lastName, String firstName, RaceClass<?> ageClass) {
        List<Racer> allMatchingRacers = this.getAllRacersWithSameName(racerList, lastName, firstName);
        if (allMatchingRacers.size() == 0) {
            return allMatchingRacers;
        }
        ArrayList<Racer> matchingRacers = new ArrayList<Racer>();
        for (Racer aRacer : allMatchingRacers) {
            if (!aRacer.isInAgeClass(ageClass)) continue;
            matchingRacers.add(aRacer);
        }
        return matchingRacers;
    }

    protected boolean hasRegisteredNameVariation(String aName, String registeredName, Map<String, List<String>> nameVariationsTable) {
        List<String> nameVariations = nameVariationsTable.get(registeredName.toLowerCase());
        if (nameVariations != null) {
            for (String aVariation : nameVariations) {
                if (!aVariation.equalsIgnoreCase(aName)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isSameName(String aName, String racerName, Map<String, List<String>> nameVariationsTable) {
        if (aName.equalsIgnoreCase(racerName)) {
            return true;
        }
        return this.hasRegisteredNameVariation(aName, racerName, nameVariationsTable);
    }

    public boolean sameFirstName(Racer aRacer, String aName) {
        if (this.isSameName(aName, aRacer.getFirstName(), RacerNameChecker.getFirstNameVariationsTable())) {
            return true;
        }
        return aName.length() > 1 && (aRacer.getFirstName().toLowerCase().startsWith(aName.toLowerCase()) || aName.toLowerCase().startsWith(aRacer.getFirstName().toLowerCase()));
    }

    public boolean sameLastName(Racer aRacer, String aName) {
        return this.isSameName(aName, aRacer.getLastName(), RacerNameChecker.getLastNameVariationsTable());
    }

    public boolean sameName(Racer aRacer, String lastName, String firstName) {
        return this.sameLastName(aRacer, lastName) && this.sameFirstName(aRacer, firstName);
    }
}

