/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.tools.foundation.processors;

import com.glaivestone.javax.devx.Assert;
import com.glaivestone.toolbox.settings.SettingsFileHolder;
import com.glaivestone.toolbox.settings.SettingsSection;
import java.awt.Window;
import java.io.File;
import javax.swing.ImageIcon;
import org.ussamasters.aces.tools.foundation.models.RaceScoringSessionManager;
import org.ussamasters.aces.tools.foundation.processors.InstallationConfigurationSettingsProcessor;

public class ToolConfigurationSettingsProcessor
extends InstallationConfigurationSettingsProcessor {
    protected RaceScoringSessionManager toolSessionManager;
    protected SettingsSection toolSettings;

    public ToolConfigurationSettingsProcessor(RaceScoringSessionManager toolSessionManager, SettingsFileHolder rootSettings) {
        super(rootSettings);
        this.toolSessionManager = toolSessionManager;
    }

    @Override
    protected void displaySplashScreen(ImageIcon splashScreen) {
        super.displaySplashScreen(splashScreen);
        String resourceName = "SplashScreenFile";
        this.toolSessionManager.registerSessionResource(resourceName, splashScreen);
    }

    @Override
    protected File getBaseDirectory() {
        return this.toolSessionManager.getToolInstallationDirectory();
    }

    @Override
    protected SettingsSection getConfigSettings() {
        return this.toolSettings;
    }

    public void processConfigurationSpecifications() {
        this.processEarlyStartupSpecifications();
        this.processSystemSpecifications();
        this.processToolSpecifications();
    }

    protected void processGeneralSpecifications() {
        String defaultToolIcon = this.getConfigSettings().getStringValue("defaultToolIcon");
        this.toolSessionManager.registerSessionResource("DefaultToolIcon", defaultToolIcon);
    }

    protected void processToolSpecifications() {
        this.processGeneralSpecifications();
    }

    @Override
    protected void setRootSettings(SettingsFileHolder rootSettings) {
        super.setRootSettings(rootSettings);
        this.toolSettings = rootSettings.getSection("Tools");
        Assert.isTrue(this.toolSettings != null, "No <Tools> config specifications section in " + this.getRootSettings().getFile().getAbsolutePath());
    }

    @Override
    protected void setSplashScreenWindow(Window aSplashScreenWindow) {
        super.setSplashScreenWindow(aSplashScreenWindow);
        String resourceName = "SplashScreen";
        if (aSplashScreenWindow != null) {
            this.toolSessionManager.registerSessionResource(resourceName, aSplashScreenWindow);
        } else {
            this.toolSessionManager.removeSessionResource(resourceName);
        }
    }

    public static void processConfigurationSpecifications(RaceScoringSessionManager toolSessionManager, SettingsFileHolder rootSettings, String splashScreenPathName) {
        ToolConfigurationSettingsProcessor settingsProcessor = new ToolConfigurationSettingsProcessor(toolSessionManager, rootSettings);
        settingsProcessor.displaySplashScreen(splashScreenPathName);
        settingsProcessor.processConfigurationSpecifications();
    }

    @Override
    protected ImageIcon resolveSplashScreenReference(String splashScreenFileRef) {
        return this.loadImageFile(splashScreenFileRef, this.toolSessionManager.getToolInstallationDirectory());
    }
}

