/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.tools.foundation.settings;

import com.glaivestone.javax.execution.SessionManager;
import com.glaivestone.javax.io.FileSystemReference;
import com.glaivestone.javax.io.FileSystemServices;
import com.glaivestone.toolbox.settings.Settings;
import com.glaivestone.toolbox.settings.SettingsFileHolder;
import com.glaivestone.toolbox.settings.SettingsSection;
import com.glaivestone.toolbox.settings.SettingsSectionHolder;
import com.glaivestone.toolbox.settings.StandardSettingsFileHolder;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class DeveloperSettings
extends StandardSettingsFileHolder {
    protected static final String CHECKOUT_DIR_NAME = "ReposWrk";
    protected static final String BACKSTOP_SECTION_NAME = "DeveloperSettings-BACKSTOP";
    protected static final String ROOTS_SECTION_NAME = "Roots";
    protected static final List<String> ALL_EXTENSIONS_LIST = Arrays.asList("*");
    protected static final List<String> EMPTY_FILENAMES_LIST = new ArrayList<String>();
    protected static File defaultBootstrapDirectory;

    public DeveloperSettings(File backingFile) throws IOException {
        super(backingFile);
    }

    protected void checkStartupDirectory() {
        File startupDirectory = this.getDirectory();
        if (this.shouldBootstrapInstallationDirectory(startupDirectory)) {
            this.initializeInstallationDirectory(startupDirectory);
        }
    }

    protected void copyFiles(File targetDir, File sourceDir) {
        this.copyFiles(targetDir, sourceDir, ALL_EXTENSIONS_LIST, EMPTY_FILENAMES_LIST, EMPTY_FILENAMES_LIST);
    }

    protected void copyFiles(File installDir, File sourceDir, List<String> extensionsToCopy, List<String> filesToIgnore, List<String> subdirectoriesToIgnore) {
        File[] fsElements = sourceDir.listFiles();
        for (int i = 0; i < fsElements.length; ++i) {
            File prototype = fsElements[i];
            String fileName = prototype.getName();
            File target = new File(installDir, fileName);
            if (prototype.isFile()) {
                if (extensionsToCopy != ALL_EXTENSIONS_LIST && !extensionsToCopy.contains(FileSystemReference.getFileExtension(prototype).toLowerCase()) || filesToIgnore.contains(fileName.toLowerCase()) || target.exists() && target.lastModified() >= prototype.lastModified()) continue;
                try {
                    FileSystemServices.getCurrent().copyFile(prototype, installDir);
                }
                catch (Exception ex) {
                    System.out.println("***FILE COPY ERROR: " + prototype);
                    ex.printStackTrace();
                    System.exit(0);
                }
                continue;
            }
            if (subdirectoriesToIgnore.contains(target.getName().toLowerCase())) continue;
            this.ensureDirectoryExists(target);
            this.copyFiles(target, prototype, extensionsToCopy, filesToIgnore, EMPTY_FILENAMES_LIST);
        }
    }

    protected void ensureDirectoryExists(File aDirectory) {
        try {
            FileSystemServices.getCurrent().realizeDirectory(aDirectory);
        }
        catch (IOException ex) {
            System.out.println("***BOOTSTRAP DIRECTORY CREATE ERROR: " + aDirectory.getAbsolutePath());
            ex.printStackTrace();
            System.exit(0);
        }
    }

    protected File getRootPrototypesDirectory(File prototypesDirectory) {
        return new File(prototypesDirectory, "Root");
    }

    protected void initializeInstallationDirectory(File startupDirectory) {
        File prototypesDirectory = null;
        SettingsSection rootSettings = this.getSection(ROOTS_SECTION_NAME);
        prototypesDirectory = null;
        if (rootSettings != null && (prototypesDirectory = new SettingsSectionHolder(rootSettings, (SettingsFileHolder)this).getFileValue("bootstrapDirectory")) != null && !prototypesDirectory.exists()) {
            System.err.println("ERROR: Developer bootstrap directory not found: " + prototypesDirectory.getAbsolutePath());
            SessionManager.current.shutdown();
        }
        if (prototypesDirectory == null) {
            prototypesDirectory = defaultBootstrapDirectory;
        }
        if (prototypesDirectory == null) {
            System.err.println("Unable to perform developer installation bootstrap (no prototypes directory available)");
            SessionManager.current.shutdown();
        }
        this.initializeInstallationDirectory(startupDirectory, prototypesDirectory);
    }

    protected void initializeInstallationDirectory(File startupDirectory, File prototypesDirectory) {
        File rootPrototypesDirectory = this.getRootPrototypesDirectory(prototypesDirectory);
        System.out.println("\nPerforming bootstrap initialization of developer installation...");
        System.out.println("...installation directory: " + startupDirectory.getAbsolutePath());
        System.out.println("...root files source: " + rootPrototypesDirectory.getAbsolutePath());
        this.initRootInstallationDirectory(startupDirectory, rootPrototypesDirectory);
        this.initSystemConfigFiles(startupDirectory, rootPrototypesDirectory);
        System.out.println("...bootstrap initialization completed\n");
    }

    protected void initRootInstallationDirectory(File rootDirectory, File rootPrototypesDirectory) {
    }

    protected void initSystemConfigFiles(File rootDirectory, File rootPrototypesDirectory) {
    }

    @Override
    public void loadSettings() throws IOException {
        if (this.getFile() != null && !this.getFile().exists()) {
            this.setSettings(this.constructSettings(BACKSTOP_SECTION_NAME));
            return;
        }
        super.loadSettings();
    }

    protected void performDeveloperSystemInitialization() {
        this.checkStartupDirectory();
    }

    @Override
    public void setSettings(Settings settings) {
        super.setSettings(settings);
        this.performDeveloperSystemInitialization();
    }

    protected boolean shouldBootstrapInstallationDirectory(File startupDirectory) {
        if (!startupDirectory.exists()) {
            this.ensureDirectoryExists(startupDirectory);
            return true;
        }
        if (!this.getSettings().getBooleanValue("enableBootstrapInit", true)) {
            return false;
        }
        return this.shouldInitializeInstallationDirectory(startupDirectory);
    }

    protected boolean shouldInitializeInstallationDirectory(File startupDirectory) {
        return false;
    }

    protected static File adjustStartupDirectory(File aDirectory, String relativeLocationAdjustment) {
        File reposCheckoutDirectory = new File(CHECKOUT_DIR_NAME);
        if (reposCheckoutDirectory.exists()) {
            return FileSystemReference.resolveRelativePath(aDirectory, relativeLocationAdjustment);
        }
        return aDirectory;
    }

    protected static boolean isDeveloperConfiguration(File aDirectory, String configSettingsFileName) {
        File reposCheckoutDirectory = new File(CHECKOUT_DIR_NAME);
        if (reposCheckoutDirectory.exists()) {
            defaultBootstrapDirectory = reposCheckoutDirectory;
            return true;
        }
        return new File(aDirectory, configSettingsFileName).exists();
    }
}

