/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.tools.foundation.settings;

import com.glaivestone.toolbox.settings.Settings;
import com.glaivestone.toolbox.settings.SettingsHolder;
import com.glaivestone.toolbox.settings.SettingsSection;
import com.glaivestone.toolbox.settings.StandardSettingsFileHolder;
import java.io.File;
import java.io.IOException;

public class SessionRootSettings
extends StandardSettingsFileHolder {
    public static SessionRootSettings current = null;
    public static final String SECTION_ROOTS = "Roots";
    public static final String PROPERTY_CONFIGURATION_DIRECTORY = "configurationDirectory";
    public static final String PROPERTY_HELP_DIRECTORY = "helpDirectory";
    public static final String PROPERTY_LOG_DIRECTORY = "logDirectory";
    public static final String PROPERTY_SYSTEM_DIRECTORY = "systemDirectory";
    public static final String PROPERTY_DATASETS_DIRECTORY = "dataSetsBaseDirectory";
    public static final String DEFAULT_HELP_DIRECTORY = "-r-Doc";
    public static final String DEFAULT_SYSTEM_DIRECTORY = "-r-Tools/System";
    public static final String DEFAULT_CONFIGURATION_DIRECTORY = "-r-../ConfigurationSettings";
    public static final String DEFAULT_LOG_DIRECTORY_NAME = "log";
    public static final String DEFAULT_LOG_DIRECTORY = "-r-../log";
    protected File systemDirectory;
    protected File helpDirectory;
    protected File configurationFilesDirectory;
    protected File logDirectory;
    protected File dataSetsDirectory;

    public static SessionRootSettings getCurrent() {
        return current;
    }

    public SessionRootSettings(File backingFile) throws IOException {
        super(backingFile);
    }

    protected String defaultUserDataDirectoryName() {
        return "-r-..\\UserData";
    }

    protected SettingsSection getRootSettings() {
        return this.getSection(SECTION_ROOTS);
    }

    public File getHelpDirectory() {
        return this.helpDirectory;
    }

    public File getLogDirectory() {
        return this.logDirectory;
    }

    public File getSystemDirectory() {
        return this.systemDirectory;
    }

    public File getUserConfigurationDirectory() {
        return this.configurationFilesDirectory;
    }

    public File getUserDataDirectory() {
        return this.dataSetsDirectory;
    }

    public boolean hasUserConfigurationFiles() {
        return this.getUserConfigurationDirectory().list().length > 0;
    }

    protected void initRootDirectories(Settings rootsSettings) {
        String dirSettingName = PROPERTY_SYSTEM_DIRECTORY;
        String settingValue = rootsSettings.getStringValue(dirSettingName, DEFAULT_SYSTEM_DIRECTORY);
        this.systemDirectory = this.resolveRootDirectoryReference(dirSettingName, settingValue, false);
        dirSettingName = PROPERTY_HELP_DIRECTORY;
        settingValue = rootsSettings.getStringValue(dirSettingName, DEFAULT_HELP_DIRECTORY);
        this.helpDirectory = this.resolveRootDirectoryReference(dirSettingName, settingValue, true);
        dirSettingName = PROPERTY_CONFIGURATION_DIRECTORY;
        settingValue = rootsSettings.getStringValue(dirSettingName, DEFAULT_CONFIGURATION_DIRECTORY);
        this.configurationFilesDirectory = this.resolveRootDirectoryReference(dirSettingName, settingValue, true);
        dirSettingName = PROPERTY_LOG_DIRECTORY;
        settingValue = rootsSettings.getStringValue(dirSettingName, DEFAULT_LOG_DIRECTORY);
        this.logDirectory = this.resolveDirectoryReference(settingValue, this.getDirectory());
        dirSettingName = PROPERTY_DATASETS_DIRECTORY;
        settingValue = rootsSettings.getStringValue(dirSettingName, this.defaultUserDataDirectoryName());
        this.dataSetsDirectory = this.resolveRootDirectoryReference(dirSettingName, settingValue, true);
    }

    protected File resolveDirectoryReference(String aReference, File referenceDirectory) {
        return aReference == null ? null : SettingsHolder.resolvePathNameValue(aReference.trim(), referenceDirectory);
    }

    protected File resolveRootDirectoryReference(String name, String aReference, boolean createIfNotThere) {
        return SettingsHolder.resolveDirectoryReference(aReference, this.getDirectory(), createIfNotThere);
    }

    @Override
    public void setSettings(Settings settings) {
        super.setSettings(settings);
        this.initRootDirectories(this.getRootSettings());
    }
}

