/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.tools.ui;

import com.glaivestone.mv.BooleanHolder;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import javax.swing.DefaultComboBoxModel;
import org.ussamasters.aces.racedata.io.RaceDataIOException;
import org.ussamasters.aces.racedata.models.CourseArrangement;
import org.ussamasters.aces.racedata.models.ParameterSpecification;
import org.ussamasters.aces.racedata.models.PolicyID;
import org.ussamasters.aces.racedata.models.RaceOrganization;
import org.ussamasters.aces.racedata.models.RaceSeries;
import org.ussamasters.aces.racedata.models.WorldCupPointsType;
import org.ussamasters.aces.racedata.reports.RaceDataReportOptions;
import org.ussamasters.aces.tools.foundation.models.BibNumberRange;
import org.ussamasters.aces.tools.foundation.models.PBARacerListManagementPolicy;
import org.ussamasters.aces.tools.foundation.models.RacerListManagementPolicy;
import org.ussamasters.aces.tools.foundation.models.RacerListManagementPolicySpecification;
import org.ussamasters.aces.tools.foundation.processors.ValidationResolver;
import org.ussamasters.aces.tools.foundation.processors.ValidationResult;
import org.ussamasters.aces.tools.foundation.settings.WorkingSetSettings;
import org.ussamasters.aces.tools.ui.ChangedValuesHolder;
import org.ussamasters.aces.tools.ui.WorkingSetSettingsEditor;

public class EditConfigurationSettingsDialog
extends WorkingSetSettingsEditor {
    public static final String PROPERTY_DEFAULT_RACE_CLASS_CLASSES = "raceClassClasses";
    public static final String PROPERTY_DEFAULT_WORLD_CUP_POINTS = "worldCupPoints";
    public static final String PROPERTY_DEFAULT_COURSE_ARRANGEMENT = "courseArrangement";
    public static final String PROPERTY_RACER_LIST_MANAGEMENT_POLICY = "racerListManagementPolicy";
    public static final String PROPERTY_RACER_LIST_MERGE_POLICY = "racerListMergePolicy";
    public static final String PROPERTY_INCLUDE_RACER_AFFILIATION_IN_REPORTS = "includeRacerAffiliationInReports";
    public static final String PROPERTY_INCLUDE_RACE_POINTS_IN_TEXT_REPORTS = "includeRacePointsInTextReports";
    public static final String PROPERTY_SAVE_REPORT_SCORING_DATA = "saveReportScoringData";
    public static final String PROPERTY_SAVE_REPORT_FORMATTING_OBJECTS = "saveReportFO";
    private static final String DIALOG_TITLE = "Configuration Settings Editor";
    protected RaceSeries raceSeries;
    protected WorkingSetSettings wsSettings;
    protected RaceDataReportOptions reportSettings;
    protected DefaultComboBoxModel<PolicyID> racerListManagementPoliciesHolder;
    protected DefaultComboBoxModel<PolicyID> racerListMergePoliciesHolder;
    protected BooleanHolder includeRacerAffiliationInReportsHolder;
    protected BooleanHolder includeRacePointsInTextReportsHolder;
    protected BooleanHolder saveReportScoringDataHolder;
    protected BooleanHolder saveReportFOHolder;
    protected RacerListManagementPolicySpecification currentRacerListManagementPolicySpec;
    protected RacerListManagementPolicySpecification selectedRacerListManagementPolicySpec;
    protected ChangedValuesHolder changedValues;

    public static void openFor(Window aWindow) {
        EditConfigurationSettingsDialog aDialog = new EditConfigurationSettingsDialog(aWindow);
        aDialog.openWindow();
    }

    public EditConfigurationSettingsDialog(Window aWindow) {
        super(aWindow);
        this.initializeModels();
    }

    public void acceptChanges() throws IOException, RaceDataIOException {
        boolean wsSettingsChanged = false;
        Class newSeriesRaceClassClass = null;
        WorldCupPointsType newScoringType = null;
        RacerListManagementPolicy newRacerListManagementPolicy = null;
        Object newValue = this.getChangedValues().get(PROPERTY_DEFAULT_RACE_CLASS_CLASSES);
        if (newValue != null) {
            newSeriesRaceClassClass = (Class)newValue;
            this.wsSettings.setRaceClassClass(newSeriesRaceClassClass);
            wsSettingsChanged = true;
        }
        if ((newValue = this.getChangedValues().get(PROPERTY_DEFAULT_WORLD_CUP_POINTS)) != null) {
            newScoringType = (WorldCupPointsType)((Object)newValue);
            this.wsSettings.setWorldCupPointsType(newScoringType);
            wsSettingsChanged = true;
        }
        if ((newValue = this.getChangedValues().get(PROPERTY_DEFAULT_COURSE_ARRANGEMENT)) != null) {
            this.wsSettings.setStandardCourseArrangement((CourseArrangement)newValue);
            wsSettingsChanged = true;
        }
        if ((newValue = this.getChangedValues().get(PROPERTY_RACER_LIST_MANAGEMENT_POLICY)) != null) {
            this.wsSettings.setRacerListManagementPolicy((RacerListManagementPolicySpecification)newValue);
            newRacerListManagementPolicy = this.wsSettings.constructRacerListManagementPolicy();
            wsSettingsChanged = true;
        }
        if ((newValue = this.getChangedValues().get(PROPERTY_RACER_LIST_MERGE_POLICY)) != null) {
            this.wsSettings.setRacerListMergePolicy((PolicyID)newValue);
            wsSettingsChanged = true;
        }
        if ((newValue = this.getChangedValues().get(PROPERTY_INCLUDE_RACER_AFFILIATION_IN_REPORTS)) != null) {
            this.reportSettings.setIncludeRacerAffiliationInReports((Boolean)newValue);
            wsSettingsChanged = true;
        }
        if ((newValue = this.getChangedValues().get(PROPERTY_INCLUDE_RACE_POINTS_IN_TEXT_REPORTS)) != null) {
            this.reportSettings.setIncludeRacePointsInTextReports((Boolean)newValue);
            wsSettingsChanged = true;
        }
        if ((newValue = this.getChangedValues().get(PROPERTY_SAVE_REPORT_SCORING_DATA)) != null) {
            this.reportSettings.setSaveReportScoringData((Boolean)newValue);
            wsSettingsChanged = true;
        }
        if ((newValue = this.getChangedValues().get(PROPERTY_SAVE_REPORT_FORMATTING_OBJECTS)) != null) {
            this.reportSettings.setSaveReportFormattingSpecifications((Boolean)newValue);
            wsSettingsChanged = true;
        }
        this.clearChanges();
        if (wsSettingsChanged) {
            this.wsSettings.saveSettings();
        }
        if (newSeriesRaceClassClass != null) {
            this.getSessionManager().updateSeriesRaceClass(newSeriesRaceClassClass);
        }
        if (newScoringType != null) {
            this.getSessionManager().updateSeriesScoringType(newScoringType);
        }
        if (newRacerListManagementPolicy != null) {
            this.getSessionManager().updateRacerListManagementPolicy(newRacerListManagementPolicy);
        }
    }

    protected DefaultComboBoxModel<PolicyID> constructRacerListManagementPoliciesHolder() {
        return this.getToolUIModelServices().constructComboBoxListHolder(WorkingSetSettings.getRacerListManagementPolicies());
    }

    protected DefaultComboBoxModel<PolicyID> constructRacerListMergePoliciesHolder() {
        return this.getToolUIModelServices().constructComboBoxListHolder(WorkingSetSettings.getRacerListMergePolicies());
    }

    public void clearChanges() {
        this.changedValues = null;
    }

    @Override
    public void clearResult() {
        this.clearChanges();
    }

    protected void computeChanges() {
        this.changedValues = this.constructChangedValues();
        this.getChangedValues().recordValueIfChanged(PROPERTY_DEFAULT_RACE_CLASS_CLASSES, this.wsSettings.getRaceClassClass(), this.getSelectedSeriesRaceClass(this.wsSettings.getSeason()));
        this.getChangedValues().recordValueIfChanged(PROPERTY_DEFAULT_WORLD_CUP_POINTS, (Object)this.wsSettings.getWorldCupPointsType(), (Object)this.getSelectedWorldCupPoints());
        this.getChangedValues().recordValueIfChanged(PROPERTY_DEFAULT_COURSE_ARRANGEMENT, this.wsSettings.getStandardCourseArrangement(), this.getSelectedCourseArrangement());
        if (!this.selectedRacerListManagementPolicySpec.sameAs(this.currentRacerListManagementPolicySpec)) {
            this.getChangedValues().recordValue(PROPERTY_RACER_LIST_MANAGEMENT_POLICY, this.selectedRacerListManagementPolicySpec);
        }
        this.getChangedValues().recordValueIfChanged(PROPERTY_RACER_LIST_MERGE_POLICY, this.wsSettings.getRacerListMergePolicy(), this.getSelectedRacerListMergePolicy());
        this.getChangedValues().recordValueIfChanged(PROPERTY_INCLUDE_RACER_AFFILIATION_IN_REPORTS, this.reportSettings.getIncludeRacerAffiliationInReports(), this.includeRacerAffiliationInReportsHolder.getValue());
        this.getChangedValues().recordValueIfChanged(PROPERTY_INCLUDE_RACE_POINTS_IN_TEXT_REPORTS, this.reportSettings.getIncludeRacePointsInTextReports(), this.includeRacePointsInTextReportsHolder.getValue());
        this.getChangedValues().recordValueIfChanged(PROPERTY_SAVE_REPORT_SCORING_DATA, this.reportSettings.getSaveReportScoringData(), this.saveReportScoringDataHolder.getValue());
        this.getChangedValues().recordValueIfChanged(PROPERTY_SAVE_REPORT_FORMATTING_OBJECTS, this.reportSettings.getSaveReportFormattingSpecifications(), this.saveReportFOHolder.getValue());
    }

    protected ChangedValuesHolder constructChangedValues() {
        return new ChangedValuesHolder();
    }

    protected ChangedValuesHolder getChangedValues() {
        if (this.changedValues == null) {
            this.changedValues = this.constructChangedValues();
            this.computeChanges();
        }
        return this.changedValues;
    }

    public RaceSeries getRaceSeries() {
        return this.raceSeries;
    }

    public String getRaceSeriesName() {
        return WorkingSetSettings.getCurrent().getDescription();
    }

    public String getTitle() {
        return DIALOG_TITLE;
    }

    public BooleanHolder getIncludeRacerAffiliationInReportsHolder() {
        return this.includeRacerAffiliationInReportsHolder;
    }

    public BooleanHolder getIncludeRacePointsInTextReportsHolder() {
        return this.includeRacePointsInTextReportsHolder;
    }

    protected RacerListManagementPolicy getRacerListManagementPolicy() {
        return this.getSessionManager().getRacerList().getManagementPolicy();
    }

    public DefaultComboBoxModel<PolicyID> getRacerListManagementPoliciesHolder() {
        return this.racerListManagementPoliciesHolder;
    }

    public DefaultComboBoxModel<PolicyID> getRacerListMergePoliciesHolder() {
        return this.racerListMergePoliciesHolder;
    }

    public BooleanHolder getSaveReportScoringDataHolder() {
        return this.saveReportScoringDataHolder;
    }

    public BooleanHolder getSaveReportFOHolder() {
        return this.saveReportFOHolder;
    }

    public PolicyID getSelectedRacerListManagementPolicy() {
        return (PolicyID)this.getRacerListManagementPoliciesHolder().getSelectedItem();
    }

    public RacerListManagementPolicySpecification getSelectedRacerListManagementPolicySpec() {
        return this.selectedRacerListManagementPolicySpec;
    }

    public PolicyID getSelectedRacerListMergePolicy() {
        return (PolicyID)this.getRacerListMergePoliciesHolder().getSelectedItem();
    }

    public File getWorkingSetDirectory() {
        return this.getSessionManager().getWorkingSetDirectory();
    }

    public boolean hasChanges() {
        return this.getChangedValues().size() > 0;
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.raceSeries = this.getSessionManager().getRaceCalendar();
        this.wsSettings = WorkingSetSettings.getCurrent();
        this.reportSettings = this.wsSettings.getReportSettings();
    }

    protected void initializeModels() {
        this.initRaceSeriesSettingsModels(this.wsSettings);
        this.currentRacerListManagementPolicySpec = this.wsSettings.getRacerListManagementPolicySpec();
        this.racerListManagementPoliciesHolder = this.constructRacerListManagementPoliciesHolder();
        this.racerListManagementPoliciesHolder.setSelectedItem(this.currentRacerListManagementPolicySpec.policyID);
        this.selectRacerListManagementPolicy(this.currentRacerListManagementPolicySpec.policyID);
        this.racerListMergePoliciesHolder = this.constructRacerListMergePoliciesHolder();
        this.racerListMergePoliciesHolder.setSelectedItem(this.wsSettings.getRacerListMergePolicy());
        this.includeRacerAffiliationInReportsHolder = new BooleanHolder(this.reportSettings.getIncludeRacerAffiliationInReports());
        this.includeRacePointsInTextReportsHolder = new BooleanHolder(this.reportSettings.getIncludeRacePointsInTextReports());
        this.saveReportScoringDataHolder = new BooleanHolder(this.reportSettings.getSaveReportScoringData());
        this.saveReportFOHolder = new BooleanHolder(this.reportSettings.getSaveReportFormattingSpecifications());
    }

    public void selectRacerListManagementPolicy(PolicyID policyID) {
        RacerListManagementPolicySpecification policySpec;
        if (policyID == this.currentRacerListManagementPolicySpec.policyID) {
            policySpec = this.currentRacerListManagementPolicySpec;
            if (policySpec.hasConfigurableParameters()) {
                policySpec = policySpec.copy();
            }
        } else {
            policySpec = this.wsSettings.getRacerListManagementPolicySpec(policyID);
        }
        this.selectedRacerListManagementPolicySpec = policySpec.copy();
    }

    public ValidationResult validateChanges(ValidationResolver validationResolver) {
        ValidationResult validationResult = new ValidationResult();
        String propertyName = PROPERTY_DEFAULT_RACE_CLASS_CLASSES;
        Class raceClassClass = (Class)this.getChangedValues().get(propertyName);
        if (raceClassClass != null) {
            if (this.raceSeries.hasResults()) {
                this.validationFailed(propertyName, "Changing the series age classes is not allowed after the series schedule is defined and race results have been loaded.", validationResult);
                return validationResult;
            }
            if (this.getSessionManager().getRacerList().size() > 0) {
                this.validationFailed(propertyName, "Changing the series age classes is not allowed after racers have already been entered in the series racer list.", validationResult);
                return validationResult;
            }
        }
        propertyName = PROPERTY_DEFAULT_WORLD_CUP_POINTS;
        WorldCupPointsType scoringType = (WorldCupPointsType)((Object)this.getChangedValues().get(propertyName));
        if (scoringType != null && this.raceSeries.hasResults()) {
            this.validationFailed(propertyName, "Changing the world cup points scoring formula is not allowed after race results are already loaded.", validationResult);
        }
        propertyName = PROPERTY_RACER_LIST_MANAGEMENT_POLICY;
        RacerListManagementPolicySpecification policySpec = (RacerListManagementPolicySpecification)this.getChangedValues().get(propertyName);
        if (policySpec != null) {
            if (PBARacerListManagementPolicy.isSupportedPolicy(policySpec.policyID)) {
                BibNumberRange[] seriesTrackingBibRanges;
                BibNumberRange[] permanentBibRanges;
                RaceOrganization bibAllocationOrg;
                ParameterSpecification parmSpec = policySpec.getParameterSpecification("bibAllocationOrganization");
                if (parmSpec.modifiable && (bibAllocationOrg = PBARacerListManagementPolicy.toOrganization(parmSpec)) == null) {
                    this.validationFailed(propertyName, "Unknown bib allocation organization name.", validationResult);
                    return validationResult;
                }
                parmSpec = policySpec.getParameterSpecification("permanentBibsRange");
                try {
                    permanentBibRanges = PBARacerListManagementPolicy.toBibNumberRanges(parmSpec);
                }
                catch (RuntimeException ex) {
                    this.validationFailed(propertyName, "Invalid range given for permanent bibs - must be one or more entries \"m..n\" or \"n+\"", validationResult);
                    return validationResult;
                }
                parmSpec = policySpec.getParameterSpecification("seriesTempBibsRange");
                try {
                    seriesTrackingBibRanges = PBARacerListManagementPolicy.toBibNumberRanges(parmSpec);
                }
                catch (RuntimeException ex) {
                    this.validationFailed(propertyName, "Invalid range given for series tracking bibs - must be one or more entries \"m..n\" or \"n+\"", validationResult);
                    return validationResult;
                }
                if (BibNumberRange.hasOverlap(permanentBibRanges, seriesTrackingBibRanges)) {
                    this.validationFailed(propertyName, "Permanent bibs and series tracking bib ranges must not overlap", validationResult);
                    return validationResult;
                }
            }
            if (this.getSessionManager().getRacerList().size() > 0 && !validationResolver.confirm(propertyName, "Changing the racer list management policy will not affect the entries of competitors already in the series racer list.\n\nDo you still want to make this change?")) {
                this.validationFailed(propertyName, "User cancelled racer list management policy change", validationResult);
                return validationResult;
            }
        }
        return ValidationResult.SUCCESS_RESULT;
    }

    protected void validationFailed(String propertyName, String problemDescription, ValidationResult validationResult) {
        this.clearChanges();
        validationResult.reportProblem(propertyName, problemDescription);
    }
}

