/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.tools.ui;

import com.glaivestone.javax.swing.PlainTextDocument;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import org.ussamasters.aces.racedata.models.Gender;
import org.ussamasters.aces.racedata.models.RaceClass;
import org.ussamasters.aces.racedata.models.RaceClassHelper;
import org.ussamasters.aces.racedata.models.RaceClassRegistry;
import org.ussamasters.aces.racedata.models.RaceOrganization;
import org.ussamasters.aces.racedata.models.Racer;
import org.ussamasters.aces.racedata.models.SeasonIdentifier;
import org.ussamasters.aces.racedata.models.USSALicense;
import org.ussamasters.aces.tools.foundation.models.ToolServices;
import org.ussamasters.aces.tools.foundation.models.ToolSessionRacerList;
import org.ussamasters.aces.tools.foundation.processors.RacerNameChecker;
import org.ussamasters.aces.tools.foundation.processors.ValidationResolver;
import org.ussamasters.aces.tools.foundation.processors.ValidationResult;
import org.ussamasters.aces.tools.ui.ChangedValuesHolder;
import org.ussamasters.aces.tools.ui.RaceDataDialog;

public abstract class EditRacerDataDialog
extends RaceDataDialog {
    private static final Class<EditRacerDataDialog> THIS_CLASS = EditRacerDataDialog.class;
    public static final ValidationResolver NO_USER_INTERACTION_RESOLVER = new ValidationResolver(){

        @Override
        public boolean confirm(Object issue, String proposedResolution) {
            return false;
        }

        @Override
        public boolean confirmMinorIssues() {
            return false;
        }
    };
    public static final String PROPERTY_LAST_NAME = "lastName";
    public static final String PROPERTY_FIRST_NAME = "firstName";
    public static final String PROPERTY_BIB_NUMBER = "bibNumber";
    public static final String PROPERTY_AGE_CLASS = "ageClass";
    public static final String PROPERTY_NATIONAL_CLASS = "nationalClass";
    public static final String PROPERTY_BIRTH_YEAR = "birthYear";
    public static final String PROPERTY_AFFILIATION = "affiliation";
    public static final String PROPERTY_USSA_NUMBER = "ussaNumber";
    public static final String PROPERTY_TEAM = "team";
    protected static final String CHANGE_DATA_MATCHING_RACERS = "registeredRacersWithSameName";
    protected static List<RaceOrganization> affiliationsList;
    private static final String DIALOG_TITLE = "Edit Racer Data";
    protected final ToolSessionRacerList racerList;
    protected final SeasonIdentifier season;
    protected final RaceClassHelper raceClassHelper;
    protected boolean nationalClassMapsDirectlyFromAgeClass;
    protected Racer newRacerData;
    protected PlainTextDocument lastNameHolder;
    protected PlainTextDocument firstNameHolder;
    protected PlainTextDocument bibNumberHolder;
    protected DefaultComboBoxModel<RaceClass<?>> ageClassListHolder;
    protected DefaultComboBoxModel<RaceClass<?>> nationalClassListHolder;
    protected PlainTextDocument birthYearHolder;
    protected DefaultComboBoxModel<RaceOrganization> affiliationListHolder;
    protected PlainTextDocument ussaNumberHolder;
    protected ChangedValuesHolder changedValues;

    protected static void initStaticData() {
        affiliationsList = new ArrayList<RaceOrganization>();
        affiliationsList.addAll(RaceOrganization.ussaDivisions);
        Collections.sort(affiliationsList, ToolServices.BY_NAME_CONSTANT_SORTER);
        affiliationsList.add(0, RaceOrganization.UNKNOWN);
        affiliationsList.add(1, RaceOrganization.TEMP);
        affiliationsList.addAll(RaceOrganization.foreignOrganizations);
    }

    public EditRacerDataDialog() {
        this.racerList = this.getSessionManager().getRacerList();
        this.season = this.racerList.getSeason();
        this.raceClassHelper = new RaceClassHelper(this.season);
        this.initializeModels();
    }

    protected EditRacerDataDialog(Window aWindow, ToolSessionRacerList racerList) {
        super(aWindow);
        this.racerList = racerList;
        this.season = this.racerList.getSeason();
        this.raceClassHelper = new RaceClassHelper(this.season);
        this.initializeModels();
    }

    public void acceptChanges() {
    }

    public void clearChanges() {
        this.changedValues = null;
    }

    @Override
    public void clearResult() {
        this.newRacerData = null;
        this.clearChanges();
    }

    protected void computeChanges() {
    }

    protected ChangedValuesHolder constructChangedValues() {
        return new ChangedValuesHolder();
    }

    protected DefaultComboBoxModel<RaceOrganization> constructAffiliationListHolder() {
        return this.getToolUIModelServices().constructComboBoxListHolder(affiliationsList);
    }

    protected DefaultComboBoxModel<RaceClass<?>> constructRaceClassListHolder(Class<? extends RaceClass<?>> raceClassClass) {
        ArrayList ageClasses = new ArrayList();
        for (RaceClass<?> raceClass : this.raceClassHelper.getRaceClassValues(raceClassClass)) {
            if (!raceClass.isAgeGroupClass()) continue;
            ageClasses.add(raceClass);
        }
        Collections.sort(ageClasses, new Comparator<RaceClass<?>>(){

            @Override
            public int compare(RaceClass<?> c1, RaceClass<?> c2) {
                return c1.compareAge(c2);
            }
        });
        ageClasses.add(0, this.raceClassHelper.getUnknownClass(raceClassClass, Gender.WOMEN));
        ageClasses.add(1, this.raceClassHelper.getUnknownClass(raceClassClass, Gender.MEN));
        return this.getToolUIModelServices().constructComboBoxListHolder(ageClasses);
    }

    @Override
    protected String defaultWindowClassName() {
        return this.defaultWindowClassName(THIS_CLASS);
    }

    public DefaultComboBoxModel<RaceOrganization> getAffiliationListHolder() {
        return this.affiliationListHolder;
    }

    public DefaultComboBoxModel<RaceClass<?>> getAgeClassListHolder() {
        return this.ageClassListHolder;
    }

    public PlainTextDocument getBibNumberHolder() {
        return this.bibNumberHolder;
    }

    public PlainTextDocument getBirthYearHolder() {
        return this.birthYearHolder;
    }

    protected String getBirthYearString(Racer aRacer) {
        return aRacer.isBirthYearKnown() ? "" + aRacer.getBirthYear() : this.unknownBirthYearString();
    }

    protected ChangedValuesHolder getChangedValues() {
        if (this.changedValues == null) {
            this.changedValues = this.constructChangedValues();
            this.computeChanges();
        }
        return this.changedValues;
    }

    public PlainTextDocument getFirstNameHolder() {
        return this.firstNameHolder;
    }

    public PlainTextDocument getLastNameHolder() {
        return this.lastNameHolder;
    }

    public Racer getNewRacerData() {
        return this.newRacerData;
    }

    protected ToolSessionRacerList getRacerList() {
        return this.racerList;
    }

    protected List<Racer> getOtherRegisteredRacersWithSameName(String lastName, String firstName) {
        List<Racer> matchingRacers = (List<Racer>)this.getChangedValues().get(CHANGE_DATA_MATCHING_RACERS);
        if (matchingRacers == null) {
            matchingRacers = RacerNameChecker.getCurrent().getAllRacersWithSameName(this.getRacerList(), lastName, firstName);
            this.getChangedValues().recordValue(CHANGE_DATA_MATCHING_RACERS, matchingRacers);
        }
        return matchingRacers;
    }

    protected SeasonIdentifier getSeason() {
        return this.season;
    }

    public RaceOrganization getSelectedAffiliation() {
        Object selectedItem = this.getAffiliationListHolder().getSelectedItem();
        return selectedItem instanceof RaceOrganization ? (RaceOrganization)selectedItem : RaceOrganization.getConstant((String)selectedItem);
    }

    public RaceClass<?> getSelectedAgeClass() {
        return (RaceClass)this.getAgeClassListHolder().getSelectedItem();
    }

    public RaceClass<?> getSelectedNationalClass() {
        return (RaceClass)this.getNationalClassListHolder().getSelectedItem();
    }

    public DefaultComboBoxModel<RaceClass<?>> getNationalClassListHolder() {
        return this.nationalClassListHolder;
    }

    public String getTitle() {
        return DIALOG_TITLE;
    }

    public PlainTextDocument getUSSANumberHolder() {
        return this.ussaNumberHolder;
    }

    public boolean hasChanges() {
        return this.getChangedValues().size() > 0;
    }

    protected void initializeModels() {
        Class<? extends RaceClass<?>> ageClassClass = this.getRacerList().getAgeClassClass();
        Class<? extends RaceClass<?>> nationalClassClass = this.raceClassHelper.getNationalClassClass(ageClassClass);
        this.nationalClassMapsDirectlyFromAgeClass = RaceClassRegistry.current().getAgeRange(ageClassClass) == RaceClassRegistry.current().getAgeRange(nationalClassClass);
        this.lastNameHolder = new PlainTextDocument();
        this.firstNameHolder = new PlainTextDocument();
        this.bibNumberHolder = new PlainTextDocument();
        this.ageClassListHolder = this.constructRaceClassListHolder(ageClassClass);
        this.nationalClassListHolder = this.constructRaceClassListHolder(nationalClassClass);
        this.birthYearHolder = new PlainTextDocument();
        this.affiliationListHolder = this.constructAffiliationListHolder();
        this.ussaNumberHolder = new PlainTextDocument();
    }

    protected void initRacerDataValues(Racer aRacer) {
        this.getLastNameHolder().setText(aRacer.getLastName());
        this.getFirstNameHolder().setText(aRacer.getFirstName());
        this.getBibNumberHolder().setText(aRacer.getBib());
        this.getAgeClassListHolder().setSelectedItem(aRacer.getAgeClass());
        this.getNationalClassListHolder().setSelectedItem(aRacer.getNationalClass());
        this.getBirthYearHolder().setText(this.getBirthYearString(aRacer));
        this.getAffiliationListHolder().setSelectedItem(aRacer.getAffiliation());
        this.getUSSANumberHolder().setText(aRacer.getUSSALicense().toString());
    }

    protected boolean isBibNumberRequired() {
        return this.racerList.getManagementPolicy().isBibNumberRequired();
    }

    public boolean mapsAgeClassToNationalClass() {
        return this.nationalClassMapsDirectlyFromAgeClass;
    }

    protected RaceClass<?> mapAgeClassToNationalClass(RaceClass<? extends RaceClass<?>> ageClass) {
        RaceClass<?> nationalClass = this.raceClassHelper.toNationalClass(ageClass);
        if (nationalClass == null) {
            throw new IllegalArgumentException("Age class mapping to national class failed: " + ageClass);
        }
        this.getNationalClassListHolder().setSelectedItem(nationalClass);
        return nationalClass;
    }

    public void setNextAvailableBibNumber() {
        this.getBibNumberHolder().setText("" + this.racerList.getManagementPolicy().getNextAvailableBibNumber());
    }

    protected void setRacerBirthYear(Racer aRacer, int yearBorn) {
        aRacer.setBirthYear(yearBorn);
        if (aRacer.getNationalClass().isUnknown()) {
            aRacer.initNationalClass(this.getSeason());
        }
    }

    protected abstract String unknownBirthYearString();

    protected void validateAgeClass(RaceClass<?> ageClass, ValidationResult validationResult) {
        String propertyName = PROPERTY_AGE_CLASS;
        if (ageClass.isUnknown()) {
            this.validationFailed(propertyName, "The racer's age class must be specified.", validationResult);
            return;
        }
    }

    protected void validateAgeClassConsistency(RaceClass<?> ageClass, RaceClass<?> nationalClass, ValidationResult validationResult) {
        if (!nationalClass.isUnknown()) {
            Class<? extends RaceClass<?>> nationalClassClass;
            String propertyName = PROPERTY_NATIONAL_CLASS;
            if (nationalClass.getGender() != ageClass.getGender()) {
                this.validationFailed(propertyName, "Inconsistent gender: division and national age classes must have the same gender.", validationResult);
                return;
            }
            Class<?> ageClassClass = ageClass.getClass();
            if (ageClassClass.equals(nationalClassClass = this.raceClassHelper.getNationalClassClass(ageClassClass))) {
                if (!ageClassClass.equals(nationalClassClass)) {
                    this.validationFailed(propertyName, "Inconsistent age: national class must be same as age class.", validationResult);
                    return;
                }
            } else if (ageClass.isInternationalClass()) {
                if (this.raceClassHelper.toNationalClass(ageClass) != nationalClass) {
                    this.validationFailed(propertyName, "Inconsistent age: national class age range is inconsistent with the international age class.", validationResult);
                    return;
                }
            } else if (this.raceClassHelper.toDivisionAgeClass(nationalClass, ageClassClass) != ageClass) {
                this.validationFailed(propertyName, "Inconsistent age: national class age range is inconsistent with the division age class.", validationResult);
                return;
            }
        }
    }

    protected void validateAgeClassConsistency(RaceClass<?> ageClass, RaceClass<?> nationalClass, int yearBorn, ValidationResult validationResult) {
        int currentAge = Racer.computeRacerAge(yearBorn, this.getSeason());
        String propertyName = PROPERTY_AGE_CLASS;
        if (!ageClass.includesAge(currentAge)) {
            this.validationFailed(propertyName, "Age class " + ageClass.name + " is incorrect for the racer's birthdate (current age is " + currentAge + ").", validationResult);
            return;
        }
        propertyName = PROPERTY_NATIONAL_CLASS;
        if (!nationalClass.isUnknown() && !nationalClass.includesAge(currentAge)) {
            this.validationFailed(propertyName, "National age class " + nationalClass.name + " is incorrect for the racer's birthdate (current age is " + currentAge + ").", validationResult);
            return;
        }
    }

    protected void validateBibNumber(String lastName, String firstName, ValidationResolver validationResolver, ValidationResult validationResult) {
        int bibNumber;
        String racerName = firstName + " " + lastName;
        String propertyName = PROPERTY_BIB_NUMBER;
        String newValue = (String)this.getChangedValues().get(propertyName);
        if (newValue == null) {
            return;
        }
        if (newValue.length() == 0 && this.isBibNumberRequired()) {
            this.validationFailed(propertyName, "You must specify a value for the bib number.", validationResult);
            return;
        }
        try {
            bibNumber = Integer.parseInt(newValue);
        }
        catch (NumberFormatException ex) {
            this.validationFailed(propertyName, "You must specify an integer value for the bib number.", validationResult);
            return;
        }
        this.racerList.getManagementPolicy().validateBibNumber(bibNumber, racerName, validationResolver, validationResult);
        if (validationResult.failed()) {
            this.validationFailedWrapup(propertyName, validationResult);
            return;
        }
        this.getChangedValues().recordValue(propertyName, bibNumber);
    }

    protected void validateBibNumber(int bibNumber, RaceOrganization affiliation, String lastName, String firstName, String propertyName, ValidationResolver validationResolver, ValidationResult validationResult) {
        String racerName = firstName + " " + lastName;
        this.racerList.getManagementPolicy().validateBibNumber(bibNumber, affiliation, racerName, validationResolver, validationResult);
        if (validationResult.failed()) {
            this.validationFailedWrapup(propertyName, validationResult);
            return;
        }
    }

    protected void validateBirthYear(ValidationResult validationResult) {
        int yearBorn;
        String propertyName = PROPERTY_BIRTH_YEAR;
        String newValue = (String)this.getChangedValues().get(propertyName);
        if (newValue == null) {
            return;
        }
        if (newValue.length() == 0) {
            this.getChangedValues().recordValue(propertyName, -1);
            return;
        }
        try {
            yearBorn = Integer.parseInt(newValue);
        }
        catch (NumberFormatException ex) {
            this.validationFailed(propertyName, "Birth year must be an integer value, e.g. '1984'. ", validationResult);
            return;
        }
        if (yearBorn < 1900 || yearBorn > this.getSeason().startYear - 10) {
            this.validationFailed(propertyName, "Birth year is not a valid value for a current masters racer.", validationResult);
            return;
        }
        this.getChangedValues().recordValue(propertyName, yearBorn);
    }

    public ValidationResult validateChanges(ValidationResolver validationResolver) {
        ValidationResult validationResult = new ValidationResult();
        this.validationFailed("(all)", "Subclass must implement validation logic", validationResult);
        return validationResult;
    }

    protected void validateLicenseAndAffiliationConsistency(RaceOrganization affiliation, String ussaNumber, ValidationResolver validationResolver, ValidationResult validationResult) {
        String propertyName = PROPERTY_AFFILIATION;
        if (ussaNumber == null || ussaNumber.equals("9999999")) {
            return;
        }
        RaceOrganization licenseAffiliation = USSALicense.getAffiliation(ussaNumber);
        if (licenseAffiliation == null || licenseAffiliation == affiliation || licenseAffiliation == RaceOrganization.UNKNOWN) {
            return;
        }
        if (affiliation == RaceOrganization.UNKNOWN || affiliation == RaceOrganization.TEMP) {
            String message = "Set affilation to " + licenseAffiliation.name + "?";
            if (validationResolver.confirm(propertyName, message)) {
                this.getAffiliationListHolder().setSelectedItem(licenseAffiliation);
                this.getChangedValues().recordValue(propertyName, licenseAffiliation);
            }
            return;
        }
        if (licenseAffiliation == RaceOrganization.FOREIGN) {
            if (affiliation.isForeignOrganization()) {
                return;
            }
            String message = "The racer's license number indicates a foreign competitor, but you have specified " + affiliation.name + " for the affiliation.\n\nAre you sure this is what you meant?";
            if (!validationResolver.confirm(propertyName, message)) {
                this.validationFailed(propertyName, "Affiliation " + affiliation.name + " inconsistent with license affiliation " + licenseAffiliation.name, validationResult);
                return;
            }
            return;
        }
        String message = "The racer's license number indicates that they are registered in division " + licenseAffiliation.name + ", but you have specified " + affiliation.name + " for the affiliation.\n\nAre you sure this is what you meant?";
        if (!validationResolver.confirm(message, message)) {
            this.validationFailed(propertyName, "Affiliation " + affiliation.name + " inconsistent with license affiliation " + licenseAffiliation.name, validationResult);
            return;
        }
    }

    protected void validateName(String lastName, String firstName, ValidationResult validationResult) {
        if (lastName.length() == 0) {
            this.validationFailed(PROPERTY_LAST_NAME, "You must specify the racer's last name", validationResult);
            return;
        }
        if (firstName.length() == 0) {
            this.validationFailed(PROPERTY_FIRST_NAME, "You must specify the racer's first name", validationResult);
        }
    }

    protected void validateUSSANumber(String lastName, String firstName, ValidationResolver validationResolver, ValidationResult validationResult) {
        String racerName = firstName + " " + lastName;
        String propertyName = PROPERTY_USSA_NUMBER;
        String newValue = (String)this.getChangedValues().get(propertyName);
        if (newValue == null) {
            return;
        }
        this.racerList.getManagementPolicy().validateUSSANumber(newValue, racerName, validationResolver, validationResult);
        if (validationResult.failed()) {
            this.validationFailedWrapup(propertyName, validationResult);
            return;
        }
    }

    protected void validationFailed(String propertyName, String problemDescription, ValidationResult validationResult) {
        this.clearChanges();
        validationResult.reportProblem(propertyName, problemDescription);
    }

    protected void validationFailedWrapup(String propertyName, ValidationResult validationResult) {
        this.clearChanges();
        validationResult.setAspect(propertyName);
    }

    protected void verifyNameIsNotAlreadyRegistered(String lastName, String firstName, RaceClass<?> ageClass, ValidationResult validationResult) {
        String racerName = firstName + " " + lastName;
        List<Racer> matchingRacers = this.getOtherRegisteredRacersWithSameName(lastName, firstName);
        if (matchingRacers.size() == 0) {
            return;
        }
        for (Racer registeredRacer : matchingRacers) {
            if (registeredRacer.getAgeClass() == ageClass) {
                this.validationFailed(PROPERTY_LAST_NAME, "Racer " + racerName + " is already registered in " + ageClass.name + " (bib number" + registeredRacer.getBib() + ").", validationResult);
                return;
            }
            if (!registeredRacer.getAgeClass().equalAgeRange(ageClass)) continue;
            this.validationFailed(PROPERTY_LAST_NAME, "Racer " + racerName + " is already registered in class " + registeredRacer.getAgeClass().name + ".\n\nYou need to resolve the gender confusion with the existing racer entry.", validationResult);
            return;
        }
    }

    protected void verifyNationalClassIsAcceptable(RaceClass<?> nationalClass, int yearBorn, ValidationResolver validationResolver, ValidationResult validationResult) {
        String propertyName = PROPERTY_NATIONAL_CLASS;
        Class<?> nationalClassClass = nationalClass.getClass();
        if (nationalClass.isUnknown()) {
            int currentAge = Racer.computeRacerAge(yearBorn, this.getSeason());
            nationalClass = this.raceClassHelper.raceClassForAge(this.getSelectedAgeClass().getGender(), currentAge, nationalClassClass);
            String message = "The national class for this racer will be set to " + nationalClass.name + ", based on the birthdate you have specified.\n\nProceed?";
            if (!validationResolver.confirm(propertyName, message)) {
                this.validationFailed(propertyName, "National class would be set to " + nationalClass.name, validationResult);
                return;
            }
            this.getChangedValues().recordValue(propertyName, nationalClass);
        }
    }

    protected void verifySimilarNameRegistrationIsAcceptable(String lastName, String firstName, ValidationResolver validationResolver, ValidationResult validationResult) {
        String racerName = firstName + " " + lastName;
        List<Racer> matchingRacers = this.getOtherRegisteredRacersWithSameName(lastName, firstName);
        int nMatches = matchingRacers.size();
        String propertyName = PROPERTY_LAST_NAME;
        if (nMatches > 0) {
            if (nMatches == 1) {
                Racer registeredRacer = matchingRacers.get(0);
                String message = "Racer " + racerName + " is already registered under bib " + registeredRacer.getBib() + " in class " + registeredRacer.getAgeClass().name + "\n\nAre you sure you want to add what may be a duplicate racer entry?";
                if (!validationResolver.confirm(propertyName, message)) {
                    this.validationFailed(propertyName, "Racer " + racerName + " is already registered in class " + registeredRacer.getAgeClass().name, validationResult);
                    return;
                }
            } else {
                String message = "There are currently " + nMatches + " other racers already registered with this name.\n\nAre you sure you want to add what may be a duplicate racer entry?";
                if (!validationResolver.confirm(propertyName, message)) {
                    this.validationFailed(propertyName, "Racer " + racerName + " is already registered.", validationResult);
                    return;
                }
            }
        }
    }

    static {
        EditRacerDataDialog.initStaticData();
    }
}

