/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.tools.ui;

import java.awt.Window;
import java.util.List;
import org.ussamasters.aces.racedata.models.RaceClass;
import org.ussamasters.aces.racedata.models.RaceOrganization;
import org.ussamasters.aces.racedata.models.Racer;
import org.ussamasters.aces.racedata.models.USSALicense;
import org.ussamasters.aces.tools.foundation.models.ToolSessionRacerList;
import org.ussamasters.aces.tools.foundation.processors.ValidationResolver;
import org.ussamasters.aces.tools.foundation.processors.ValidationResult;
import org.ussamasters.aces.tools.ui.EditRacerDataDialog;

public class EditRacerDialog
extends EditRacerDataDialog {
    private static final String DIALOG_TITLE = "Edit Racer";
    protected static final String UNKNOWN_BIRTH_YEAR = "";
    protected Racer theRacer;

    public static boolean openOn(Racer aRacer, ToolSessionRacerList racerList, Window aWindow) {
        EditRacerDialog aDialog = new EditRacerDialog(aRacer, aWindow, racerList);
        aDialog.openWindow();
        return aDialog.getNewRacerData() != null;
    }

    protected EditRacerDialog(Racer aRacer, Window aWindow, ToolSessionRacerList racerList) {
        super(aWindow, racerList);
        this.setRacer(aRacer);
        this.initRacerDataValues();
    }

    @Override
    public void acceptChanges() {
        Object newValue = this.getChangedValues().get("bibNumber");
        if (newValue != null) {
            this.getRacer().setBibNumber((Integer)newValue);
        }
        if ((newValue = this.getChangedValues().get("lastName")) != null) {
            this.getRacer().setLastName((String)newValue);
        }
        if ((newValue = this.getChangedValues().get("firstName")) != null) {
            this.getRacer().setFirstName((String)newValue);
        }
        if ((newValue = this.getChangedValues().get("affiliation")) != null) {
            this.getRacer().setAffiliation((RaceOrganization)newValue);
        }
        if ((newValue = this.getChangedValues().get("ageClass")) != null) {
            this.getRacer().setAgeClass((RaceClass)newValue);
        }
        if ((newValue = this.getChangedValues().get("nationalClass")) != null) {
            this.getRacer().setNationalClass((RaceClass)newValue);
        }
        if ((newValue = this.getChangedValues().get("birthYear")) != null) {
            this.setRacerBirthYear(this.getRacer(), (Integer)newValue);
        }
        if ((newValue = this.getChangedValues().get("ussaNumber")) != null) {
            this.getRacer().setUSSALicense(USSALicense.fromString((String)newValue));
        }
        this.clearChanges();
        this.newRacerData = this.getRacer();
    }

    @Override
    protected void computeChanges() {
        RaceClass newAgeClass;
        super.computeChanges();
        this.getChangedValues().recordValueIfChanged("lastName", this.getRacer().getLastName(), this.getLastNameHolder().getText().trim());
        this.getChangedValues().recordValueIfChanged("firstName", this.getRacer().getFirstName(), this.getFirstNameHolder().getText().trim());
        this.getChangedValues().recordValueIfChanged("bibNumber", this.getRacer().getBib(), this.getBibNumberHolder().getText().trim());
        this.getChangedValues().recordValueIfChanged("ageClass", this.getRacer().getAgeClass(), this.getSelectedAgeClass());
        if (this.mapsAgeClassToNationalClass() && (newAgeClass = (RaceClass)this.getChangedValues().get("ageClass")) != null) {
            this.mapAgeClassToNationalClass(newAgeClass);
        }
        this.getChangedValues().recordValueIfChanged("nationalClass", this.getRacer().getNationalClass(), this.getSelectedNationalClass());
        this.getChangedValues().recordValueIfChanged("birthYear", this.getBirthYearString(this.getRacer()), this.getBirthYearHolder().getText().trim());
        this.getChangedValues().recordValueIfChanged("affiliation", this.getRacer().getAffiliation(), this.getSelectedAffiliation());
        this.getChangedValues().recordValueIfChanged("ussaNumber", this.getRacer().getUSSALicense().toString(), this.getUSSANumberHolder().getText().trim());
    }

    protected Racer getRacer() {
        return this.theRacer;
    }

    @Override
    protected List<Racer> getOtherRegisteredRacersWithSameName(String lastName, String firstName) {
        List<Racer> racers = super.getOtherRegisteredRacersWithSameName(lastName, firstName);
        racers.remove(this.getRacer());
        return racers;
    }

    @Override
    public String getTitle() {
        return DIALOG_TITLE;
    }

    protected void initRacerDataValues() {
        this.initRacerDataValues(this.getRacer());
    }

    protected void setRacer(Racer aRacer) {
        this.theRacer = aRacer;
    }

    @Override
    protected String unknownBirthYearString() {
        return UNKNOWN_BIRTH_YEAR;
    }

    @Override
    public ValidationResult validateChanges(ValidationResolver validationResolver) {
        int bibNumber;
        String ussaNumber;
        ValidationResult validationResult = new ValidationResult();
        String newLastName = (String)this.getChangedValues().get("lastName");
        String newFirstName = (String)this.getChangedValues().get("firstName");
        RaceClass newAgeClass = (RaceClass)this.getChangedValues().get("ageClass");
        RaceClass newNationalClass = (RaceClass)this.getChangedValues().get("nationalClass");
        RaceOrganization newAffiliation = (RaceOrganization)this.getChangedValues().get("affiliation");
        String newUSSANumber = (String)this.getChangedValues().get("ussaNumber");
        String lastName = newLastName != null ? newLastName : this.getRacer().getLastName();
        String firstName = newFirstName != null ? newFirstName : this.getRacer().getFirstName();
        RaceClass<?> ageClass = this.getSelectedAgeClass();
        RaceClass<?> nationalClass = this.getSelectedNationalClass();
        RaceOrganization affiliation = this.getSelectedAffiliation();
        String string = ussaNumber = newUSSANumber != null ? newUSSANumber : this.getRacer().getUSSALicense().toString();
        if (newLastName != null || newFirstName != null) {
            this.validateName(lastName, firstName, validationResult);
            if (validationResult.failed()) {
                return validationResult;
            }
        }
        this.validateBibNumber(lastName, firstName, validationResolver, validationResult);
        if (validationResult.failed()) {
            return validationResult;
        }
        this.validateBirthYear(validationResult);
        if (validationResult.failed()) {
            return validationResult;
        }
        Integer newBibNumber = (Integer)this.getChangedValues().get("bibNumber");
        Integer newBirthYear = (Integer)this.getChangedValues().get("birthYear");
        int yearBorn = newBirthYear != null ? newBirthYear.intValue() : this.getRacer().getBirthYear();
        int n = bibNumber = newBibNumber != null ? newBibNumber.intValue() : this.getRacer().getBibNumber();
        if (newLastName != null || newFirstName != null || newAgeClass != null) {
            this.verifyNameIsNotAlreadyRegistered(lastName, firstName, ageClass, validationResult);
            if (validationResult.failed()) {
                return validationResult;
            }
        }
        if (newLastName != null || newFirstName != null) {
            this.verifySimilarNameRegistrationIsAcceptable(lastName, firstName, validationResolver, validationResult);
            if (validationResult.failed()) {
                return validationResult;
            }
        }
        if (newBibNumber != null) {
            this.validateBibNumber(bibNumber, affiliation, lastName, firstName, "bibNumber", validationResolver, validationResult);
            if (validationResult.failed()) {
                return validationResult;
            }
        } else if (newAffiliation != null) {
            this.validateBibNumber(bibNumber, newAffiliation, lastName, firstName, "affiliation", validationResolver, validationResult);
            if (validationResult.failed()) {
                return validationResult;
            }
        }
        if (newAgeClass != null) {
            this.validateAgeClass(newAgeClass, validationResult);
            if (validationResult.failed()) {
                return validationResult;
            }
        }
        if (newAgeClass != null || newNationalClass != null) {
            this.validateAgeClassConsistency(ageClass, nationalClass, validationResult);
            if (validationResult.failed()) {
                return validationResult;
            }
        }
        if ((newAgeClass != null || newNationalClass != null || newBirthYear != null) && yearBorn != -1) {
            this.validateAgeClassConsistency(ageClass, nationalClass, yearBorn, validationResult);
            if (validationResult.failed()) {
                return validationResult;
            }
        }
        if ((newNationalClass != null || newBirthYear != null) && yearBorn != -1) {
            this.verifyNationalClassIsAcceptable(nationalClass, yearBorn, validationResolver, validationResult);
            if (validationResult.failed()) {
                return validationResult;
            }
        }
        this.validateUSSANumber(lastName, firstName, validationResolver, validationResult);
        if (validationResult.failed()) {
            return validationResult;
        }
        if (newAffiliation != null || newUSSANumber != null) {
            this.validateLicenseAndAffiliationConsistency(affiliation, ussaNumber, validationResolver, validationResult);
            if (validationResult.failed()) {
                return validationResult;
            }
        }
        return ValidationResult.SUCCESS_RESULT;
    }
}

