/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.tools.ui;

import com.glaivestone.javax.io.FileType;
import java.io.File;
import java.util.List;
import org.ussamasters.aces.racedata.io.RaceDataIOException;
import org.ussamasters.aces.racedata.io.RaceDataIOServices;
import org.ussamasters.aces.racedata.models.RaceIdentifier;
import org.ussamasters.aces.racedata.models.RaceResult;
import org.ussamasters.aces.racedata.models.RacerList;
import org.ussamasters.aces.racedata.reports.RaceDataReportServices;
import org.ussamasters.aces.tools.foundation.models.ToolID;
import org.ussamasters.aces.tools.ui.RaceDataTool;

public class RaceResultDataTool
extends RaceDataTool {
    protected static final FileType[] REPORT_FORMATS = RaceDataReportServices.ALL_REPORT_TYPES;

    protected RaceResultDataTool(ToolID toolID, String title) {
        super(toolID, title);
    }

    protected RaceResult getRaceResult(RaceIdentifier raceID) {
        return this.getSessionManager().getRaceResult(raceID);
    }

    public RacerList getRaceResultCompetitorInfo(RaceIdentifier raceID) throws RaceDataIOException {
        return this.getSessionManager().getRaceResultCompetitorInfo(raceID);
    }

    protected RacerList getRaceResultCompetitors(RaceIdentifier raceID) throws RaceDataIOException {
        return this.getSessionManager().getRaceResultCompetitors(raceID);
    }

    public File getReportsDirectory() {
        return this.getSessionManager().getRaceReportsDirectory();
    }

    protected List<File> getResultReportFiles(RaceIdentifier raceID, FileType reportFileType) {
        return RaceDataReportServices.getReportFiles(RaceDataIOServices.raceResultsBaseFileName(raceID), reportFileType, this.getReportsDirectory());
    }

    public boolean hasReportsAvailable(RaceIdentifier aRace) {
        for (int i = 0; i < REPORT_FORMATS.length; ++i) {
            if (this.getResultReportFiles(aRace, REPORT_FORMATS[i]).size() <= 0) continue;
            return true;
        }
        return false;
    }

    public void generateRaceResultsReports(RaceIdentifier raceID, List<FileType> reportTypes, boolean displayReports) throws RaceDataIOException {
        RaceDataReportServices.writeRaceResultsReports(this.getRaceResult(raceID), this.getRaceResultCompetitors(raceID), reportTypes, this.getReportsDirectory(), displayReports);
    }
}

