/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.tools.ui.swing;

import com.glaivestone.mv.ApplicationView;
import com.glaivestone.mv.swing.JDialogApplicationView;
import com.glaivestone.toolbox.partsframer.FramerFactory;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import org.ussamasters.aces.tools.foundation.models.RaceScoringSessionManager;
import org.ussamasters.aces.tools.ui.RaceDataDialog;
import org.ussamasters.aces.tools.ui.RaceDataTool;
import org.ussamasters.aces.tools.ui.swing.ToolUIServices;

public class AboutDialogWindow
extends JDialogApplicationView {
    protected static ImageIcon splashScreenImage = null;
    protected String clientToolName = null;
    protected AboutDialogWindow dialogWindow = this;
    protected JLabel aboutImage = new JLabel();
    protected JButton okButton = new JButton();

    public static void openFor(ApplicationView aView) {
        AboutDialogWindow dialogWindow = new AboutDialogWindow(aView);
        dialogWindow.initializeWindow();
        dialogWindow.setVisible(true);
    }

    public AboutDialogWindow() {
    }

    public AboutDialogWindow(Dialog arg1) {
        super(arg1);
    }

    public AboutDialogWindow(ApplicationView clientView) {
        super((Frame)clientView.getMainWindow());
        this.clientToolName = this.myToolServices().getToolDisplayName(clientView);
    }

    public AboutDialogWindow(Frame clientWindow) {
        super(clientWindow);
        if (clientWindow instanceof ApplicationView) {
            this.clientToolName = this.myToolServices().getToolDisplayName((ApplicationView)((Object)clientWindow));
        }
    }

    public void init() {
        this.initMainWindow();
        this.initChildComponents();
    }

    protected void initMainWindow() {
        this.setName("dialogWindow");
        this.setModal(true);
        this.setResizable(false);
        this.setTitle("About Masters Race Scoring");
        this.setDefaultWindowSize();
        this.getContentPane().setLayout(FramerFactory.current.newLayoutManager());
    }

    public void initChildComponents() {
        this.initAboutImage();
        this.initOkButton();
    }

    public void initAboutImage() {
        this.aboutImage.setName("aboutImage");
        this.aboutImage.setText("<about Masters Race Scoring>");
        this.aboutImage.setBorder(BorderFactory.createEmptyBorder());
        FramerFactory.current.installComponent(this.aboutImage, this.dialogWindow.getContentPane(), 3, 136, 13.0f, 13.0f, 330.0f, 255.0f);
    }

    public void initOkButton() {
        this.okButton.setName("okButton");
        this.okButton.setText("OK");
        this.okButton.setMargin(new Insets(0, 0, 0, 0));
        FramerFactory.current.installComponent(this.okButton, this.dialogWindow.getContentPane(), 1, 66, 0.5f, 315.0f, 825.0f, 200.0f);
    }

    public void setDefaultWindowSize() {
        FramerFactory.current.setWindowSize(this, 1, 136, 1245.0f, 720.0f, 5445.0f, 5205.0f);
    }

    protected RaceScoringSessionManager mySessionManager() {
        return RaceScoringSessionManager.current;
    }

    protected ToolUIServices myToolServices() {
        return ToolUIServices.current;
    }

    protected ImageIcon getSplashScreenImage() {
        if (splashScreenImage == null) {
            splashScreenImage = (ImageIcon)this.mySessionManager().getSessionResource("SplashScreenFile");
        }
        return splashScreenImage;
    }

    @Override
    protected void initializeWindow() {
        this.init();
        boolean checkName = false;
        if (checkName && this.clientToolName != null) {
            this.dialogWindow.setTitle("About " + this.clientToolName);
        }
        this.aboutImage.setText(null);
        this.aboutImage.setIcon(this.getSplashScreenImage());
        this.configureConnections();
    }

    protected void configureConnections() {
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (AboutDialogWindow.this.getAppModel() != null) {
                    AboutDialogWindow.this.requestCloseWindow();
                } else {
                    AboutDialogWindow.this.dialogWindow.dispose();
                }
            }
        });
    }

    public static void main(String[] args) {
        try {
            RaceDataTool.initiateSession();
        }
        catch (Exception ex) {
            System.out.println("***SESSION INITIATION ERROR: " + ex.getMessage());
            System.exit(0);
        }
        RaceScoringSessionManager.current.closeSplashScreen();
        RaceDataDialog appModel = new RaceDataDialog();
        appModel.openWindow(new AboutDialogWindow());
    }
}

