/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.tools.ui.swing;

import com.glaivestone.javax.devx.DebugSupport;
import com.glaivestone.javax.swing.MessageDialog;
import com.glaivestone.javax.swing.SwingPatches;
import com.glaivestone.javax.swing.SwingServices;
import com.glaivestone.mv.BooleanHolder;
import com.glaivestone.toolbox.partsframer.FramerFactory;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.ussamasters.aces.racedata.io.RaceDataIOException;
import org.ussamasters.aces.racedata.models.PolicyID;
import org.ussamasters.aces.tools.foundation.models.RacerListManagementPolicySpecification;
import org.ussamasters.aces.tools.foundation.processors.ValidationResult;
import org.ussamasters.aces.tools.foundation.swing.UserConfirmationValidationResolver;
import org.ussamasters.aces.tools.ui.EditConfigurationSettingsDialog;
import org.ussamasters.aces.tools.ui.swing.ParameterSpecificationsPanel;
import org.ussamasters.aces.tools.ui.swing.ToolUIServices;
import org.ussamasters.aces.tools.ui.swing.WorkingSetSettingsEditorWindow;

public class EditConfigurationSettingsDialogWindow
extends WorkingSetSettingsEditorWindow {
    protected static final int N_PARMS_RACER_LIST_MANAGEMENT_POLICY = 4;
    protected static final float DY_PANEL_RACER_LIST_MANAGEMENT_POLICY_PARMS_TWIPS = ParameterSpecificationsPanel.computePanelHeight(4);
    protected static final float RACER_LIST_SETTINGS_PANEL_HEIGHT_TWIPS = 890.0f + DY_PANEL_RACER_LIST_MANAGEMENT_POLICY_PARMS_TWIPS + 300.0f;
    protected static final float REPORT_AND_FILE_SETTINGS_PANEL_HEIGHT_TWIPS = 1130.0f;
    public static final float DEFAULT_WIDTH_TWIPS = 9000.0f;
    public static final float DEFAULT_HEIGHT_TWIPS = RACE_SERIES_ID_PANEL_HEIGHT_TWIPS + 2940.0f + RACER_LIST_SETTINGS_PANEL_HEIGHT_TWIPS + 1130.0f + 405.0f + 840.0f;
    JLabel racerListManagementPolicyLabel;
    JComboBox<PolicyID> racerListManagementPolicyComboBox;
    ParameterSpecificationsPanel racerListManagementPolicyParmsPanel;
    JLabel racerListMergePolicyLabel;
    JComboBox<PolicyID> racerListMergePolicyComboBox;
    JCheckBox includeRacerAffiliationInReportsItem;
    JCheckBox includeRacePointsInTextReportsItem;
    JCheckBox saveReportScoringDataItem;
    JCheckBox saveReportFOItem;

    public EditConfigurationSettingsDialogWindow() {
    }

    public EditConfigurationSettingsDialogWindow(Dialog owner) {
        super(owner);
    }

    public EditConfigurationSettingsDialogWindow(Frame owner) {
        super(owner);
    }

    @Override
    protected void initMainWindow() {
        super.initMainWindow();
        this.dialogWindow.setTitle("Edit Configuration Settings");
        this.setDefaultWindowSize();
    }

    @Override
    protected void initChildComponents() {
        float leftOffsetValueCol = 1410.0f;
        float topOffset = 0.0f;
        this.initRaceSeriesIdentificationPanel(leftOffsetValueCol);
        this.initRaceSeriesSettingsPanel(0.0f, topOffset += RACE_SERIES_ID_PANEL_HEIGHT_TWIPS, leftOffsetValueCol);
        this.initRacerListSettingsPanel(topOffset += 2940.0f);
        this.initReportAndFileManagementSettingsPanel(topOffset += RACER_LIST_SETTINGS_PANEL_HEIGHT_TWIPS);
        topOffset += 1130.0f;
        this.initOperationButtonsPanel();
    }

    @Override
    protected JPanel initRaceSeriesSettingsPanel(float leftOffset, float topOffset, float leftOffsetValueCol) {
        JPanel aPanel = super.initRaceSeriesSettingsPanel(leftOffset, topOffset, leftOffsetValueCol);
        this.organizerComboBox.setEnabled(false);
        this.seriesTypeComboBox.setEnabled(false);
        SwingServices.current.applyReadOnlyLookAndFeel(this.seasonYearField);
        return aPanel;
    }

    @Override
    protected float initRacerSeriesNameItems(JPanel raceSeriesIdPanel, float itemTopOffset, float leftOffsetValueCol) {
        this.raceSeriesNameLabel = new JLabel();
        this.raceSeriesNameLabel.setText("Race Series");
        FramerFactory.current.installComponent(this.raceSeriesNameLabel, raceSeriesIdPanel, 1, 136, 0.0f, itemTopOffset, 1230.0f, 315.0f);
        this.raceSeriesNameField = new JTextField();
        this.raceSeriesNameField.setColumns(10);
        FramerFactory.current.installComponent(this.raceSeriesNameField, raceSeriesIdPanel, 1, 168, leftOffsetValueCol, itemTopOffset, 0.0f, 315.0f);
        SwingServices.current.applyReadOnlyLookAndFeel(this.raceSeriesNameField);
        return 415.0f;
    }

    @Override
    protected float initRaceSeriesDirectoryItems(JPanel raceSeriesIdPanel, float itemTopOffset, float leftOffsetValueCol) {
        this.workingSetDirectoryLabel = new JLabel();
        this.workingSetDirectoryLabel.setText("Stored in");
        FramerFactory.current.installComponent(this.workingSetDirectoryLabel, raceSeriesIdPanel, 1, 136, 0.0f, itemTopOffset, 1305.0f, 315.0f);
        this.workingSetDirectoryNameField = new JTextField();
        this.workingSetDirectoryNameField.setColumns(10);
        FramerFactory.current.installComponent(this.workingSetDirectoryNameField, raceSeriesIdPanel, 1, 168, leftOffsetValueCol, itemTopOffset, 0.0f, 315.0f);
        SwingServices.current.applyReadOnlyLookAndFeel(this.workingSetDirectoryNameField);
        return 415.0f;
    }

    protected JPanel initRacerListSettingsPanel(float topOffset) {
        float widthLabelCol = 1400.0f;
        float leftOffsetValueCol = 1500.0f;
        float itemTopOffset = 0.0f;
        JPanel aPanel = new JPanel();
        aPanel.setBorder(BorderFactory.createTitledBorder("Racer List Settings"));
        FramerFactory.current.installComponent(aPanel, this.contentPanel, 1, 168, 0.0f, topOffset, 0.0f, RACER_LIST_SETTINGS_PANEL_HEIGHT_TWIPS);
        aPanel.setLayout(FramerFactory.current.newLayoutManager());
        this.racerListManagementPolicyLabel = new JLabel();
        this.racerListManagementPolicyLabel.setText("Management policy");
        FramerFactory.current.installComponent(this.racerListManagementPolicyLabel, aPanel, 1, 136, 0.0f, itemTopOffset, widthLabelCol, 315.0f);
        this.racerListManagementPolicyComboBox = new JComboBox();
        this.myToolServices().installRenderer(this.racerListManagementPolicyComboBox, ToolUIServices.POLICY_ID_RENDERER);
        this.racerListManagementPolicyComboBox.setToolTipText("Policy for managing series racer list (bib ranges, etc)");
        FramerFactory.current.installComponent(this.racerListManagementPolicyComboBox, aPanel, 1, 168, leftOffsetValueCol, itemTopOffset, 0.0f, 345.0f);
        this.racerListManagementPolicyParmsPanel = new ParameterSpecificationsPanel(4, 2000.0f);
        FramerFactory.current.installComponent(this.racerListManagementPolicyParmsPanel, aPanel, 1, 168, leftOffsetValueCol, itemTopOffset += 445.0f, 0.0f, DY_PANEL_RACER_LIST_MANAGEMENT_POLICY_PARMS_TWIPS);
        this.racerListMergePolicyLabel = new JLabel();
        this.racerListMergePolicyLabel.setText("Reconcile policy");
        FramerFactory.current.installComponent(this.racerListMergePolicyLabel, aPanel, 1, 136, 0.0f, itemTopOffset += DY_PANEL_RACER_LIST_MANAGEMENT_POLICY_PARMS_TWIPS, widthLabelCol, 315.0f);
        this.racerListMergePolicyComboBox = new JComboBox();
        this.myToolServices().installRenderer(this.racerListMergePolicyComboBox, ToolUIServices.POLICY_ID_RENDERER);
        this.racerListMergePolicyComboBox.setToolTipText("Policy for merging new/unrecognized racers into series racer list during Reconcile");
        FramerFactory.current.installComponent(this.racerListMergePolicyComboBox, aPanel, 1, 168, leftOffsetValueCol, itemTopOffset, 0.0f, 345.0f);
        return aPanel;
    }

    protected JPanel initReportAndFileManagementSettingsPanel(float topOffset) {
        JPanel fileSettingsPanel;
        JPanel reportSettingsPanel;
        boolean doSubpanels = true;
        float leftOffsetReportSettings = 0.0f;
        float widthReportSettings = 3500.0f;
        float leftOffsetFileSettings = 4000.0f;
        float widthFileSettings = 3500.0f;
        float itemTopOffset = 0.0f;
        JPanel mainPanel = new JPanel();
        FramerFactory.current.installComponent(mainPanel, this.contentPanel, 1, 168, 0.0f, topOffset, 0.0f, 1130.0f);
        mainPanel.setLayout(FramerFactory.current.newLayoutManager());
        if (doSubpanels) {
            reportSettingsPanel = new JPanel();
            reportSettingsPanel.setBorder(BorderFactory.createTitledBorder("Report Settings"));
            FramerFactory.current.installComponent(reportSettingsPanel, mainPanel, 1, 136, leftOffsetReportSettings, 0.0f, widthReportSettings + 200.0f, 1130.0f);
            reportSettingsPanel.setLayout(FramerFactory.current.newLayoutManager());
            fileSettingsPanel = new JPanel();
            fileSettingsPanel.setBorder(BorderFactory.createTitledBorder("File Management Settings"));
            FramerFactory.current.installComponent(fileSettingsPanel, mainPanel, 1, 136, leftOffsetFileSettings, 0.0f, widthFileSettings + 200.0f, 1130.0f);
            fileSettingsPanel.setLayout(FramerFactory.current.newLayoutManager());
            leftOffsetFileSettings = 0.0f;
        } else {
            mainPanel.setBorder(BorderFactory.createTitledBorder("Report and File Management Settings"));
            reportSettingsPanel = mainPanel;
            fileSettingsPanel = mainPanel;
        }
        this.includeRacerAffiliationInReportsItem = new JCheckBox();
        this.includeRacerAffiliationInReportsItem.setText("include racer affiliation on reports");
        this.includeRacerAffiliationInReportsItem.setToolTipText("Turn this on for regional and national events, off for division events");
        FramerFactory.current.installComponent(this.includeRacerAffiliationInReportsItem, reportSettingsPanel, 1, 136, leftOffsetReportSettings, itemTopOffset, widthReportSettings, 315.0f);
        this.saveReportScoringDataItem = new JCheckBox();
        this.saveReportScoringDataItem.setText("save scoring data XML");
        this.saveReportScoringDataItem.setToolTipText("Advanced users may want turn this on; leave off to save space");
        FramerFactory.current.installComponent(this.saveReportScoringDataItem, fileSettingsPanel, 1, 136, leftOffsetFileSettings, itemTopOffset, widthFileSettings, 315.0f);
        this.includeRacePointsInTextReportsItem = new JCheckBox();
        this.includeRacePointsInTextReportsItem.setText("include race points on text reports");
        this.includeRacePointsInTextReportsItem.setToolTipText("Turn this off when you only want times");
        FramerFactory.current.installComponent(this.includeRacePointsInTextReportsItem, reportSettingsPanel, 1, 136, leftOffsetReportSettings, itemTopOffset += 415.0f, widthReportSettings, 315.0f);
        this.saveReportFOItem = new JCheckBox();
        this.saveReportFOItem.setText("save XSL-FO for scoring reports");
        this.saveReportFOItem.setToolTipText("Advanced users may want turn this on; leave off to save space");
        FramerFactory.current.installComponent(this.saveReportFOItem, fileSettingsPanel, 1, 136, leftOffsetFileSettings, itemTopOffset, widthFileSettings, 315.0f);
        return mainPanel;
    }

    public void setDefaultWindowSize() {
        FramerFactory.current.setWindowSize(this, 1, 136, 1530.0f, 1230.0f, 9000.0f, DEFAULT_HEIGHT_TWIPS);
    }

    protected EditConfigurationSettingsDialog myApp() {
        return (EditConfigurationSettingsDialog)this.getAppModel();
    }

    @Override
    protected void registerPropertyValueItems(Map<String, Object> mappingTable) {
        mappingTable.put("raceClassClasses", this.raceClassesComboBox);
        mappingTable.put("courseArrangement", this.courseArrangementComboBox);
        mappingTable.put("racerListManagementPolicy", this.racerListManagementPolicyComboBox);
        mappingTable.put("racerListMergePolicy", this.racerListMergePolicyComboBox);
        mappingTable.put("includeRacerAffiliationInReports", this.includeRacerAffiliationInReportsItem);
        mappingTable.put("includeRacePointsInTextReports", this.includeRacePointsInTextReportsItem);
        mappingTable.put("saveReportScoringData", this.saveReportScoringDataItem);
        mappingTable.put("saveReportFO", this.saveReportFOItem);
    }

    @Override
    protected void initializeWindow() {
        this.propertyValueItemMap = this.constructPropertyValueItemMap();
        this.dialogWindow.setTitle(this.myApp().getTitle());
        this.raceSeriesNameField.setText(this.myApp().getRaceSeriesName());
        this.workingSetDirectoryNameField.setText(this.myApp().getWorkingSetDirectory().getAbsolutePath());
        SwingPatches.installComboBoxModel(this.organizerComboBox, this.myApp().getSeriesOrganizerHolder());
        SwingPatches.installComboBoxModel(this.seriesTypeComboBox, this.myApp().getSeriesTypeHolder());
        this.seasonYearField.setText("" + this.myApp().getSeasonYearHolder().getValue());
        SwingPatches.installComboBoxModel(this.raceClassesComboBox, this.myApp().getSeriesRaceClassHolder());
        SwingPatches.installComboBoxModel(this.courseArrangementComboBox, this.myApp().getStandardCourseArrangementHolder());
        SwingPatches.installComboBoxModel(this.racerListManagementPolicyComboBox, this.myApp().getRacerListManagementPoliciesHolder());
        SwingPatches.installComboBoxModel(this.worldCupPointsComboBox, this.myApp().getWorldCupPointsHolder());
        SwingPatches.installComboBoxModel(this.racerListMergePolicyComboBox, this.myApp().getRacerListMergePoliciesHolder());
        this.initCheckBoxValue(this.includeRacerAffiliationInReportsItem, this.myApp().getIncludeRacerAffiliationInReportsHolder());
        this.initCheckBoxValue(this.includeRacePointsInTextReportsItem, this.myApp().getIncludeRacePointsInTextReportsHolder());
        this.initCheckBoxValue(this.saveReportScoringDataItem, this.myApp().getSaveReportScoringDataHolder());
        this.initCheckBoxValue(this.saveReportFOItem, this.myApp().getSaveReportFOHolder());
        this.updateRacerListManagementPolicyItems();
        this.configureConnections();
    }

    protected void configureConnections() {
        this.racerListManagementPolicyComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                if (event.getStateChange() == 1) {
                    EditConfigurationSettingsDialogWindow.this.selectRacerListManagementPolicy((PolicyID)event.getItem());
                }
            }
        });
        this.configureCheckBoxHandler(this.includeRacerAffiliationInReportsItem, this.myApp().getIncludeRacerAffiliationInReportsHolder());
        this.configureCheckBoxHandler(this.includeRacePointsInTextReportsItem, this.myApp().getIncludeRacePointsInTextReportsHolder());
        this.configureCheckBoxHandler(this.saveReportScoringDataItem, this.myApp().getSaveReportScoringDataHolder());
        this.configureCheckBoxHandler(this.saveReportFOItem, this.myApp().getSaveReportFOHolder());
        this.configureOperationButtonConnections();
    }

    protected void initCheckBoxValue(JCheckBox aCheckBox, BooleanHolder valueHolder) {
        aCheckBox.setSelected(valueHolder.getValue());
    }

    protected void configureCheckBoxHandler(final JCheckBox aCheckBox, final BooleanHolder valueHolder) {
        aCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                valueHolder.setValue(aCheckBox.isSelected());
            }
        });
    }

    @Override
    protected boolean acceptChanges() {
        RacerListManagementPolicySpecification policySpec = this.myApp().getSelectedRacerListManagementPolicySpec();
        if (!this.racerListManagementPolicyParmsPanel.collectParameterValues(policySpec)) {
            return false;
        }
        UserConfirmationValidationResolver validationResolver = this.myToolServices().constructUserConfirmationValidationResolver(this.dialogWindow);
        ValidationResult validationResult = this.myApp().validateChanges(validationResolver);
        if (validationResult.failed()) {
            Component valueItem = (Component)this.propertyValueItemMap.get(validationResult.getAspect());
            if (valueItem != null) {
                if (valueItem instanceof JTextField) {
                    ((JTextField)valueItem).selectAll();
                }
                valueItem.requestFocus();
            }
            if (validationResolver.numberOfDenials == 0) {
                MessageDialog.displayWarning("Invalid Settings Change", validationResult.getMessage(), this.dialogWindow);
            }
            return false;
        }
        try {
            this.myApp().acceptChanges();
        }
        catch (IOException ex) {
            this.reportSettingsChangeFailed(ex);
            return false;
        }
        catch (RaceDataIOException ex) {
            this.reportSettingsChangeFailed(ex);
            return false;
        }
        catch (RuntimeException ex) {
            this.reportSettingsChangeFailed(ex);
            return false;
        }
        return true;
    }

    protected void reportSettingsChangeFailed(Exception ex) {
        DebugSupport.current().dumpStack(ex);
        MessageDialog.displayError("Configuration Settings Change Failed", "Unable to save the configuration settings: " + ex.getMessage(), this.dialogWindow);
    }

    protected void selectRacerListManagementPolicy(PolicyID policyID) {
        this.myApp().selectRacerListManagementPolicy(policyID);
        this.updateRacerListManagementPolicyItems();
    }

    protected void updateRacerListManagementPolicyItems() {
        RacerListManagementPolicySpecification selectedSpec = this.myApp().getSelectedRacerListManagementPolicySpec();
        this.racerListManagementPolicyParmsPanel.installParameterValues(selectedSpec);
    }
}

