/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.tools.ui.swing;

import com.glaivestone.javax.devx.DebugSupport;
import com.glaivestone.javax.swing.MessageDialog;
import com.glaivestone.javax.swing.OperationAction;
import com.glaivestone.javax.swing.SwingPatches;
import com.glaivestone.javax.swing.SwingServices;
import com.glaivestone.toolbox.partsframer.FramerFactory;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import org.ussamasters.aces.racedata.io.RaceDataIOException;
import org.ussamasters.aces.tools.foundation.models.EventScoringRaceSeries;
import org.ussamasters.aces.tools.ui.EventScoringTool;
import org.ussamasters.aces.tools.ui.NewScoringEventDialog;
import org.ussamasters.aces.tools.ui.swing.SeriesScoringToolWindow;

public class EventScoringToolWindow
extends SeriesScoringToolWindow {
    public static final float DEFAULT_WIDTH_TWIPS = 8715.0f;
    public static final float DEFAULT_HEIGHT_TWIPS = 9000.0f;
    protected JMenuBar menuBar;
    protected JLabel scoringEventNamesLabel;
    protected JComboBox<String> scoringEventNamesComboBox;
    protected JButton newScoringEventButton;
    protected JLabel eventDescriptionLabel;
    protected JTextField eventDescriptionField;
    protected JButton editEventDescriptionButton;
    protected OperationAction newScoringEventAction;
    protected OperationAction deleteScoringEventAction;
    protected OperationAction editEventDescriptionAction;

    public EventScoringToolWindow() {
    }

    public EventScoringToolWindow(String title) {
        super(title);
    }

    @Override
    protected void initMainWindow() {
        super.initMainWindow();
        this.frameWindow.setTitle("Event Scoring Tool");
        this.menuBar = new JMenuBar();
        this.setDefaultWindowSize();
    }

    @Override
    public void initChildComponents() {
        float rightInsetSeriesDescriptionPanel = 1035.0f;
        float topInsetScoredRacesPanel = 1850.0f;
        float scoringFormulaWidth = 3705.0f;
        this.initRaceSeriesDescriptionPanel(rightInsetSeriesDescriptionPanel);
        this.initCombinedEventItemsPanel();
        this.initScoredRaceSeriesPanel(topInsetScoredRacesPanel);
        this.initScoringOperationsPanel(scoringFormulaWidth);
    }

    protected void initCombinedEventItemsPanel() {
        JPanel scoringEventItemsPanel = new JPanel();
        FramerFactory.current.installComponent(scoringEventItemsPanel, this.contentPanel, 1, 168, 0.0f, 945.0f, 0.0f, 810.0f);
        scoringEventItemsPanel.setLayout(FramerFactory.current.newLayoutManager());
        this.scoringEventNamesLabel = new JLabel();
        this.scoringEventNamesLabel.setName("scoringEventNamesLabel");
        this.scoringEventNamesLabel.setText("Scoring Event");
        FramerFactory.current.installComponent(this.scoringEventNamesLabel, scoringEventItemsPanel, 1, 136, 0.0f, 0.0f, 1560.0f, 315.0f);
        this.scoringEventNamesComboBox = new JComboBox();
        this.scoringEventNamesComboBox.setName("scoringEventNamesComboBox");
        FramerFactory.current.installComponent(this.scoringEventNamesComboBox, scoringEventItemsPanel, 1, 168, 1665.0f, 0.0f, 1035.0f, 345.0f);
        this.newScoringEventButton = new JButton();
        this.newScoringEventButton.setName("newScoringEventButton");
        this.newScoringEventButton.setText("New...");
        this.newScoringEventButton.setMargin(new Insets(0, 0, 0, 0));
        FramerFactory.current.installComponent(this.newScoringEventButton, scoringEventItemsPanel, 1, 40, 825.0f, 0.0f, 0.0f, 315.0f);
        this.eventDescriptionLabel = new JLabel();
        this.eventDescriptionLabel.setName("eventDescriptionLabel");
        this.eventDescriptionLabel.setText("Description");
        FramerFactory.current.installComponent(this.eventDescriptionLabel, scoringEventItemsPanel, 1, 136, 0.0f, 405.0f, 1155.0f, 315.0f);
        this.eventDescriptionField = new JTextField();
        this.eventDescriptionField.setName("eventDescriptionField");
        this.eventDescriptionField.setColumns(10);
        SwingServices.current.applyReadOnlyLookAndFeel(this.eventDescriptionField);
        FramerFactory.current.installComponent(this.eventDescriptionField, scoringEventItemsPanel, 1, 168, 1665.0f, 405.0f, 1035.0f, 315.0f);
        this.editEventDescriptionButton = new JButton();
        this.editEventDescriptionButton.setMargin(new Insets(0, 0, 0, 0));
        FramerFactory.current.installComponent(this.editEventDescriptionButton, scoringEventItemsPanel, 1, 40, 825.0f, 405.0f, 0.0f, 315.0f);
    }

    public void setDefaultWindowSize() {
        FramerFactory.current.setWindowSize(this, 1, 136, 165.0f, 390.0f, 8715.0f, 9000.0f);
    }

    protected EventScoringTool myApp() {
        return (EventScoringTool)this.getAppModel();
    }

    @Override
    protected String seriesFlavor() {
        return "event";
    }

    @Override
    protected void initializeWindow() {
        this.initOperationActions();
        this.configureAppNameWindowTitle();
        this.raceSeriesDescriptionPanel.setAppModel(this.myApp());
        SwingPatches.installComboBoxModel(this.scoringEventNamesComboBox, this.myApp().getEventNamesHolder());
        this.eventDescriptionField.setText(this.myApp().getEventDescription());
        this.scoredRaceSeriesPanel.setModel(this.myApp().getRaceSeriesHolder());
        SwingPatches.installComboBoxModel(this.scoringPoliciesComboBox, this.myApp().getScoringPoliciesHolder());
        this.reportFormatOptionsPanel.generateHTMLReportsCheckBox.setSelected(this.myApp().getGenerateHTMLReportsHolder().getValue());
        this.reportFormatOptionsPanel.generateTextReportsCheckBox.setSelected(this.myApp().getGenerateTextReportsHolder().getValue());
        this.reportFormatOptionsPanel.generatePrintReportsCheckBox.setSelected(this.myApp().getGeneratePdfReportsHolder().getValue());
        this.updateEventOperationItems();
        this.updateScoringPolicyItems();
        this.updateReportOperationItems();
        this.buildMenuBar();
        this.completeScoredRacesPanePopupMenu();
        this.configureConnections();
    }

    @Override
    protected void initOperationActions() {
        super.initOperationActions();
        this.newScoringEventAction = new OperationAction("New event...", "Create a new scoring event", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                EventScoringToolWindow.this.newScoringEvent();
            }
        });
        this.deleteScoringEventAction = new OperationAction("Delete", "Delete the selected scoring event", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                EventScoringToolWindow.this.deleteScoringEvent();
            }
        });
        this.editEventDescriptionAction = new OperationAction("Edit...", "Edit the event description", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                EventScoringToolWindow.this.editEventDescription();
            }
        });
    }

    protected void configureConnections() {
        this.scoringEventNamesComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                if (event.getStateChange() == 1) {
                    EventScoringToolWindow.this.selectScoringEvent((String)event.getItem());
                }
            }
        });
        this.newScoringEventButton.setAction(this.newScoringEventAction);
        this.newScoringEventButton.setText("New...");
        this.editEventDescriptionButton.setAction(this.editEventDescriptionAction);
        this.configureRaceSeriesItemConnections();
        this.configureScoringOperationItemConnections();
    }

    protected void buildMenuBar() {
        this.frameWindow.setJMenuBar(this.menuBar);
        this.menuBar.add(this.buildFileMenu());
        this.menuBar.add(this.scoredRaceSeriesPanel.buildSeriesMenu(new OperationAction[]{this.newScoringEventAction, this.deleteScoringEventAction}));
        this.menuBar.add(this.buildReportMenu());
        this.menuBar.add(this.myToolServices().buildStandardHelpMenu(this.frameWindow));
    }

    protected JMenu buildFileMenu() {
        JMenu aMenu = this.myToolServices().constructFileMenu();
        if (this.myApp().supportsWorkingSetSwitching()) {
            this.myToolServices().appendRaceSeriesWorkingSetItems(aMenu, this.frameWindow, this.myApp());
            aMenu.addSeparator();
        }
        this.openCorrectionsLogAction.appendTo(aMenu);
        aMenu.addSeparator();
        this.myToolServices().appendApplicationCloseItem(aMenu, this.frameWindow);
        return aMenu;
    }

    protected JMenu buildReportMenu() {
        JMenu aMenu = new JMenu("Report");
        aMenu.setToolTipText("Event scoring report operations");
        this.generateReportsAction.appendTo(aMenu);
        aMenu.addSeparator();
        this.viewHTMLReportsAction.appendTo(aMenu);
        this.viewTextReportsAction.appendTo(aMenu);
        this.viewPdfReportsAction.appendTo(aMenu);
        aMenu.addSeparator();
        this.deleteReportsAction.appendTo(aMenu);
        aMenu.addSeparator();
        this.viewReportsAction.appendTo(aMenu);
        return aMenu;
    }

    protected void completeScoredRacesPanePopupMenu() {
        JPopupMenu aMenu = this.scoredRaceSeriesPanel.getScoredRacesPanePopupMenu();
        aMenu.addSeparator();
        this.generateReportsAction.appendTo(aMenu);
        this.viewHTMLReportsAction.appendTo(aMenu);
        this.viewTextReportsAction.appendTo(aMenu);
        this.deleteReportsAction.appendTo(aMenu);
        aMenu.addSeparator();
        this.openCorrectionsLogAction.appendTo(aMenu);
    }

    protected void updateEventOperationItems() {
        boolean hasEvents = this.myApp().getEventNamesHolder().getSize() > 0;
        this.deleteScoringEventAction.setEnabled(hasEvents);
        this.editEventDescriptionButton.setEnabled(hasEvents);
        this.scoredRaceSeriesPanel.enableEventOperations(hasEvents);
    }

    protected void newScoringEvent() {
        EventScoringRaceSeries newEvent = NewScoringEventDialog.openFor(this.frameWindow);
        if (newEvent == null) {
            return;
        }
        String eventName = newEvent.getName();
        try {
            this.myApp().addScoringEvent(newEvent);
        }
        catch (RaceDataIOException ex) {
            this.reportScoringEventCreationFailure(ex, eventName);
            return;
        }
        catch (RuntimeException ex) {
            this.reportScoringEventCreationFailure(ex, eventName);
            return;
        }
        this.scoringEventNamesComboBox.setSelectedItem(eventName);
        this.updateEventOperationItems();
    }

    protected void deleteScoringEvent() {
        String selectedEvent = this.myApp().getSelectedEventName();
        if (selectedEvent == null) {
            return;
        }
        String msg = "Are you sure you want to delete the scoring event '" + selectedEvent + "'?";
        if (!MessageDialog.confirm(msg, this.frameWindow)) {
            return;
        }
        try {
            this.myApp().deleteScoringEvent(selectedEvent);
        }
        catch (RuntimeException ex) {
            this.reportScoringEventDeleteFailure(ex, selectedEvent);
            return;
        }
        this.updateEventOperationItems();
        this.updateReportOperationItems();
    }

    protected void editEventDescription() {
        String description = this.myApp().getEventDescription();
        if ((description = (String)JOptionPane.showInputDialog(this.frameWindow, "Description:", "Edit Event Description", -1, null, null, description)) == null) {
            return;
        }
        description = description.trim();
        try {
            this.myApp().setEventDescription(description);
            this.eventDescriptionField.setText(this.myApp().getEventDescription());
        }
        catch (IOException ex) {
            MessageDialog.displayWarning("Edit Failed", "Unable to save the event specification with the new description", this.frameWindow);
        }
    }

    protected void selectScoringEvent(String eventName) {
        try {
            this.myApp().selectEvent(eventName);
        }
        catch (RaceDataIOException ex) {
            this.reportScoringEventSelectionFailure(ex, eventName);
            return;
        }
        catch (RuntimeException ex) {
            this.reportScoringEventSelectionFailure(ex, eventName);
            return;
        }
        this.eventDescriptionField.setText(this.myApp().getEventDescription());
        this.updateScoringPolicyItems();
        this.updateReportOperationItems();
    }

    protected void reportScoringEventSelectionFailure(Throwable ex, String eventName) {
        DebugSupport.current().dumpStack(ex);
        MessageDialog.displayError("Unable to Load Data", "Unable to load scoring event data for " + eventName + ": " + ex.getMessage(), this.frameWindow);
    }

    protected void reportScoringEventCreationFailure(Throwable ex, String eventName) {
        DebugSupport.current().dumpStack(ex);
        MessageDialog.displayError("Create Scoring Event Failed", "Unable to load scoring event data for " + eventName + ": " + ex.getMessage(), this.frameWindow);
    }

    protected void reportScoringEventDeleteFailure(Throwable ex, String eventName) {
        DebugSupport.current().dumpStack(ex);
        MessageDialog.displayError("Delete Scoring Event Failed", "Unable to delete scoring event " + eventName + ": " + ex.getMessage(), this.frameWindow);
    }

    public static void main(String[] args) {
        EventScoringTool.initiateSession();
        try {
            EventScoringTool appModel = new EventScoringTool();
            appModel.openWindow(new EventScoringToolWindow());
        }
        catch (RaceDataIOException ex) {
            System.err.println("***ERROR LAUNCHING EventScoringTool***");
            ex.printStackTrace();
        }
    }
}

